/*Definitions for switches for Pascal.
  Copyright (C) 1997-2002 Free Software Foundation, Inc.

  Authors: Peter Gerwinski <peter@gerwinski.de>
           Frank Heckenbach <frank@pascal.gnu.de>

  This file is part of GNU Pascal.

  GNU Pascal is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published
  by the Free Software Foundation; either version 2, or (at your
  option) any later version.

  GNU Pascal is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with GNU Pascal; see the file COPYING. If not, write to the
  Free Software Foundation, 59 Temple Place - Suite 330, Boston, MA
  02111-1307, USA. */

/* This is the contribution to the `lang_options' array in gcc.c for
   gpc. */

#ifndef OPTIONS_ONLY
#include "gcc-version.h"

#ifdef EGCS
DEFINE_LANG_NAME ("Pascal")
#endif

#ifndef GPC_OPT
#  ifdef EGCS
#    define GPC_OPT(SOURCE, NAME, DESCRIPTION) { NAME, DESCRIPTION }
#  else
#    define GPC_OPT(SOURCE, NAME, DESCRIPTION) NAME
#  endif
#endif
#endif

  GPC_OPT (1, "-fclassic-pascal-level-0",
           "Reject conformant arrays and anything besides ISO-7185 Pascal"),
  GPC_OPT (1, "-fclassic-pascal",
           "Reject anything besides ISO-7185 Pascal"),
  GPC_OPT (1, "-fstandard-pascal-level-0",
           "Reject conformant arrays and anything besides ISO-7185 Pascal"),
  GPC_OPT (1, "-fstandard-pascal",
           "Reject anything besides ISO-7185 Pascal"),
  GPC_OPT (1, "-fextended-pascal",
           "Reject anything besides ISO-10206 Extended Pascal"),
  GPC_OPT (1, "-fobject-pascal",
           "Reject anything besides (the implemented parts of) ANSI draft Object Pascal"),
  GPC_OPT (1, "-fborland-pascal",
           "Try to emulate Borland Pascal, version 7.0"),
  GPC_OPT (1, "-fdelphi",
           "Try to emulate Borland Pascal, version 7.0, with some Delphi extensions"),
  GPC_OPT (1, "-fpascal-sc",
           "Be strict about the implemented Pascal-SC extensions"),
  GPC_OPT (1, "-fgnu-pascal",
           "Undo the effect of a previous `--foo-pascal', `--delphi' or `--pascal-sc' switch"),
  GPC_OPT (1, "-fdebug-tree",
           "(For GPC developers.) Show the internal representation of a given tree node (name or address)"),
  GPC_OPT (1, "-fdebug-gpi",
           "(For GPC developers.) Show what is written to and read from GPI files (huge output!)"),
  GPC_OPT (1, "-fdebug-automake",
           "(For GPC developers.) Give additional information about the actions of automake"),
  GPC_OPT (1, "-fdebug-source",
           "Output the source while it is processed"),
  GPC_OPT (1, "-fno-debug-info",
           "Inhibit `-g' options (temporary work-around, this option may disappear in the future)"),
  GPC_OPT (0, "-fprogress-messages",
           "Output source file names and line numbers while compiling"),
  GPC_OPT (0, "-fprogress-bar",
           "Output number of processed lines while compiling"),
  GPC_OPT (0, "-fautolink",
           "Automatically link object files provided by units/modules or `{$L ...}' (default)"),
  GPC_OPT (0, "-fno-autolink",
           "Do not automatically link object files provided by units/modules/`{$L ...}'"),
  GPC_OPT (0, "-fautomake",
           "Automatically compile changed units/modules/`{$L ...}' files and link the object files provided"),
  GPC_OPT (0, "-fno-automake",
           "Same as `--no-autolink'"),
  GPC_OPT (0, "-fautobuild",
           "Automatically compile all units/modules/`{$L ...}' files and link the object files provided"),
  GPC_OPT (0, "-fno-autobuild",
           "Same as `--no-autolink'"),
  GPC_OPT (0, "-famtmpfile",
           "(Internal switch used for AutoMake)"),
  GPC_OPT (1, "-fextended-syntax",
           "Enable certain `dangerous' features such as ignoring function results, pointer arithmetic or using `CString's as strings (same as `{$X+}')"),
  GPC_OPT (1, "-fno-extended-syntax",
           "Disable the dangerous features enabled by `--extended-syntax' (default; same as `{$X-}')"),
  GPC_OPT (1, "-fsigned-char",
           "Let `Char' be a signed type"),
  GPC_OPT (1, "-fno-signed-char",
           "Let `Char' be an unsigned type"),
  GPC_OPT (1, "-funsigned-char",
           "Let `Char' be an unsigned type"),
  GPC_OPT (1, "-fno-unsigned-char",
           "Let `Char' be a signed type"),
  GPC_OPT (1, "-fshort-circuit",
           "Guarantee short-circuit Boolean evaluation (default; same as `{$B-}')"),
  GPC_OPT (1, "-fno-short-circuit",
           "Do not guarantee short-circuit Boolean evaluation (same as `{$B+}')"),
  GPC_OPT (1, "-fmixed-comments",
           "Allow comments like `{ ... *)' as required in ISO Pascal (default in ISO 7185/10206 Pascal mode)"),
  GPC_OPT (1, "-fno-mixed-comments",
           "Ignore `{' and `}' within `(* ... *)' comments and vice versa (default)"),
  GPC_OPT (1, "-fnested-comments",
           "Allow nested comments like `{ { } }' and `(* (* *) *)'"),
  GPC_OPT (1, "-fno-nested-comments",
           "Do not allow nested comments (default)"),
  GPC_OPT (1, "-fdelphi-comments",
           "Allow Delphi style `//' comments (default)"),
  GPC_OPT (1, "-fno-delphi-comments",
           "Do not allow Delphi style `//' comments"),
  GPC_OPT (1, "-fmacros",
           "Expand macros (default)"),
  GPC_OPT (1, "-fno-macros",
           "Do not expand macros (default with `--borland-pascal' or `--delphi')"),
  GPC_OPT (1, "-fignore-function-results",
           "Do not complain when a function is called like a procedure"),
  GPC_OPT (1, "-fno-ignore-function-results",
           "Complain when a function is called like a procedure (default)"),
  GPC_OPT (1, "-fborland-char-constants",
           "Allow for Borland-style character constants like `#27' or `^L' (default)"),
  GPC_OPT (1, "-fno-borland-char-constants",
           "Reject Borland-style character constants like `#27' or `^L' (default in ISO 7185/10206 Pascal mode)"),
  GPC_OPT (1, "-ftruncate-strings",
           "Truncate strings being assigned to other strings of too short capacity."),
  GPC_OPT (1, "-fno-truncate-strings",
           "Treat string assignments to other strings of too short capacity as errors."),
  GPC_OPT (1, "-fexact-compare-strings",
           "Do not blank-pad strings for comparisons"),
  GPC_OPT (1, "-fno-exact-compare-strings",
           "Blank-pad strings for comparisons"),
  GPC_OPT (1, "-fdouble-quoted-strings",
           "Allow strings enclosed in \"\"."),
  GPC_OPT (1, "-fno-double-quoted-strings",
           "Do not allow strings enclosed in \"\"."),
  GPC_OPT (1, "-fio-checking",
           "Do automatic run-time checks after I/O operations (same as `{$I+}')"),
  GPC_OPT (1, "-fno-io-checking",
           "Do not check I/O operations automatically (same as `{$I-}')"),
  GPC_OPT (1, "-fread-base-specifier",
           "In read statements, allow non-decimal input with `n#' (default)"),
  GPC_OPT (1, "-fno-read-base-specifier",
           "In read statements, do not allow non-decimal input with `n#' (default in ISO-7185 Pascal)"),
  GPC_OPT (1, "-fread-hex",
           "In read statements, allow hexadecimal input with `$' (default)"),
  GPC_OPT (1, "-fno-read-hex",
           "In read statements, do not allow hexadecimal input with `$' (default in ISO-7185 Pascal)"),
  GPC_OPT (1, "-fread-white-space",
           "In read statements, require whitespace after numbers"),
  GPC_OPT (1, "-fno-read-white-space",
           "In read statements, do not require whitespace after numbers (default)"),
  GPC_OPT (1, "-fwrite-clip-strings",
           "In write statements, truncate strings exceeding their field width (`Write (SomeLongString : 3)')"),
  GPC_OPT (1, "-fno-write-clip-strings",
           "Do not truncate strings exceeding their field width"),
  GPC_OPT (1, "-fwrite-real-blank",
           "Output a blank in front of positive reals in exponential form (default)"),
  GPC_OPT (1, "-fno-write-real-blank",
           "Do not output a blank in front of positive reals in exponential form"),
  GPC_OPT (1, "-fwrite-capital-exponent",
           "Write real exponents with a capital `E'"),
  GPC_OPT (1, "-fno-write-capital-exponent",
           "Write real exponents with a lowercase `e'"),
  GPC_OPT (1, "-ftransparent-file-names",
           "Derive external file names from variable names"),
  GPC_OPT (1, "-fno-transparent-file-names",
           "Do not derive external file names from variable names (default)"),
  GPC_OPT (1, "-ffield-widths",
           "Comma-separated list of default field widths for Integer, Real, Boolean, LongInt, LongReal"),
  GPC_OPT (1, "-fno-field-widths",
           "Reset the default field widths"),
  GPC_OPT (1, "-fpedantic",
           "Reject everything not allowed in some dialect, e.g. redefinition of its keywords"),
  GPC_OPT (1, "-fno-pedantic",
           "Don't give pedantic warnings"),
  GPC_OPT (1, "-fstack-checking",
           "Enable stack checking (same as `{$S+}')"),
  GPC_OPT (1, "-fno-stack-checking",
           "Disable stack checking (same as `{$S-}')"),
  GPC_OPT (1, "-ftyped-address",
           "Make the result of the address operator typed (same as `{$T+}', default)"),
  GPC_OPT (1, "-fno-typed-address",
           "Make the result of the address operator an untyped pointer (same as `{$T-}')"),
  GPC_OPT (1, "-fsetlimit",
           "Define the range for `set of Integer' etc."),
  GPC_OPT (1, "-fgpc-main",
           "External name for the program's entry point (default: `main')"),
  GPC_OPT (0, "-finterface-only",
           "Compile only the interface part of a unit/module and exit"),
  GPC_OPT (0, "-fimplementation-only",
           "Do not produce a GPI file; only compile the implementation part"),
  GPC_OPT (1, "-fexecutable-file-name",
           "Name for the output file, if specified; otherwise derive from main source file name"),
  GPC_OPT (0, "-funit-path",
           "Directories where to look for unit/module sources"),
  GPC_OPT (0, "-fno-unit-path",
           "Forget about directories where to look for unit/module sources"),
  GPC_OPT (0, "-fobject-path",
           "Directories where to look for additional object (and source) files"),
  GPC_OPT (0, "-fno-object-path",
           "Forget about directories where to look for additional object (and source) files"),
  GPC_OPT (0, "-fexecutable-path",
           "Path where to create the executable file"),
  GPC_OPT (0, "-fno-executable-path",
           "Create the executable file in the directory where the main source is (default)"),
  GPC_OPT (0, "-funit-destination-path",
           "Path where to create object and GPI files of Pascal units"),
  GPC_OPT (0, "-fno-unit-destination-path",
           "Create object and GPI files of Pascal units in the current directory (default)"),
  GPC_OPT (0, "-fobject-destination-path",
           "Path where to create additional object files (e.g. of C files, not Pascal units)"),
  GPC_OPT (0, "-fno-object-destination-path",
           "Create additional object files (e.g. of C files, not Pascal units) in the current directory (default)"),
  GPC_OPT (0, "-fno-default-paths",
           "Do not add a default path to the unit and object path"),
  GPC_OPT (0, "-fgpi-destination-path",
           "(Internal switch used for AutoMake)"),
  GPC_OPT (0, "-fuses",
           "Add an implicit `uses' clause"),
  GPC_OPT (1, "-finit-modules",
           "Initialize the named modules in addition to those imported regularly; kind of a kludge"),
  GPC_OPT (0, "-fcidefine", /* handled specially by the preprocessor when in the source */
           "Define a case-insensitive macro"),
  GPC_OPT (0, "-fcsdefine", /* handled specially by the preprocessor when in the source */
           "Define a case-sensitive macro"),
  GPC_OPT (0, "-fbig-endian",
           "Tell GPC that the system is big-endian (for those targets where it can very)"),
  GPC_OPT (0, "-flittle-endian",
           "Tell GPC that the system is little-endian (for those targets where it can very)"),
  GPC_OPT (0, "-fprint-needed-options",
           "Print the needed options"),
  GPC_OPT (1, "-Wwarnings",
           "Enable warnings (same as `{$W+}')"),
  GPC_OPT (1, "-Wno-warnings",
           "Disable warnings (same as `{$W-}')"),
  GPC_OPT (1, "-Wfield-name-problem",
           "Warn about ignored field names in initializers (default)"),
  GPC_OPT (1, "-Wno-field-name-problem",
           "Do not warn about ignored field names in initializers"),
  GPC_OPT (1, "-Wobject-directives",
           "Warn about unimplemented `private', `protected' and `public' directives (default)"),
  GPC_OPT (1, "-Wno-object-directives",
           "Do not warn about unimplemented `private', `protected' and `public' directives"),
  GPC_OPT (1, "-Wimplicit-abstract",
           "Warn if an object type not declared `abstract' contains an abstract method (default)"),
  GPC_OPT (1, "-Wno-implicit-abstract",
           "Do not warn if an object type not `declared' abstract contains an abstract method"),
  GPC_OPT (1, "-Winherited-abstract",
           "Warn if an abstract object type inherits from a non-abstract one (default)"),
  GPC_OPT (1, "-Wno-inherited-abstract",
           "Do not warn warn if an abstract object type inherits from a non-abstract one"),
  GPC_OPT (1, "-Wtyped-const",
           "Warn about misuse of typed constants as initialized variables (default)"),
  GPC_OPT (1, "-Wno-typed-const",
           "Do not warn about misuse of typed constants as initialized variables"),
  GPC_OPT (1, "-Wnear-far",
           "Warn about use of useless `near' or `far' directives (default)"),
  GPC_OPT (1, "-Wno-near-far",
           "Do not warn about use of useless `near' or `far' directives"),
  GPC_OPT (1, "-Wunderscore",
           "Warn about double/leading/trailing underscores in identifiers"),
  GPC_OPT (1, "-Wno-underscore",
           "Do not warn about double/leading/trailing underscores in identifiers"),
  GPC_OPT (1, "-Wmixed-comments",
           "Warn about mixed comments like `{ ... *)'"),
  GPC_OPT (1, "-Wno-mixed-comments",
           "Do not warn about mixed comments"),
  GPC_OPT (1, "-Wnested-comments",
           "Warn about nested comments like `{ { } }'"),
  GPC_OPT (1, "-Wno-nested-comments",
           "Do not warn about nested comments"),
  GPC_OPT (1, "-Wsemicolon",
           "Warn about a semicolon after @samp{then}, @samp{else} or @samp{do} (default)"),
  GPC_OPT (1, "-Wno-semicolon",
           "Do not warn about a semicolon after @samp{then}, @samp{else} or @samp{do}"),
