/* GNU C varargs support for the S/390. */

#ifndef __GNUC_VA_LIST
#define __GNUC_VA_LIST

typedef struct __va_list_tag {
  long __gpr;                   /* index into the array of 5 GPRs stored in the
                                   register save area __gpr=0 corresponds to r2,
                                   __gpr=1 to r3, etc. */
  long __fpr;                   /* index into the array of 2 FPRs stored in the
                                   register save area __fpr=0 corresponds to f0,
                                   __fpr=1 to f2, etc. */
  char *__incoming_args_area;   /* location on stack that holds the next
                                   overflow argument */
  char *__reg_save_area;        /* where r2:r6 and f0 and f2,
                                   if saved are stored */
} __gnuc_va_list[1],*__gnuc_va_listp;
#endif

/* If this is for internal libc use, don't define anything but
   __gnuc_va_list.  */
#if defined (_STDARG_H) || defined (_VARARGS_H)

/* Register save area located in the 96 byte of the
 * Stack given to the called function
 */

#ifndef __VA_S390_H__
#define __VA_S390_H__
typedef struct {
  long   __backchain;
  long   __spare;
  long   __gp_save[14];                /* save area for GP registers       */
  long long __fp_save[4];              /* save area for FP registers       */
} __va_regsave_t;

/* Macros to access the register save area */
/* We cast to void * and then to TYPE * because this avoids
   a warning about increasing the alignment requirement.  */

#define __VA_FP_REGSAVE(AP,TYPE)                                       \
  ((TYPE *) (void *) (&(((__va_regsave_t *)                             \
                         (AP)->__reg_save_area)->__fp_save[(AP)->__fpr])))

#define __VA_GP_REGSAVE(AP,TYPE)                                        \
  ((TYPE *) (void *) (&(((__va_regsave_t *)                             \
                         (AP)->__reg_save_area)->__gp_save[(AP)->__gpr])))
#define __va_overflow(AP) (AP)->__incoming_args_area


#define __va_start_common(AP, LASTARG)                                  \
__extension__ ({                                                        \
   *(AP) = *(__gnuc_va_listp) __builtin_saveregs ();                     \
   (void)0;                                                             \
   })

#ifdef _STDARG_H                       /* stdarg.h support                 */

/* Calling __builtin_next_arg gives the proper error message if LASTARG is
   not indeed the last argument.  */
#define va_start(AP,LASTARG) \
  (__builtin_next_arg(LASTARG),__va_start_common (AP, LASTARG))


#else                                  /* varargs.h support                */

#define va_alist  __builtin_va_alist
#define va_dcl    int __builtin_va_alist;...
#define va_start(AP) __va_start_common (AP,va_alist) 

#endif                                 /* _STDARG_H                        */

#define __va_fptype_p(TYPE) \
  ((__builtin_classify_type(*(TYPE *)0) == 8))

#define __va_float_p(TYPE) \
  ((__builtin_classify_type(*(TYPE *)0) == 8) && (sizeof(TYPE) == 4))

#define __va_double_p(TYPE) \
  ((__builtin_classify_type(*(TYPE *)0) == 8) && (sizeof(TYPE) == 8))

#ifndef __s390x__
#define __va_longlong_p(TYPE) 				\
   (((__builtin_classify_type(*(TYPE *)0) == 1) ||	\
     (__builtin_classify_type(*(TYPE *)0) >= 12)) &&   	\
     (sizeof(TYPE) == 8))
#else
#define __va_longlong_p(TYPE) 0
#endif

#define __va_aggregate_p(TYPE) 				\
 ((__builtin_classify_type(*(TYPE *)0) >= 12) && 	\
  (sizeof(TYPE) != 1) && 				\
  (sizeof(TYPE) != 2) && 				\
  (sizeof(TYPE) != 4) && 				\
  (sizeof(TYPE) != 8))  

#define __va_size(TYPE)         ((sizeof(TYPE) + sizeof (long) - 1) / sizeof (long))

#ifndef __s390x__
#define __fp_num 2
#define __va_add_ptr(TYPE)                                      \
       ((sizeof(TYPE) == 2) ? 1 : (sizeof(TYPE) == 1) ? 3 :0);
#else
#define __fp_num 4
#define __va_add_ptr(TYPE)                                      \
       ((sizeof(TYPE) == 4) ? 1 : (sizeof(TYPE) == 2) ? 3 :     \
        (sizeof(TYPE) == 1) ? 7 : 0)
#endif


#define va_arg(AP,TYPE)                                                 \
__extension__ (*({                                                      \
  register TYPE *__ptr;                                                 \
                                                                        \
  if (__va_float_p (TYPE) && (AP)->__fpr < __fp_num)                    \
    {                                                                   \
      __ptr = __VA_FP_REGSAVE (AP, TYPE);                               \
      (AP)->__fpr++;                                                    \
    }                                                                   \
  else if (__va_double_p (TYPE) && (AP)->__fpr < __fp_num)              \
    {                                                                   \
      __ptr = __VA_FP_REGSAVE (AP, TYPE);                               \
      (AP)->__fpr++;                                                    \
    }                                                                   \
  else if (__va_longlong_p (TYPE) )                                     \
    {                                                                   \
      if ((AP)->__gpr < 4)                                              \
        {                                                               \
          __ptr = __VA_GP_REGSAVE (AP, TYPE);                           \
          (AP)->__gpr++;                                                \
          (AP)->__gpr++;                                                \
        }                                                               \
      else                                                              \
        {                                                               \
          __ptr = (TYPE *) (void *) (__va_overflow(AP));                \
          __va_overflow(AP) += __va_size (TYPE) * sizeof (long);        \
          (AP)->__gpr++;                                                \
        }                                                               \
    }                                                                   \
  /* Aggregates passed by reference.  */	                        \
  else if (__va_aggregate_p (TYPE))                         		\
    {									\
      if ((AP)->__gpr < 5)						\
	{								\
          __ptr = *__VA_GP_REGSAVE (AP, TYPE*);                         \
           (AP)->__gpr++;                                               \
	}								\
      else								\
	{								\
	  TYPE **__pptr = (TYPE **) (__va_overflow (AP));		\
	  __ptr = * __pptr;						\
	  __va_overflow (AP) = (char *) (__pptr + 1);			\
	}								\
    }									\
                                                                        \
  else if (((AP)->__gpr < 5) && !(__va_fptype_p(TYPE)))                 \
    {                                                                   \
       __ptr = __VA_GP_REGSAVE (AP, TYPE );                             \
       __ptr += __va_add_ptr(TYPE);                                     \
      (AP)->__gpr++;                                                    \
    }                                                                   \
  else                                                                  \
    {                                                                   \
      __ptr = (TYPE *) (void *) (__va_overflow(AP));                    \
      __ptr += __va_add_ptr(TYPE);                                      \
      __va_overflow(AP) += __va_size (TYPE) * sizeof (long);            \
    }                                                                   \
                                                                        \
  __ptr;                                                                \
}))

#define va_end(AP)      ((void)0)

/* Copy __gnuc_va_list into another variable of this type.  */
#define __va_copy(dest, src) *(dest) = *(src)

#endif /* __VA_S390_H__ */
#endif /* defined (_STDARG_H) || defined (_VARARGS_H) */







