#ifndef _S390_295_H
#define _S390_295_H

#define __V2_95__

#include "s390/linux.h"

#undef CC1_SPEC
#define CC1_SPEC "-fno-caller-saves"
#define CC1PLUS_SPEC "-fno-caller-saves"

#undef REGISTER_MOVE_COST
/* On s390, copy between fprs and gprs is expensive.  */

#define REGISTER_MOVE_COST(CLASS1, CLASS2)                        \
  (((CLASS1 != CLASS2) &&                                               \
   (CLASS1 == FP_REGS || CLASS2 == FP_REGS)) ? 10 : 1)


/* Generate necessary RTL for __builtin_saveregs().
   ARGLIST is the argument list; see expr.c.  */


extern struct rtx_def *s390_builtin_saveregs ();
#define EXPAND_BUILTIN_SAVEREGS(ARGLIST) s390_builtin_saveregs (ARGLIST)

#define INSN_ADDRESSES(ID) insn_addresses[ID]
#define INSN_ADDRESSES_NEW(ID,I) ID 
#define va_list_type_node ptr_type_node
#define get_varargs_alias_set() NULL

/* Use SELECT_SECTION from gcc 3.0 to fix readonly bug */

#undef SELECT_SECTION
#define SELECT_SECTION(DECL, RELOC)				\
{								\
  if (TREE_CODE (DECL) == STRING_CST)				\
    {								\
      if (! flag_writable_strings)				\
	const_section ();					\
      else							\
	data_section ();					\
    }								\
  else if (TREE_CODE (DECL) == VAR_DECL)			\
    {								\
      if ((flag_pic && RELOC)					\
	  || !TREE_READONLY (DECL) || TREE_SIDE_EFFECTS (DECL)	\
	  || !DECL_INITIAL (DECL)				\
	  || (DECL_INITIAL (DECL) != error_mark_node		\
	      && !TREE_CONSTANT (DECL_INITIAL (DECL))))		\
	data_section ();					\
      else							\
	const_section ();					\
    }								\
  else if (TREE_CODE (DECL) == CONSTRUCTOR)			\
    {								\
      if ((flag_pic && RELOC)					\
	  || !TREE_READONLY (DECL) || TREE_SIDE_EFFECTS (DECL)	\
	  || ! TREE_CONSTANT (DECL))				\
	data_section ();					\
      else							\
	const_section ();					\
    }								\
  else								\
    const_section ();						\
}

#endif
