This is ../../gcc-3.4.3/gcc/p/doc/info/gpc.info, produced by makeinfo
version 4.7 from gpc.texi.

INFO-DIR-SECTION GNU programming tools
START-INFO-DIR-ENTRY
* GPC: (gpc).                   The GNU Pascal Compiler.
END-INFO-DIR-ENTRY
INFO-DIR-SECTION Individual utilities
START-INFO-DIR-ENTRY
* GPC: (gpc)Invoking GPC.       The GNU Pascal Compiler.
END-INFO-DIR-ENTRY

   This file documents the GNU Pascal Compiler.

   Permission is granted to make and distribute verbatim copies of this
manual provided the copyright notice and this permission notice are
preserved on all copies.

   Copyright (C) 1988-2005 Free Software Foundation, Inc.

   Permission is granted to copy and distribute modified versions of
this manual under the conditions for verbatim copying, provided also
that the sections entitled "GNU General Public License", "The GNU
Project", "The GNU Manifesto" and "Funding for free Software" are
included exactly as in the original, and provided that the entire
resulting derived work is distributed under the terms of a permission
notice identical to this one.

   Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that the sections entitled "GNU General Public
License", "The GNU Project", "The GNU Manifesto" and "Funding for Free
Software" and this permission notice, may be included in translations
approved by the Free Software Foundation instead of in the original
English.


File: gpc.info,  Node: WinDos,  Prev: Turbo3,  Up: GPC Units

6.15.21 BP compatibility: WinDos
--------------------------------

The following listing contains the interface of the WinDos unit.

   This is a portable implementation of most routines from BP's
`WinDos' unit. A few routines that are Dos - or even IA32 real mode -
specific, are only available if `__BP_UNPORTABLE_ROUTINES__' is defined,
*Note BP Incompatibilities::.

   The same functionality and much more is available in the Run Time
System, *Note Run Time System::. The RTS routines usually have
different names and/or easier and less limiting interfaces (e.g.
`ReadDir' etc. vs. `FindFirst' etc.), and are often more efficient.

   Therefore, using this unit is not recommended in newly written
programs.

     { Mostly BP compatible portable WinDos unit

       This unit supports most, but not all, of the routines and
       declarations of BP's WinDos unit.

       Notes:

       - The procedures GetIntVec and SetIntVec are not supported since
         they make only sense for Dos real-mode programs (and GPC
         compiled programs do not run in real-mode, even on IA32 under
         Dos). The procedures Intr and MsDos are only supported under
         DJGPP if `__BP_UNPORTABLE_ROUTINES__' is defined (with the
         `-D__BP_UNPORTABLE_ROUTINES__' option). A few other routines are
         also only supported with this define, but on all platforms (but
         they are crude hacks, that's why they are not supported without
         this define).

       - The internal structure of file variables (TFileRec and TTextRec)
         is different in GPC. However, as far as TFDDs are concerned,
         there are other ways to achieve the same in GPC, see the GPC
         unit.

       Copyright (C) 1998-2005 Free Software Foundation, Inc.

       Author: Frank Heckenbach <frank@pascal.gnu.de>

       This file is part of GNU Pascal.

       GNU Pascal is free software; you can redistribute it and/or modify
       it under the terms of the GNU General Public License as published
       by the Free Software Foundation; either version 2, or (at your
       option) any later version.

       GNU Pascal is distributed in the hope that it will be useful, but
       WITHOUT ANY WARRANTY; without even the implied warranty of
       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
       General Public License for more details.

       You should have received a copy of the GNU General Public License
       along with GNU Pascal; see the file COPYING. If not, write to the
       Free Software Foundation, 59 Temple Place - Suite 330, Boston, MA
       02111-1307, USA.

       As a special exception, if you link this file with files compiled
       with a GNU compiler to produce an executable, this does not cause
       the resulting executable to be covered by the GNU General Public
       License. This exception does not however invalidate any other
       reasons why the executable file might be covered by the GNU
       General Public License. }

     {$gnu-pascal,I-,maximum-field-alignment 0}
     {$if __GPC_RELEASE__ < 20030412}
     {$error This unit requires GPC release 20030412 or newer.}
     {$endif}

     module WinDos;

     export WinDos = all (FCarry, FParity, FAuxiliary, FZero, FSign,
       FOverflow,
                          DosError, GetDate, GetTime, GetCBreak,
       SetCBreak,
                          GetVerify, SetVerify, DiskFree, DiskSize,
                          GetFAttr, SetFAttr, GetFTime, SetFTime,
                          UnpackTime, PackTime,
                          {$ifdef __BP_UNPORTABLE_ROUTINES__}
                          {$ifdef __GO32__}
                          Intr, MsDos,
                          {$endif}
                          DosVersion, SetDate, SetTime,
                          {$endif}
                          CStringGetEnv => GetEnvVar);

     import GPC (MaxLongInt => GPC_Orig_MaxLongInt);
            System;
            Dos (FindFirst => Dos_FindFirst,
                 FindNext  => Dos_FindNext,
                 FindClose => Dos_FindClose);

     const
       { File attribute constants }
       faReadOnly  = ReadOnly;
       faHidden    = Hidden;    { set for dot files except `.' and `..' }
       faSysFile   = SysFile;   { not supported }
       faVolumeID  = VolumeID;  { not supported }
       faDirectory = Directory;
       faArchive   = Archive;   { means: not executable }
       faAnyFile   = AnyFile;

       { Maximum file name component string lengths }
       fsPathName  = 79;
       fsDirectory = 67;
       fsFileName  = 8;
       fsExtension = 4;

       { FileSplit return flags }
       fcExtension = 1;
       fcFileName  = 2;
       fcDirectory = 4;
       fcWildcards = 8;

     type
       PTextBuf = ^TTextBuf;
       TTextBuf = TextBuf;

       { Search record used by FindFirst and FindNext }
       TSearchRec = record
         Fill: SearchRecFill;
         Attr: Byte8;
         Time, Size: LongInt;
         Name: {$ifdef __BP_TYPE_SIZES__}
               packed array [0 .. 12] of Char
               {$else}
               TStringBuf
               {$endif};
         Reserved: SearchRec
       end;

       { Date and time record used by PackTime and UnpackTime }
       TDateTime = DateTime;

       { 8086 CPU registers -- only used by the unportable Dos routines }
       TRegisters = Registers;

     { FindFirst and FindNext are quite inefficient since they emulate
       all the brain-dead Dos stuff. If at all possible, the standard
       routines OpenDir, ReadDir and CloseDir (in the GPC unit) should be
       used instead. }
     procedure FindFirst (Path: PChar; Attr: Word; var SR: TSearchRec);
     procedure FindNext  (var SR: TSearchRec);
     procedure FindClose (var SR: TSearchRec);
     function  FileSearch (Dest, FileName, List: PChar): PChar;
     function  FileExpand (Dest, FileName: PChar): PChar;
     function  FileSplit (Path, Dir, BaseName, Ext: PChar) = Res: Word;
     function  GetCurDir (Dir: PChar; Drive: Byte): PChar;
     procedure SetCurDir (Dir: PChar);
     procedure CreateDir (Dir: PChar);
     procedure RemoveDir (Dir: PChar);
     function  GetArgCount: Integer;
     function  GetArgStr (Dest: PChar; ArgIndex: Integer; MaxLen: Word):
       PChar;


File: gpc.info,  Node: Borland Pascal,  Next: Reference,  Prev: Programming,  Up: Top

7 A QuickStart Guide from Borland Pascal to GNU Pascal.
*******************************************************

This chapter is intended to be a QuickStart guide for programmers who
are familiar with Borland Pascal.

   Throughout the manual, we talk of "Borland Pascal" or "BP" for
short, to refer to Borland Pascal version 7 for Dos protected mode.
Other versions of Borland Pascal and Turbo Pascall don't differ too
much, but this one was the very last Dos version Borland has published,
so in most if not all cases, you can safely substitute the version
you're familiar with.

   "Borland Pascal" and "Turbo Pascal" are registered trademarks of
Borland Inc.

* Menu:

* BP Compatibility::
* BP Incompatibilities::
* IDE versus command line::
* Comments::
* BP Compatible Compiler Directives::
* Units; GPI files and Automake::
* Optimization::
* Debugging::
* Objects::
* Strings in BP and GPC::
* Typed Constants::
* Bit; Byte and Memory Manipulation::
* User-defined Operators in GPC::
* Data Types in BP and GPC::
* BP Procedural Types::
* Files::
* Built-in Constants::
* Built-in Operators in BP and GPC::
* Built-in Procedures and Functions::
* Special Parameters::
* Miscellaneous::
* BP and Extended Pascal::
* Portability hints::


File: gpc.info,  Node: BP Compatibility,  Next: BP Incompatibilities,  Up: Borland Pascal

7.1 BP Compatibility
====================

GNU Pascal (GPC) is compatible to version 7 of Borland Pascal (BP) to a
large extent and comes with portable replacements of the BP standard
units.

   However, BP is a 16-bit compiler while GPC is a 32/64-bit compiler,
so the size of the `Integer' type, for instance, is 16 bits in BP, but
at least 32 bits in GPC. If a BP program has been designed with
portability in mind from the ground up, it may work with GPC without
any change. Programs which rely on byte order, on the internals or
sizes of data types or which use unportable things like interrupts and
assembler code, will need to be changed. The following section lists
the possible problems with solutions.

   The GPC Run Time System (RTS) is fairly complete, and you can use
all libraries written for GNU C from GNU Pascal, so there is much less
need to use unportable constructs than there was in BP. (For example,
BP's Turbo Vision library uses assembler to call a local procedure
through a pointer. With GPC you can do this in Pascal just as with
global procedures.) Please do not throw away the advantage of full
portability by sticking to those workarounds.

   We have successfully ported real-world projects (with several 10000s
of lines) from BP to GPC, so this is possible for you, too.


File: gpc.info,  Node: BP Incompatibilities,  Next: IDE versus command line,  Prev: BP Compatibility,  Up: Borland Pascal

7.2 BP Incompatibilities
========================

This sections lists the remaining incompatibilities of GPC to BP, and
the problems you might encounter when porting BP programs from 16-bit
Dos to other platforms, and gives solutions for them.

   By "incompatibilites" we mean problems that can arise when trying to
compile a valid BP program with GPC. Of course, there are many features
in GPC that BP doesn't know, but we call them extensions unless they
can break valid BP programs, so they are not mentioned here. The
subsequent sections of the `Borland Pascal' chapter mention a number of
useful extensions that you might want to know about but which will not
break your BP code.

* Menu:

* String type::
* Qualified identifiers::
* Assembler::
* Move; FillChar::
* Real type::
* Graph unit::
* OOP units::
* Keep; GetIntVec; SetIntVec::
* TFDDs::
* Mem; Port; Ptr; Seg; Ofs; PrefixSeg; etc.::
* Endianness assumptions::

   Some of the differences can be "overcome" by command-line switches.
As a summary:

     --borland-pascal -w --uses=System -D__BP_TYPE_SIZES__ --pack-struct
     -D__BP_RANDOM__ -D__BP_UNPORTABLE_ROUTINES__ -D__BP_PARAMSTR_0__

   But please read the following notes, and don't use these switches
indiscriminately when not necessary. There are reasons why they are not
GPC's defaults.

* Menu:

* - -borland-pascal - disable GPC extensions::
* -w - disable all warnings::
* - -uses=System - Swap; HeapError; etc.::
* -D__BP_TYPE_SIZES__ - small integer types etc.::
* - -pack-struct - disable structure alignment::
* -D__BP_RANDOM__ - BP compatible pseudo random number generator::
* -D__BP_UNPORTABLE_ROUTINES__ - Intr; DosVersion; etc.::
* -D__BP_PARAMSTR_0__ - BP compatible ParamStr (0) behaviour::


File: gpc.info,  Node: String type,  Next: Qualified identifiers,  Up: BP Incompatibilities

7.2.1 String type
-----------------

GPC's internal string format (Extended Pascal string schema) is
different from BP's. BP compatible "short strings" will be implemented
in GPC soon, but in the meantime, you'll have to live with the
difference. In general, GPC's format has many advantages (no length
limit of 255 characters, constant and reference parameters always know
about their capacity, etc.), but you will see differences if you:

   - declare a variable as `String' without a capacity. However, GPC
     will assume 255 then (like BP) and only warn about it (and not even
     this when using `--borland-pascal', see below), so that's not a
     real problem. The "clean" way, however, is to declare `String
     [255]' when you mean so (but perhaps you'll prefer `String
     (2000)'? :-).

   - access "character 0" which happens to hold the length in BP. This
     does not work with string schemata. Use `Length' to get the
     length, and `SetLength' to modify it.

   - try to `FillChar' a string, e.g.  `FillChar (StringVar, 256, 0);',
     which would overwrite the `Capacity' field. Using `FillChar
     (StringVar[1], ...);' is alright since it accesses the characters
     of the string, not the `Capacity' and `Length' fields. If you want
     to set the length to zero, use `SetLength' (see above) or simply
     assign an empty string (`StringVar := '''). This is more efficient
     than clearing all the characters, anyway, and has the same effect
     for all normal purposes.

   - try to read or write strings from/to _binary_ files (`Text' files
     are no problem). You will have to rewrite the code. If you also
     want to get rid of the 255 character limit and handle endianness
     issues (see below) in one go, you can use the
     `ReadStringLittleEndian' etc. routines (*note Run Time System::),
     but if you need BP compatible strings (i.e., with a one-byte
     length field) in data files, you cannot use them (but you can
     easily modify them for this purpose).


File: gpc.info,  Node: Qualified identifiers,  Next: Assembler,  Prev: String type,  Up: BP Incompatibilities

7.2.2 Qualified identifiers
---------------------------

GPC supports "qualified identifiers", liek BP does. (In addition, it
also supports Extended Pascal style qualified identifiers which behave
a little differently for units and modules imported with `import'
rather than `uses'.)


File: gpc.info,  Node: Assembler,  Next: Move; FillChar,  Prev: Qualified identifiers,  Up: BP Incompatibilities

7.2.3 Assembler
---------------

GPC's inline assembler is not compatible to BP's. It uses "AT&T
syntax", supports a large variety of processors and works together with
GPC's optimizer. So, either convert your inline assembly to AT&T
syntax, or (usually better) to Pascal, or put it into an external file
which you can assemble with your favourite (32 bit) assembler. A
tutorial for using the GPC inline assembler is available at
`http://www.gnu-pascal.de/contrib/misc/gpcasm.zip'

   Since many things you usually do with assembler in BP are provided
by GPC's Run Time System (RTS), you will not need the inline assembler
as often as in BP. (See *Note Portability hints::.)

   The same applies to BP's `inline' directive for hand-written machine
code. GPC's `inline' directive works for Pascal routines (*note
Miscellaneous::), so you'll have to convert any hand-written machine
code to Pascal (and thereby make it more readable, portable and easier
to maintain while still getting the performance of inline code).


File: gpc.info,  Node: Move; FillChar,  Next: Real type,  Prev: Assembler,  Up: BP Incompatibilities

7.2.4 Move; FillChar
--------------------

GPC supports `Move' and `FillChar', and they're fully BP compatible.
However, some data structures have different internal formats which may
become relevant when using these procedures. E.g., using `Move' on file
variables does not work in GPC (there are reasons why assigning file
variables with `:=' is not allowed in Pascal, and circumventing this
restriction with `Move' is not a good idea). For other examples, see
*Note String type::, *Note Real type::, and *Note Endianness
assumptions::.


File: gpc.info,  Node: Real type,  Next: Graph unit,  Prev: Move; FillChar,  Up: BP Incompatibilities

7.2.5 Real type
---------------

GPC does not support BP's 6-byte `Real' type. It supports `Single',
`Double' and `Extended' which, at least on the IA32 and some other
processors, are compatible to BP.

   For BP's 6-byte `Real' type, GPC's `System' unit provides an
emulation, called `BPReal', as well as conversion routines to GPC's
`Real' type (which is the same as `Double'), called `RealToBPReal' and
`BPRealToReal'. You'll probably only need them when reading or writing
binary files containing values of the BP 6-byte real type. There are no
operators (e.g., `+') available for `BPReal', but since GPC supports
operator overloading, you could define them yourself (e.g., convert to
`Real', do the operation, and convert back). Needless to say that this
is very inefficient and should not be done for any serious
computations. Better convert your data after reading them from the file
and before writing them back, or simply convert your data files once
(the other types are more efficient even with BP on any non-prehistoric
processor, anyway).


File: gpc.info,  Node: Graph unit,  Next: OOP units,  Prev: Real type,  Up: BP Incompatibilities

7.2.6 Graph unit
----------------

A mostly BP compatible `Graph' unit exists as part of the `GRX'
package. It is known to work under DJGPP, Cygwin, mingw, Linux/IA32
with svgalib, and should work under any Unix system with X11 (tested
under Linux, Solaris, AIX, etc.).

   There is a small difference in the color numbering, but it should be
easy to work-around: You can't assume, e.g., that color 1 is always
blue, and 2 is green, etc. On a system with 15 or more bits of color
depth (i.e., 32768 or more colors, which most PCs today have), they
will all be very dark shades of blue. This is not really a bug, but
simply a property of modern high-color modes (whereas BP's `Graph' unit
was only designed for 16 and 256 color modes).

   However, the names `Blue', `Green' etc. stand for the correct colors
in the `Graph' unit of GRX. They are no constants, but functions
(because the color depth is in general not known until runtime), so you
can't use them in contexts where constants are expected. Also, they
might conflict with the identifiers of the `CRT' unit if you use both
units at the same time. If you want to use computed color values in the
range 0 ... 15, you can translate them to the correct colors using the
`EGAColor' function.


File: gpc.info,  Node: OOP units,  Next: Keep; GetIntVec; SetIntVec,  Prev: Graph unit,  Up: BP Incompatibilities

7.2.7 OOP units
---------------

The OOP stuff (Turbo Vision etc.) is not yet completed, but work on
several projects is underway. If you want information about the current
status or access to development source, please contact the GPC mailing
list.


File: gpc.info,  Node: Keep; GetIntVec; SetIntVec,  Next: TFDDs,  Prev: OOP units,  Up: BP Incompatibilities

7.2.8 Keep; GetIntVec; SetIntVec
--------------------------------

The routines `Keep', `GetIntVec' and `SetIntVec' in the `Dos' unit do
not even make sense on DJGPP (32 bit Dos extender). If your program
uses these, it is either a low-level Dos utility for which porting to a
32 bit environment might cause bigger problems (because the internal
issues of DPMI become relevant which are usually hidden by DJGPP), or
it installs interrupt handlers which will have to be thought about more
carefully because of things like locking memory, knowing about and
handling the differences between real and protected mode interrupts,
etc. For these kinds of things, we refer you to the DJGPP FAQ (*note
DJGPP FAQ: (djgppfaq)Top.).


File: gpc.info,  Node: TFDDs,  Next: Mem; Port; Ptr; Seg; Ofs; PrefixSeg; etc.,  Prev: Keep; GetIntVec; SetIntVec,  Up: BP Incompatibilities

7.2.9 TFDDs
-----------

The internal structure of file variables (`FileRec' and `TextRec' in
BP's `Dos' unit and `TFileRec' and `TTextRec' in BP's `WinDos' unit) is
different in GPC.  However, as far as "Text File Device Drivers"
(TFDDs) are concerned, GPC offers a more powerful mechanism. Please see
the RTS reference (*note Run Time System::), under `AssignTFDD'.


File: gpc.info,  Node: Mem; Port; Ptr; Seg; Ofs; PrefixSeg; etc.,  Next: Endianness assumptions,  Prev: TFDDs,  Up: BP Incompatibilities

7.2.10 Mem; Port; Ptr; Seg; Ofs; PrefixSeg; etc.
------------------------------------------------

Those few routines in the `System' unit that deal with segmented
pointers (e.g., `Ptr') are emulated in such a way that such ugly BP
constructs like
     PInteger (Ptr (Seg (a), Ofs (a) + 6 * SizeOf (Integer)))^ = 42
   work in GPC, but they do not provide access to absolute memory
addresses. Neither do `absolute' variables (which take a simple address
in the program's address space in GPC, rather than a segmented
address), and the `Mem' and `Port' arrays don't exist in GPC.

   As a replacement for `Port' on IA32 processors, you can use the
routines provided in the `Ports' unit, *Note Ports::. If you want to
access absolute memory addresses in the first megabyte under DJGPP, you
can't do this with normal pointers because DJGPP programs run in a
protected memory environment, unless you use a dirty trick called "near
pointer hack". Please see the DJGPP FAQ (*note DJGPP FAQ:
(djgppfaq)Top.) for this and for other ways.

   For similar reasons, the variable `PrefixSeg' in the `System' unit
is not supported. Apart from "TSR"s, its only meaningful use in BP
might be the setting of environment variables.  GPC provides the
`SetEnv' and `UnSetEnv' procedures for this purpose which you can use
instead of any BP equivalents based on `PrefixSeg'. (However note that
they will modify the program's own and its childs' environment, not its
parent's environment. This is a property - most people call it a
feature - of the environments, including DJGPP, that GPC compiled
programs run in.)


File: gpc.info,  Node: Endianness assumptions,  Next: - -borland-pascal - disable GPC extensions,  Prev: Mem; Port; Ptr; Seg; Ofs; PrefixSeg; etc.,  Up: BP Incompatibilities

7.2.11 Endianness assumptions
-----------------------------

GPC also runs on big-endian systems (*note Endianness::). This is, of
course, a feature of GPC, but might affect your programs when running
on a big-endian system if they make assumptions about endianness, e.g.,
by using type casts (or `absolute' declarations or variant records
misused as type casts) in certain ways. Please see the demo program
`absdemo.pas' for an example and how to solve it.

   Endianness is also relevant (the more common case) when exchanging
data between different machines, e.g. via binary files or over a
network. Since the latter is not easily possible in BP, and the
techniques to solve the problems are mostly the same as for files, we
concentrate on files here.

   First, you have to choose the endianness to use for the file. Most
known data formats have a specified endianness (usually that of the
processor on which the format was originally created). If you define
your own binary data format, you're free to choose the endianness to
use.

   Then, when reading or writing values larger than one byte from/to
the file, you have to convert them. GPC's Run Time System supports this
by some routines. E.g., you can read an array from a little-endian file
with the procedure `BlockReadLittleEndian', or write one to a
big-endian file with `BlockWriteBigEndian'.  _Note:_ The endianness in
the procedure names refers to the file, not the system - the routines
know about the endianness of the system they run on, but you have to
tell them the endianness of the file to use. This means you do not have
to (and must not) use an `ifdef' to use the version matching the
system's endianness.

   When reading or writing records or other more complicated
structures, either read/write them field by field using
`BlockReadBigEndian' etc., or read/write them with the regular
`BlockRead' and `BlockWrite' procedures and convert each field after
reading or before writing using procedures like `ConvertFromBigEndian'
or `ConvertToLittleEndian' (but remember, when writing, to undo the
conversion afterwards, if you want to keep using the data - this is not
necessary with `BlockWriteLittleEndian' etc.).

   Especially for strings, there are ready-made procedures like
`ReadStringBigEndian' or `WriteStringLittleEndian' which will
read/write the length as a 64 bit value (much space for really long
strings :-) in the given endianness, followed by the characters (which
have no endianness problem).

   All these routines are described in detail in the RTS reference
(*note Run Time System::), under `endianness'. The demo program
`endiandemo.pas' contains an example on how to use these routines.


File: gpc.info,  Node: - -borland-pascal - disable GPC extensions,  Next: -w - disable all warnings,  Prev: Endianness assumptions,  Up: BP Incompatibilities

7.2.12 - -borland-pascal - disable GPC extensions
-------------------------------------------------

GPC warns about some BP constructs which are especially "dirty", like
misusing typed constants as initialized variables. GPC also supports
some features that may conflict with BP code, like macros.  The command
line option `--borland-pascal' disables both, so you might want to use
it for a first attempt to compile your BP code under GPC. However, we
suggest you try compiling without this switch and fixing any resulting
problems as soon as you've become acquainted with GPC.


File: gpc.info,  Node: -w - disable all warnings,  Next: - -uses=System - Swap; HeapError; etc.,  Prev: - -borland-pascal - disable GPC extensions,  Up: BP Incompatibilities

7.2.13 -w - disable all warnings
--------------------------------

Even in `--borland-pascal' mode, GPC may warn about some dangerous
things. To disable *all* warnings, you can use the `-w' option (note:
lower-case `w'!). This is not recommended at all, but you may consider
it more BP compatible ...


File: gpc.info,  Node: - -uses=System - Swap; HeapError; etc.,  Next: -D__BP_TYPE_SIZES__ - small integer types etc.,  Prev: -w - disable all warnings,  Up: BP Incompatibilities

7.2.14 - -uses=System - Swap; HeapError; etc.
---------------------------------------------

A few exotic BP routines and declarations (e.g., `Swap' and
`HeapError') are contained in a `System' unit, *Note System::, which
GPC (unlike BP) does not automatically use in each program. To use it,
you can add a `uses System;' clause to your program. If you don't want
to change your code, the command line option `--uses=System' will do
the same.


File: gpc.info,  Node: -D__BP_TYPE_SIZES__ - small integer types etc.,  Next: - -pack-struct - disable structure alignment,  Prev: - -uses=System - Swap; HeapError; etc.,  Up: BP Incompatibilities

7.2.15 -D__BP_TYPE_SIZES__ - small integer types etc.
-----------------------------------------------------

Since GPC runs on 32 and 64 bit platforms, integer types have larger
sizes than in BP. However, if you use the `System' unit (*note -
-uses=System - Swap; HeapError; etc.::) and define the symbol
`__BP_TYPE_SIZES__' (by giving `-D__BP_TYPE_SIZES__' on the command
line), it will redeclare the types to the sizes used by BP. This is
less efficient and more limiting, but might be necessary if your
program relies on the exact type sizes.


File: gpc.info,  Node: - -pack-struct - disable structure alignment,  Next: -D__BP_RANDOM__ - BP compatible pseudo random number generator,  Prev: -D__BP_TYPE_SIZES__ - small integer types etc.,  Up: BP Incompatibilities

7.2.16 - -pack-struct - disable structure alignment
---------------------------------------------------

GPC by default aligns fields of records and arrays suitably for higher
performance, while BP doesn't. If you don't want the alignment (e.g.,
because the program relies on the internal format of your structures),
give the `--pack-struct' option.


File: gpc.info,  Node: -D__BP_RANDOM__ - BP compatible pseudo random number generator,  Next: -D__BP_UNPORTABLE_ROUTINES__ - Intr; DosVersion; etc.,  Prev: - -pack-struct - disable structure alignment,  Up: BP Incompatibilities

7.2.17 -D__BP_RANDOM__ - BP compatible pseudo random number generator
---------------------------------------------------------------------

GPC uses a more elaborate pseudo random number generator than BP does.
Using the `Random' and `Randomize' functions works the same way, but
there is no `RandSeed' variable (but a `SeedRandom' procedure).
However, if you use the `System' unit (*note - -uses=System - Swap;
HeapError; etc.::) and define the symbol `__BP_RANDOM__' (by giving
`-D__BP_RANDOM__' on the command line), it will provide a 100% BP
compatible pseudo random number generator, including the `RandSeed'
variable, which will produce exactly the same sequence of pseudo random
numbers that BP's pseudo random number generator does. Even the
`Randomize' function will then behave exactly like in BP.


File: gpc.info,  Node: -D__BP_UNPORTABLE_ROUTINES__ - Intr; DosVersion; etc.,  Next: -D__BP_PARAMSTR_0__ - BP compatible ParamStr (0) behaviour,  Prev: -D__BP_RANDOM__ - BP compatible pseudo random number generator,  Up: BP Incompatibilities

7.2.18 -D__BP_UNPORTABLE_ROUTINES__ - Intr; DosVersion; etc.
------------------------------------------------------------

A few more routines in the `Dos' and `WinDos' units besides the ones
mentioned under *Note Keep; GetIntVec; SetIntVec::, like `Intr' or
`DosVersion', are meaningless on non-Dos systems. By default, the `Dos'
unit does not provide these routines (it only provides those that are
meaningful on all systems, which are most of its routines, including
the most commonly used ones). If you need the unportable ones, you get
them by using the `System' unit (*note - -uses=System - Swap;
HeapError; etc.::) and defining the symbol `__BP_UNPORTABLE_ROUTINES__'
(by giving `-D__BP_UNPORTABLE_ROUTINES__' on the command line). If you
use `Intr' or `MsDos', your program will only compile under DJGPP then.
Other routines, e.g. `DosVersion' are emulated quite roughly on other
systems. Please see the notes in the `Dos' unit (*note Dos::) for
details.


File: gpc.info,  Node: -D__BP_PARAMSTR_0__ - BP compatible ParamStr (0) behaviour,  Prev: -D__BP_UNPORTABLE_ROUTINES__ - Intr; DosVersion; etc.,  Up: BP Incompatibilities

7.2.19 -D__BP_PARAMSTR_0__ - BP compatible ParamStr (0) behaviour
-----------------------------------------------------------------

In BP (or under Dos), `ParamStr (0)' always contains the full path of
the current executable. Under GPC, by default it contains what was
passed by the caller as the 0th argument - which is often the name of
the executable, but that's merely a convention, and it usually does not
include the path.

   If you use the `System' unit (*note - -uses=System - Swap;
HeapError; etc.::) and define the symbol `__BP_PARAMSTR_0__' (by giving
`-D__BP_PARAMSTR_0__' on the command line), it will change the value of
`ParamStr (0)' to that of `ExecutablePath', overwriting the value
actually passed by the caller, to imitate BP's/Dos's behaviour.
*However note:* On most systems, `ExecutablePath' is *not* guaranteed to
return the full path, so defining this symbol doesn't change anything.
In general, you *cannot* expect to find the full executable path, so
better don't even try it, or your program will (at best) run on some
systems. For most cases where BP programs access their own executable,
there are cleaner alternatives available.


File: gpc.info,  Node: IDE versus command line,  Next: Comments,  Prev: BP Incompatibilities,  Up: Borland Pascal

7.3 IDE versus command line
===========================

On the Dos (DJGPP) and Linux platforms, you can use RHIDE for GNU
Pascal; check the subdirectories of your DJGPP distribution.

   Unfortunately, there is no IDE which would run on all platforms. We
are working on it, but this will take some time. Please be patient - or
offer your help!

   Without an IDE, the GNU Pascal Compiler, GPC, is called about like
the command-line version of the Borland Pascal Compiler, BPC. Edit your
source file(s) with your favorite ASCII editor, then call GNU Pascal
with a command line like

     C:\GNU-PAS> gpc hello.pas -o hello.exe

on your Dos or OS/2 box or

     myhost:/home/joe/gnu-pascal> gpc hello.pas -o hello

on your Unix (or Unix-compatible) system.

   Don't omit the `.pas' suffix: GPC is a common interface for a Pascal
compiler, a C, ObjC and C++ compiler, an assembler, a linker, and
perhaps an Ada and a FORTRAN compiler. From the extension of your
source file GPC figures out which compiler to run. GPC recognizes
Pascal sources by the extension `.pas', `.p', `.pp' or `.dpr'.

   The `-o' is a command line option which tells GPC how the executable
has to be named. If not given, the executable will be called `a.out'
(Unix) or `a.exe' (Dos). However, you can use the
`--executable-file-name' to tell GPC to always call the executable like
the source (with the extension removed under Unix and changed to `.exe'
under Dos).

   Note that GPC is case-sensitive concerning file names and options,
so it will _not_ work if you type

     C:\GNU-PAS> GPC HELLO.PAS -O HELLO.EXE

   GPC is a very quiet compiler and doesn't print anything on the
screen unless you request it or there is an error. If you want to see
what is going on, invoke GPC with additional options:

     -Q            "don't be quiet"  (or: Quassel-Modus in German)

(with _capital_ `Q'!) means that GPC prints out the names of procedures
and functions it processes, and

     --verbose

or abbreviated

     -v

means that GPC informs you about the stages of compilation, i.e.
preprocessing, compiling, assembling, and linking.

   One example (this time for OS/2):

     [C:\GNU-Pascal] gpc --verbose -Q hello.pas

   Throughout this chapter, we will tell you about a lot of
command-line switches. They are all invoked this way.

   After compilation, there will be an executable `hello' file in the
current directory. (`hello.exe' on Dos or OS/2.) Just run it and enjoy.
If you're new to Unix, please note that the current directory is not on
the PATH in most installations, so you might have to run your program
as `./hello'. This also helps to avoid name conflicts with other
programs. Such conflicts are especially common with the program name
`test' which happens to be a standard utility under Unix that does not
print any output. If you call your program `test.pas', compile it, and
then invoke `test', you will usually not run your program, but the
utility which leads to mysterious problems. So, invoke your program as
`./test' or, better yet, avoid the name `test' for your programs.

   If there are compilation errors, GNU Pascal will not stop
compilation after the first one - as Borland Pascal does - but try to
catch all errors in one compilation. If you get more error messages
than your screen can hold, you can catch them in a file (e.g.
`gpc.out') or pipe them to a program like `more' in the following way:

     gpc hello.pas 2> gpc.out

   This works with OS/2 and any bash-like shell under Unix; for Dos you
must get a replacement for `command.com' which supports this kind of
redirection, or use the `redir' utility (see also the DJGPP FAQ, *Note
DJGPP FAQ: (djgppfaq)Top.):

     C:\GNU-PAS> redir -eo gpc hello.pas -o hello.exe | more

   You can also use Borland's IDE for GNU Pascal on the Dos platform:
Install the GNU Pascal Compiler in the Tools menu (via Options/Tools).

     Name:       GNU Pascal
     Path:       gpc
     Arguments:  $SAVE ALL --executable-file-name $NAME($EDNAME).pas
     HotKey:     Shift+F9

   Note once more that GPC is case-sensitive, so it is important to
specify `.pas' instead of the `.PAS' Borland Pascal would append
otherwise!

   You can include more command-line arguments to GNU Pascal (e.g.
`--automake'; see below) as you will learn more about them.

   Since Borland Pascal will try to recompile your program if you use
its `Run' menu function, you will need another tool to run your program:

     Name:       Run Program
     Path:       command.com
     Arguments:  /c $NAME($EDNAME)
     HotKey:     Shift+F10


File: gpc.info,  Node: Comments,  Next: BP Compatible Compiler Directives,  Prev: IDE versus command line,  Up: Borland Pascal

7.4 Comments
============

GPC supports comments surrounded by `{ }' and `(* *)', just like BP
does. According to the ISO 7185 and ISO 10206 standards, Pascal allows
comments opened with `(*' and closed with `}'. Borland Pascal does not
support such "mixed" comments, so you might have sources where passages
containing comments are "commented out" using the other kind of comment
delimiters. GPC's default behaviour is (like BP) not to allow mixed
comments, so you don't need to worry about this. However, if you happen
to like mixed comments, you can turn them on either by a command-line
option, or by a compiler directive:

     --mixed-comments     {$mixed-comments}    (*$mixed-comments*)

   GPC supports nested comments (e.g., `{ foo { bar } baz }'), but they
are disabled by default (compatible to BP which doesn't know nested
comments at all). You can enable them with the option
`--nested-comments' (or the equivalent compiler directive)

   GPC also supports Delphi style comments starting with `//' and
extending until the end of the line. This comment style is activated by
default unless one of the `--classic-pascal', `--extended-pascal',
`--object-pascal' or `--borland-pascal' dialect options is given. You
can turn them on or off with the `--[no-]delphi-comments' option.


File: gpc.info,  Node: BP Compatible Compiler Directives,  Next: Units; GPI files and Automake,  Prev: Comments,  Up: Borland Pascal

7.5 BP Compatible Compiler Directives
=====================================

All of BP's one-letter compiler directives (except H, P, Q, R, V) are
supported by GPC, though some of them are ignored because they are not
necessary under GPC. Besides, GPC supports a lot more directives. For
an overview, see *Note Compiler Directives::.


File: gpc.info,  Node: Units; GPI files and Automake,  Next: Optimization,  Prev: BP Compatible Compiler Directives,  Up: Borland Pascal

7.6 Units, GPI files and Automake
=================================

You can use units in the same way as in Borland Pascal. However, there
are some additional features.

   Concerning the syntax of a unit, you can, if you want, use Extended
Pascal syntax to specify a unit initializer, i.e., instead of writing

     begin
       ...
     end.

at the end of the unit, you can get the same result with

     to begin do
       begin
         ...
       end;

and there also exists

     to end do
       begin
         ...
       end;

which specifies a finalization routine. You can use this instead of
Borland Pascal's exit procedures, but for compatibility, the included
`System' unit also provides the `ExitProc' variable. The `to begin do'
and/or `to end do' parts must be followed by the final `end.'. See
*Note Modules::, for information about Extended Pascal modules, an
alternative to units.

   When GPC compiles a unit, it produces two files: an `.o' object file
(compatible with other GNU compilers such as GNU C) plus a `.gpi' file
which describes the interface.

   If you are interested in the internal format of GPI file, see *Note
GPI files::.

   If you want to compile a program that uses units, you must "make"
the project. (This is the command-line switch `-M' or the IDE keystroke
`F9' in BP.) For this purpose, GPC provides the command-line switch
`--automake':

     gpc --automake hello.pas

   If you want to force everything to be rebuilt rather than only
recompile changed files (`-B' or "build" in BP), use `--autobuild'
instead of `--automake':

     gpc --autobuild hello.pas

   For more information about the automake mechanism, see *Note
Automake::.

   If you do not want to use the automake mechanism for whatever
reason, you can also compile every unit manually and then link
everything together.

   GPC does not automatically recognize that something is a unit and
cannot be linked; you have to tell this by a command line switch:

     -c            only compile, don't link.

   (If you omit this switch when compiling a unit, you only get a
linker error message `undefined reference to `main''.  Nothing serious.)

   For example, to compile two units, use:

     gpc -c myunit1.pas myunit2.pas

   When you have compiled all units, you can compile a program that
uses them without using `--automake':

     gpc hello.pas

   However, using `--automake' is recommended, since it will recompile
units that were modified.

   You could also specify the program and the units in one command line:

     gpc hello.pas myunit1.pas myunit2.pas

   One of the purposes of writing units is to compile them separately.
However, GNU Pascal allows you to have one or more units in the same
source file (producing only one `.o' file but separate `.gpi' files).
You even can have a program and one or more units in one source file;
in this case, no `.o' file is produced at all.


File: gpc.info,  Node: Optimization,  Next: Debugging,  Prev: Units; GPI files and Automake,  Up: Borland Pascal

7.7 Optimization
================

GNU Pascal is a 32/64 bit compiler with excellent optimization
algorithms (which are identically the same as those of GNU C). There
are six optimization levels, specified by the command line options
`-O', `-O2', ..., `-O6'.

   One example:

     program OptimizationDemo;

     procedure Foo;
     var
       A, B: Integer;
     begin
       A := 3;
       B := 4;
       WriteLn (A + B)
     end;

     begin
       Foo
     end.

   When GNU Pascal compiles this program with optimization (`-O3'), it
recognizes that the argument to `WriteLn' is the constant 7 - and
optimizes away the variables `A' and `B'. If the variables were global,
they would not be optimized away because they might be accessed from
other places, but the constant 7 would still be optimized.

   For more about optimization, see the GNU C documentation.


File: gpc.info,  Node: Debugging,  Next: Objects,  Prev: Optimization,  Up: Borland Pascal

7.8 Debugging
=============

The command line option `-g' specifies generation of debugging
information for GDB, the GNU debugger. GDB comes with its own
documentation. Currently, GDB does not understand Pascal syntax, so you
should be familiar with C expressions if you want to use it.

   See also "Notes for debugging" in the "Programming" chapter; see
*Note Notes for Debugging::.

   Sometimes it is nice to have a look at the assembler output of the
compiler. You can do this in a debugger or disassembler (which is the
only way to do it in BP), but you can also tell GPC to produce
assembler code directly: When you specify the `-S' command line option,
GPC produces an `.s' file instead of an `.o' file.  The `.s' file
contains assembler source for your program. More about this in the next
section.


File: gpc.info,  Node: Objects,  Next: Strings in BP and GPC,  Prev: Debugging,  Up: Borland Pascal

7.9 Objects
===========

Objects in the Borland Pascal 7.0 notation are implemented into GNU
Pascal with the following differences:

   * the `private', `protected', `public' and `published' directives
     are recognized but ignored,

   * data fields and methods may be mixed:
          type
            MyObj = object
              x: Integer;
              procedure Foo; virtual;
              y: Real;
              function Bar: Char;
            end;


File: gpc.info,  Node: Strings in BP and GPC,  Next: Typed Constants,  Prev: Objects,  Up: Borland Pascal

7.10 Strings in BP and GPC
==========================

Strings are "Schema types" in GNU Pascal which is something more
advanced than Borland-style strings. For variables, you cannot specify
just `String' as a type like in Borland Pascal; for parameters and
pointer types you can. There is no 255 characters length limit.
According to Extended Pascal, the maximum string length must be in
(parentheses); GNU Pascal accepts [brackets], too, however, like BP.

   For more about strings and schema types see *Note Schema Types::.

   GPC supports Borland Pascal's string handling functions and some
more (see *Note String Operations::):

Borland Pascal           GNU Pascal
Length                   Length
Pos                      Pos, Index (1)
Str                      Str, WriteStr (1) (2)
Val                      Val, ReadStr (2)
Copy                     Copy, SubStr, MyStr[2 .. 7] (3)
Insert                   Insert
Delete                   Delete
MyStr[0] := #7           SetLength (MyStr, 7)
=, <>, <, <=, >, >=      =, <>, <, <=, >, >= (4)
                         EQ, NE, LT, LE, GT, GE
n/a                      Trim

   Notes:

   (1) The order of parameters of the Extended Pascal routines
(`Index', `WriteStr') is different from the Borland Pascal routines.

   (2) `ReadStr' and `WriteStr' allow an arbitrary number of arguments,
and the arguments are not limited to numbers.  `WriteStr' also allows
comfortable formatting like `WriteLn' does, e.g.  `WriteStr (Dest, Foo
: 20, Bar, 1/3 : 10 : 2)'.

   (3) `SubStr' reports a runtime error if the requested substring does
not fit in the given string, `Copy' does not (like in BP).

   (4) By default, the string operators behave like in BP. However, if
you use the option `--no-exact-compare-strings' or `--extended-pascal',
they ignore differences of trailing blanks, so, e.g., `'foo'' and `'foo
 '' are considered equal. The corresponding functions (`EQ', ...)
always do exact comparisons.


File: gpc.info,  Node: Typed Constants,  Next: Bit; Byte and Memory Manipulation,  Prev: Strings in BP and GPC,  Up: Borland Pascal

7.11 Typed Constants
====================

GNU Pascal supports Borland Pascal's "typed constants" but also
Extended Pascal's initialized variables:

     var
       x: Integer value 7;

   or

     var
       x: Integer = 7;

   When a typed constant is misused as an initialized variable, a
warning is given unless you specify `--borland-pascal'.

   When you want a local variable to preserve its value, define it as
`static' instead of using a typed constant. Typed constants also become
static automatically for Borland Pascal compatibility, but it's better
not to rely on this "feature" in new programs.  Initialized variables
do not become static automatically.

     program StaticDemo;

     procedure Foo;
     { x keeps its value between two calls to this procedure }
     var
       x: Integer = 0; attribute (static);
     begin
       WriteLn (x);
       Inc (x)
     end;

     begin
       Foo;
       Foo;
       Foo;
     end.

   For records and arrays, GPC supports both BP style and Extended
Pascal style initializers. When you initialize a record, you may omit
the field names. When you initialize an array, you may provide indices
with a `:'. However, this additional information is ignored completely,
so perhaps it's best for the moment to only provide the values ...

     program BPInitVarDemo;
     const
       A: Integer = 7;
       B: array [1 .. 3] of Char = ('F', 'o', 'o');
       C: array [1 .. 3] of Char = 'Bar';
       Foo: record
         x, y: Integer;
       end = (x: 3; y: 4);
     begin
     end.


File: gpc.info,  Node: Bit; Byte and Memory Manipulation,  Next: User-defined Operators in GPC,  Prev: Typed Constants,  Up: Borland Pascal

7.12 Bit, Byte and Memory Manipulation
======================================

The bitwise operators `shl', `shr', `and', `or', `xor' and `not' work
in GNU Pascal like in Borland Pascal.  As an extension, you can use
them as procedures, for example

     program AndProcedureDemo;
     var x: Integer;
     begin
       and (x, $0000ffff);
     end.

   as an alternative to

     program AndOperatorDemo;
     var x: Integer;
     begin
       x := x and $0000ffff;
     end.

   GPC accepts the BP style notation `$abcd' for hexadecimal numbers,
but you also can use Extended Pascal notation:

     program EPBaseDemo;
     const
       Binary =  2#11111111;
       Octal  =  8#177;
       Hex    = 16#ff;
     begin
     end.

   and so on up to a basis of 36. Of course, you can mix the notations
as you like, e.g.:

     program BPEPBaseDemo;
     begin
       WriteLn ($cafe = 2#1100101011111110)
     end.

   `Inc' and `Dec' are implemented like in Borland Pascal.  `Pred' and
`Succ' are generalized according to Extended Pascal and can have a
second (optional) parameter:

     procedure SuccDemo;
     var a: Integer = 42;
     begin
       a := Succ (a, 5);
       WriteLn (a) { 47 }
     end.

   BP style `absolute' variables work in the context of overloading
other variables as well as in the context of specifying an absolute
address, but the latter is highly unportable and not very useful even
in Dos protected mode.

     program BPAbsoluteDemo;

     type
       TString = String (80);
       TTypeChoice = (t_Integer, t_Char, t_String);

     { @@ WARNING: BAD STYLE! }
     procedure ReadVar (var x: Void; TypeChoice: TTypeChoice);
     var
       xInt: Integer absolute x;
       xChar: Char absolute x;
       xStr: TString absolute x;
     begin
       case TypeChoice of
         t_Integer: ReadLn (xInt);
         t_Char   : ReadLn (xChar);
         t_String : ReadLn (xStr);
       end
     end;

     var
       i: Integer;
       c: Char;
       s: TString;

     begin
       ReadVar (i, t_Integer);
       ReadVar (c, t_Char);
       ReadVar (s, t_String);
       WriteLn (i, ' ', c, ' ', s)
     end.

   GNU Pascal knows Borland Pascal's procedures `FillChar' and `Move'.
However, their use can be dangerous because it often makes implicit
unportable assumptions about type sizes, endianness, internal
structures or similar things. Therefore, avoid them whenever possible.
E.g., if you want to clear an array of strings, don't `FillChar' the
whole array with zeros (this would overwrite the Schema discriminants,
see *Note Strings::), but rather use a `for' loop to assign the empty
string to each string. In fact, this is also more efficient than
`FillChar', since it only has to set the length field of each string to
zero.


File: gpc.info,  Node: User-defined Operators in GPC,  Next: Data Types in BP and GPC,  Prev: Bit; Byte and Memory Manipulation,  Up: Borland Pascal

7.13 User-defined Operators in GPC
==================================

GNU Pascal allows the user to define operators according to the
Pascal-SC syntax:

     program PXSCOperatorDemo;

     type
       Point = record
         x, y: Real;
       end;

     operator + (a, b: Point) c: Point;
     begin
       c.x := a.x + b.x;
       c.y := a.y + b.y;
     end;

     var
       a, b, c: Point = (42, 0.5);

     begin
       c := a + b
     end.

   The Pascal-SC operators `+>', `+<', etc. for exact numerical
calculations are not implemented, but you can define them.


File: gpc.info,  Node: Data Types in BP and GPC,  Next: BP Procedural Types,  Prev: User-defined Operators in GPC,  Up: Borland Pascal

7.14 Data Types in BP and GPC
=============================

   * Integer types have different sizes in Borland and GNU Pascal:

     Borland Pascal      GNU Pascal         Bits (1)     Signed
     ShortInt            ByteInt             8           yes
     Integer             ShortInt           16           yes
     LongInt             Integer            32           yes
     Comp                LongInt, Comp      64           yes
     Byte                Byte                8           no
     Word                ShortWord          16           no
     n/a                 Word               32           no
     n/a                 LongWord           64           no

     (1) The size of the GNU Pascal types may depend on the platform.
     The sizes above apply to 32 bit platforms, including the IA32.

     If you care for types with exactly the same size as in Borland
     Pascal, take a look at the `System' unit and read its comments.

     You can get the size of a type with `SizeOf' in bytes (like in
     Borland Pascal) and with `BitSizeOf' in bits, and you can declare
     types with a specific size (given in bits), e.g.:

          program IntegerSizeDemo;
          type
            MyInt  = Integer attribute (Size = 42);  { 42 bits, signed }
            MyWord = Word attribute (Size = 2);      { 2 bits, unsigned,
                                                        i.e., 0 .. 3 }
            MyCard = Cardinal attribute (Size = 2);  { the same }

            HalfInt = Integer attribute (Size = BitSizeOf (Integer) div 2);
              { A signed integer type which is half as big as the normal
                `Integer' type, regardless of how big `Integer' is
                on any platform the program is compiled on. }

          begin
          end.

   * Borland's real (floating point) types are supported except for the
     6-byte software Real type (but the `System' unit provides
     conversion routines for it). GNU Pascals's `Real' type has 8 bytes
     on the IA32 and is the same as `Double'. In addition there are
     alternative names for real types:

     Borland Pascal      GNU Pascal
     Single              Single, ShortReal
     Real                n/a (1)
     Double              Double, Real
     Extended            Extended, LongReal
     Comp                LongInt, Comp (see above)

     (1) But see `BPReal', `RealToBPReal' and `BPRealToReal' in GPC's
     `System' unit.

   * Complex numbers: According to Extended Pascal, GNU Pascal has
     built-in complex numbers and supports a number of mathematical
     functions on them, e.g. `Abs', `Sqr', `SqRt', `Exp', `Ln', `Sin',
     `Cos', `ArcTan'.

   * Record types: GNU Pascal by default aligns 32-bit fields on 4-byte
     addresses because this improves performance. So, e.g., the record
          type
            MyRec = record
              f, o, oo: Boolean;
              Bar: Integer
            end;
     has 8 bytes, not 7. Use the `--pack-struct' option or declare the
     record as `packed' to force GPC to pack it to 7 bytes.  However,
     note that this produces somewhat less efficient code on the IA32
     and far less efficient code on certain other processors.  Packing
     records and arrays is mostly useful only when using large
     structures where memory usage is a real concern, or when reading or
     writing them from/to binary files where the exact layout matters.



File: gpc.info,  Node: BP Procedural Types,  Next: Files,  Prev: Data Types in BP and GPC,  Up: Borland Pascal

7.15 BP Procedural Types
========================

In addition to BP's procedural types, GNU Pascal has pointers to
procedures:

     type
       FuncPtr = ^function (Real): Real;

   The differences between procedure pointers and procedural types are
only syntactical:

   * In the first case, one can pass/assign a procedure/function with
     `@myproc', in the latter case just with `myproc' (which can lead
     to confusion in the case of functions - though GPC should always
     recognize the situation and not try to call the function).

   * In the first case, one can call the routine via `myprocptr^', in
     the latter case just with `myprocvar'.

   * To retrieve the address of a procedure stored in a variable, one
     can use `myprocptr' in the first case and `@myprocvar' in the
     latter.

   * If, for some reason, one needs the address of the variable itself,
     in the first case, that's obtained with `@myprocptr', in the
     second case with `@@myprocvar'!

   * Bottom line: BP style procedural types are simpler to use in normal
     cases, but somewhat strange in the last example.

   One can use both kinds in the same program, of course, though it is
recommended to stick to one kind throughout to avoid maximum confusion.

   GNU Pascal also supports Standard Pascal's procedural parameters
(*note Special Parameters::).

   Furthermore, GNU Pascal allows you to call even local procedures
through procedural pointers, variables or parameters without reverting
to any dirty tricks such as assembler (which is necessary in BP).

   The differences between the various kinds of procedural types,
pointers and parameters are demonstrated in the demo program
`procvardemo.pas'. An example for calling local routines through
procedural parameters can be found in the demo program
`iteratordemo.pas'.


File: gpc.info,  Node: Files,  Next: Built-in Constants,  Prev: BP Procedural Types,  Up: Borland Pascal

7.16 Files
==========

   * GPC supports files like in Borland Pascal, including untyped files,
     `BlockRead', `BlockWrite' and `Assign'. Instead of `Assign', you
     can also use the `Bind' mechanism of Extended Pascal.

     Besides the routines supproted by BP, there are many more routines
     available that deal with files, file names and similar things in a
     portable way. In contrast to Borland Pascal, you don't have to use
     any platform-specific units to do these kinds of things, though
     portable emulations of those units (e.g., of the `Dos' and
     `WinDos' units) are also available for compatibility.



File: gpc.info,  Node: Built-in Constants,  Next: Built-in Operators in BP and GPC,  Prev: Files,  Up: Borland Pascal

7.17 Built-in Constants
=======================

   * The `MaxInt', `MaxLongInt', `Pi' constants are supported like in
     BP.

   * Other built-in constants: GNU Pascal has `MaxChar', `MaxReal',
     `MinReal', `EpsReal' and a number of other useful constants.


File: gpc.info,  Node: Built-in Operators in BP and GPC,  Next: Built-in Procedures and Functions,  Prev: Built-in Constants,  Up: Borland Pascal

7.18 Built-in Operators in BP and GPC
=====================================

Besides the operators found in Borland Pascal, GNU Pascal supports the
following operators:

   * Exponentiation: According to Extended Pascal, GNU Pascal supports
     the exponentiation operators `pow' and `**' which do not exist in
     Borland Pascal. You can use `x pow y' for integer and `x ** y' for
     real or complex exponents. The basis may be integer, real or
     complex in both cases.

   * GNU Pascal has a symmetric set difference operator `set1 >< set2'.
     For more about this, see *Note Set Operations::.


File: gpc.info,  Node: Built-in Procedures and Functions,  Next: Special Parameters,  Prev: Built-in Operators in BP and GPC,  Up: Borland Pascal

7.19 Built-in Procedures and Functions
======================================

   * `GetMem' and `FreeMem' are supported like in BP.

     The second parameter to `FreeMem' is ignored by GNU Pascal and may
     be omitted. Memory blocks are always freed with the same size they
     were allocated with.

     Remark: Extended Pascal Schema types provide a cleaner approach to
     most of the applications of `GetMem' and `FreeMem'.

   * `Min' and `Max': GNU Pascal has built-in `Min' and `Max' functions
     (two arguments) which work for all ordinal types (`Integer',
     `Char', ...) plus `Real'.

   * `UpCase', `High', `Low' and similar functions are built-in. In
     contrast to Borland Pascal, GNU Pascal's `UpCase' function is
     aware of non-ASCII characters of certain languages (e.g., accented
     letters and "umlauts"), but for compatibility this feature is
     disables in `--borland-pascal' mode. There is also a `LoCase'
     function.

   * `Lo', `Hi', `Swap' functions: not built-in, but available in the
     `System' unit.


File: gpc.info,  Node: Special Parameters,  Next: Miscellaneous,  Prev: Built-in Procedures and Functions,  Up: Borland Pascal

7.20 Special Parameters
=======================

   * Untyped reference parameters can be denoted by

          procedure Foo (var x);

     like in Borland Pascal. In GNU Pascal, you can also use

          procedure Foo (var x: Void);

   * GNU Pascal defines "ellipsis" parameters for variable argument
     lists:

          procedure Foo (a: Integer; ...);

     However, GPC does not (yet) provide a portable mechanism to access
     the additional arguments.

   * Structured function result types: According to Extended Pascal, GNU
     Pascal allows functions to return records and arrays.

   * BP style "open array parameters"
          procedure Foo (a: array of Integer);
     are implemented. However, Standard Pascal `conformant array
     parameters' are usually a cleaner mechanism to pass arrays of
     variable size.

   * Besides BP compatible procedural types and procedure pointers
     (*note BP Procedural Types::), GNU Pascal supports Standard
     Pascal's procedural parameters:

          procedure DrawGraph (function f (x: Real): Real);


File: gpc.info,  Node: Miscellaneous,  Next: BP and Extended Pascal,  Prev: Special Parameters,  Up: Borland Pascal

7.21 Miscellaneous
==================

   * Headlines: According to Extended Pascal, a program headline must
     contain the program's parameters:

          program Foo (Input, Output);
          begin
          end.

     In GNU Pascal, headline parameters are optional. If the headline is
     omitted entirely, a warning is given unless you have specified
     `--borland-pascal' in the command line.

   * `case' statements: In a `case' statement, GNU Pascal allows
     `otherwise' (according to Extended Pascal) as an alternative to
     `else':

          program CaseOtherwiseDemo;
          var x: Integer;
          begin
            ReadLn (x);
            case x of
              1: WriteLn ('one');
              2: WriteLn ('two');
              otherwise
                 WriteLn ('many')
            end
          end.

     Note: In the absence of a `case' or `otherwise' branch, missing
     cases labels cause an error in Extended Pascal (which goes
     unnoticed in Borland Pascal). GPC does not give this error, but a
     warning if the `-Wswitch' option is given, however only for
     enumeration types.

   * Character constants: BP compatible character constants like `^M'
     as well as `#13' are implemented into GNU Pascal.

   * Sets: GNU Pascal has a `Card' function for sets which counts their
     elements. Unlike Borland Pascal, GNU Pascal does not limit sets to
     the range 0 .. 255.

   * Inline: GNU Pascal allows "inline" Pascal procedures and
     functions, while Borland Pascal only allows machine code to be
     inlined:

     Borland Pascal:

          function Max (x, y: Integer): Integer;
            inline ($58 / $59 / $3b / $c1 / $7f / $01 / $91);

     GNU Pascal:

          program InlineDemo;

          function Max (x, y: Integer): Integer; attribute (inline);
          begin
            if x > y then
              Max := x
            else
              Max := y
          end;

          begin
            WriteLn (Max (42, 17), ' ', Max (-4, -2))
          end.

     (Actually, a more general `Max' function is already built in.)

     This feature is not so important as it might seem because in
     optimization level 3 or higher (*note GPC Options::), GNU Pascal
     automatically inlines short procedures and functions.


File: gpc.info,  Node: BP and Extended Pascal,  Next: Portability hints,  Prev: Miscellaneous,  Up: Borland Pascal

7.22 BP and Extended Pascal
===========================

Pascal is a well-known programming language and hardly needs to be
described here. Note, however, that there is a large difference between
the language used by the BP compiler and the Pascal Standards.

   Extended Pascal is a standardized language based on the original
Standard Pascal, but with significant extensions. Unfortunately,
Borland Pascal does not conform to any of the Pascal standards.
Writing a program that both complies to Extended Pascal (or even
Standard Pascal) and compiles with BP is almost impossible for any
non-trivial task.

   On the other hand, BP has some nice features that make it very
powerful in the environments in which it runs. However, some of those
features are of little use on non-Dos systems and would not be good
candidates for standardization.

   There are also several BP features which are semantically similar to
features in Standard Pascal or Extended Pascal, but syntactically
different.

   Therefore, in order to be useful to users coming from either side,
GPC supports both the standards and the BP dialect as good as possible.
By default, GPC allows features from any dialect it knows.  By giving a
dialect option such as `--borland-pascal' or `--extended-pascal', you
can tell GPC to disable the features not found in that dialect, and to
adjust its warning behaviour to the dialect.

   The different sets of reserved words are a little problem, but GPC
solves it by making the words in question only "conditionally reserved"
which works transparently without problems in most cases. Still, giving
a dialect option will disable all keywords not part of this dialect.

   Apart from this, there are surprisingly few real conflicts between
the dialects. Therefore, you can usually compile your BP code without
the `--borland-pascal' option and make use of all of GPC's features.
You might be surprised, though, when GPC accepts things you didn't know
were allowed. :-)

   Finally, if you want to make use of some of GPC's extensions
(compared to BP) and still keep the code compileable with BP without
using `ifdef's all over the place, we suggest you look at the unit
`gpc-bp.pas', shipped with GPC, which contains BP versions of some of
GPC's features. Please read the comments at the beginning of the unit
to find out more about it.


File: gpc.info,  Node: Portability hints,  Prev: BP and Extended Pascal,  Up: Borland Pascal

7.23 Portability hints
======================

GPC offers you the possibility to make your code fully portable to each
of the many platforms supported by GPC. It would be a pity not to make
use of this.

   This section lists some known pitfalls that often hinder otherwise
well-written programs to take full advantage of GPC. If you have never
used any compiler but Borland Pascal and similar compilers, some of the
advices might look strange to you. But this is just the same level of
strangeness that your old programs will have for you once you have
understood the principles of cross-platform portability. Remember that
many tricks you have always been applying almost automatically in
Borland Pascal were necessary to overcome certain limitations of the
Dos platform and to compensate for the compiler's missing optimization.
Programming with an optimizing compiler like GPC for platforms without
a 64 kB limit is a completely new experience - and perhaps it is among
the reasons why you are now working with GPC in the first place?

Portability - why?
------------------

_Okay - but why should I bother and make my program portable?  I know
that all who want to use my program are running WXYZ-OS anyway._

   Yes, but that's the result of a self-fulfilling prophecy. It depends
on *you* whether it will always remain like this or not.  Consider a
program ABC written for a single platform, WXYZ-OS.  Naturally, only
WXYZ-OS-users get interested in ABC. The author gets feedback only from
WXYZ-OS users and does not see any reason to make the program
cross-platform. Then people realize that if they want to run ABC they
must move to WXYZ-OS. The author concludes that people only want
WXYZ-OS programs, and so on.

   To break out, just create a portable version of your program *now*.
Then all OSes have equal chances to show their abilities when running
your program, and your customers can choose their OS. Then, maybe, they
decide to use your program just for the reason that they can be sure
that it will run on all present and future platforms and not only on a
specific one - who knows?

   _My program is a tool specifically designed to make the best of the
STUV feature of WXYZ-OS. There is no point in making it portable._

   How much do you know about non-WXYZ-OSes? Just ask an expert how the
STUV feature is named elsewhere. Be sure, if it is of value, it exists
almost everywhere.

Low-level features
------------------

_I am using a lot of low-level stuff in my programs, so they cannot be
portable._

   You do not use those low-level routines directly in your high-level
routines, do you? There should always be a layer "in-between" that
encapsulates the low-level routines and present an API to your program
that exactly reflects the needs of your application.  This "API in
between" is the point where you can exchange the low-level routines by
portable calls to GPC's Run Time System.

   If you do not have such a layer in-between, then the API of the
low-level routines you call are your first approximation for such a
layer.  If you have ever thought "it would be great if that API
function had that additional parameter", then your own extended version
of that API function that *has* that parameter can become part of your
"API in between".  But then don't stop here: Certainly the API of the
OS is *not* ideal for your program's needs. Just create more routines
that encapsulate all OS-specific stuff ...

   When the low-level stuff in question consists of interrupts,
assembler and similar things, then the first thing you need is a
portable replacement of the functionality. Fortunately, GPC covers many
things already in Pascal that require assembler in Borland Pascal:

   * GPC's units and libraries come with source. You do not need to
     learn assembler and to write a complete replacement for the CRT
     unit if you only want to adapt some tiny detail in the behavior of
     CRT to your personal needs.

   * GPC's Run Time System is fairly complete. For example, to extract
     the assigned name of a `File' variable, you do not need to mess
     around with the internal representation of those variables, but you
     can type `uses GPC' and then use the `FileName' function.  In the
     same unit, you will find a `FileExists' function and much more.

   * Manually "constructing" an object is covered by the `SetType'
     procedure in GPC. This is where Turbo Vision uses assembler to load
     an object from a stream.

   * Calling local procedures and functions via pointers simply works in
     GPC. This is another place where, for instance, Turbo Vision's
     `ForEach' method uses assembler, while GPC lets you do the same
     thing in Pascal.

   * Interfacing with the OS can be done through library calls. GPC's
     built-in functions and the GPC unit offer a rather complete set of
     routines. And again: You have the source of all this.

   * Using `FillChar' and `Move' does not necessarily speed up your
     programs. Using them to circumvent restrictions of the language
     (e.g. for direct assignments between variables of object or file
     type) is asking for trouble. `FillChar' was created in UCSD Pascal
     to set consecutive chars in a string to the same value, and `Move'
     was created to move the chars within the same string.  Better do
     not use them for other purposes.



File: gpc.info,  Node: Reference,  Next: Keywords,  Prev: Borland Pascal,  Up: Top

8 The Alphabetical GPC Language Reference
*****************************************

*This chapter is still under development. All keywords and built-in
identifiers are listed, but not all with explanations.*

   This chapter contains an alphabetical list of all keywords (reserved
words) and built-in identifiers of the GNU Pascal compiler. For
detailed and comprehensive description of syntax and reserved words,
see *Note Programming::. This chapter explains only built-in procedures
and functions in detail.

   It does not cover extensions provided by external units and
libraries which are supposed to come with their own documentation.  For
the interfaces of the units that come with GPC, see *Note GPC Units::.

* Menu:

* Abs::
* absolute::
* abstract::
* Addr::
* AlignOf::
* all::
* and::
* and then::
* and_then::
* AnsiChar::
* AnyFile::
* Append::
* ArcCos::
* ArcSin::
* ArcTan::
* Arg::
* array::
* as::
* asm::
* asmname::
* Assert::
* Assign::
* Assigned::
* attribute::
* begin::
* Bind::
* bindable::
* Binding::
* BindingType::
* BitSizeOf::
* BlockRead::
* BlockWrite::
* Boolean::
* Break::
* Byte::
* ByteBool::
* ByteCard::
* ByteInt::
* c::
* Card::
* Cardinal::
* case::
* CBoolean::
* CCardinal::
* Char::
* ChDir::
* Chr::
* CInteger::
* c_language::
* class::
* Close::
* Cmplx::
* Comp::
* CompilerAssert::
* Complex::
* Concat::
* Conjugate::
* const::
* constructor::
* Continue::
* Copy::
* Cos::
* CString::
* CString2String::
* CStringCopyString::
* CurrentRoutineName::
* CWord::
* Cycle::
* Date::
* Dec::
* DefineSize::
* Delete::
* destructor::
* Discard::
* Dispose::
* div::
* do::
* Double::
* downto::
* else::
* Empty::
* end::
* EOF::
* EOLn::
* EpsReal::
* EQ::
* EQPad::
* Erase::
* except::
* Exclude::
* Exit::
* Exp::
* export::
* exports::
* Extend::
* Extended::
* external::
* Fail::
* False::
* far::
* file::
* FilePos::
* FileSize::
* FillChar::
* finalization::
* Finalize::
* finally::
* Flush::
* for::
* FormatString::
* forward::
* Frac::
* FrameAddress::
* FreeMem::
* function::
* GE::
* GEPad::
* Get::
* GetMem::
* GetTimeStamp::
* goto::
* GT::
* GTPad::
* Halt::
* High::
* if::
* Im::
* implementation::
* import::
* in::
* Inc::
* Include::
* Index::
* inherited::
* initialization::
* Initialize::
* InOutRes::
* Input::
* Insert::
* Int::
* Integer::
* interface::
* interrupt::
* IOResult::
* is::
* label::
* LastPosition::
* LE::
* Leave::
* Length::
* LEPad::
* library::
* Ln::
* LoCase::
* LongBool::
* LongCard::
* LongestBool::
* LongestCard::
* LongestInt::
* LongestReal::
* LongestWord::
* LongInt::
* LongReal::
* LongWord::
* Low::
* LT::
* LTPad::
* Mark::
* Max::
* MaxChar::
* MaxInt::
* MaxReal::
* MedBool::
* MedCard::
* MedInt::
* MedReal::
* MedWord::
* Min::
* MinReal::
* MkDir::
* mod::
* module::
* Move::
* MoveLeft::
* MoveRight::
* name::
* NE::
* near::
* NEPad::
* New::
* NewCString::
* nil::
* not::
* Null::
* object::
* Odd::
* of::
* on::
* only::
* operator::
* or::
* Ord::
* or else::
* or_else::
* otherwise::
* Output::
* overload::
* override::
* Pack::
* packed::
* Page::
* PAnsiChar::
* ParamCount::
* ParamStr::
* PChar::
* Pi::
* PObjectType::
* Pointer::
* Polar::
* Pos::
* Position::
* pow::
* Pred::
* private::
* procedure::
* program::
* property::
* protected::
* PtrCard::
* PtrDiffType::
* PtrInt::
* PtrWord::
* public::
* published::
* Put::
* qualified::
* raise::
* Random::
* Randomize::
* Re::
* Read::
* ReadLn::
* ReadStr::
* Real::
* record::
* Release::
* Rename::
* repeat::
* Reset::
* resident::
* restricted::
* Result::
* Return::
* ReturnAddress::
* Rewrite::
* RmDir::
* Round::
* RunError::
* Seek::
* SeekEOF::
* SeekEOLn::
* SeekRead::
* SeekUpdate::
* SeekWrite::
* segment::
* Self::
* set::
* SetFileTime::
* SetLength::
* SetType::
* shl::
* ShortBool::
* ShortCard::
* ShortInt::
* ShortReal::
* ShortWord::
* shr::
* Sin::
* Single::
* SizeOf::
* SizeType::
* SmallInt::
* Sqr::
* SqRt::
* StandardError::
* StandardInput::
* StandardOutput::
* StdErr::
* Str::
* String::
* String2CString::
* SubStr::
* Succ::
* Text::
* then::
* Time::
* TimeStamp::
* to::
* to begin do::
* to end do::
* Trim::
* True::
* Trunc::
* Truncate::
* try::
* type::
* type of::
* TypeOf::
* Unbind::
* unit::
* Unpack::
* until::
* UpCase::
* Update::
* uses::
* Val::
* value::
* var::
* view::
* virtual::
* Void::
* while::
* with::
* Word::
* WordBool::
* Write::
* WriteLn::
* WriteStr::
* xor::


File: gpc.info,  Node: Abs,  Next: absolute,  Up: Reference

Abs
===

Synopsis
--------

     function Abs (i: INTEGER_TYPE): INTEGER_TYPE;
or
     function Abs (x: REAL_TYPE): REAL_TYPE;
   or
     function Abs (z: COMPLEX_TYPE): REAL_TYPE;

Description
-----------

Returns the absolute value of the argument. For integer or real values
of `x', the definition is

     function Abs (x: INTEGER_OR_REAL_TYPE): INTEGER_OR_REAL_TYPE;
     begin
       if x < 0 then
         Abs := -x
       else
         Abs := x
     end;

whereas for complex values it is

     function Abs (x: Complex): Real;
     begin
       Abs := SqRt (x * Conjugate (x))
     end;

Conforming to
-------------

The function `Abs' is defined in ISO 7185 Pascal; its application to
complex values is defined in ISO 10206 Extended Pascal.

Example
-------

     program AbsDemo;
     var
       i1: Complex;
     begin
       WriteLn (Abs (42));             { 42 }
       WriteLn (Abs (-42));            { 42 }
       WriteLn (Abs (-12.1) : 0 : 1);  { 12.1 }
       i1 := Cmplx (1, 1);             { 1 + i }
       WriteLn (Abs (i1) : 0 : 3)      { 1.414, i.e. SqRt (2) }
     end.

See also
--------

*Note Sqr::.


File: gpc.info,  Node: absolute,  Next: abstract,  Prev: Abs,  Up: Reference

absolute
========

Synopsis
--------

     var
       VARIABLE_NAME: DATA_TYPE absolute VARIABLE_REFERENCE;
or
     var
       VARIABLE_NAME: DATA_TYPE absolute INTEGER_EXPRESSION;

Description
-----------

The first meaning of the `absolute' directive allows to put a variable
to the address of another one and thus provides a type-casting
mechanism.

   In most cases, VARIABLE_REFERENCE will be just a variable name, but
GPC also allows arbitrary pointer expressions here. If
VARIABLE_REFERENCE has neither a constant address nor is a variable
parameter, GPC prints a warning. This warning is suppressed in
"extended syntax" mode which is switched on by the `--extended-syntax'
option or the `{$X+}' compiler directive.

   GPC also allows explicit type casts. Variant records (as defined in
ISO 7185 Pascal), however, have no _guaranteed_ overlaying and are
therefore _not_ suitable for type casts.

   The second meaning of `absolute' places a variable at a specified
address. This is useful on machines without virtual memory addressing
for doing certain low-level operations, but should be avoided on
systems with memory protection such as Unix-like systems.  GPC does not
check whether the specified virtual address makes any sense and does
not provide a built-in mechanism to map it to a real address.

   GPC warns about this second use of `absolute' unless "extended
syntax" has been requested.

Conforming to
-------------

`absolute' is a Borland Pascal extension.

   Borland Pascal has a slightly different syntax for the second
meaning related to the addressing scheme of IA32 processors working in
real mode.

   Allowing arbitrary memory references instead of just variable names
in the first meaning of `absolute' is a GNU Pascal extension.

Example
-------

     program AbsoluteDemo;

     {$X+}

     const
       IOMem = $f0000000;
       MaxVarSize = MaxInt div 8;

     var
       Mem: array [0 .. MaxVarSize - 1] of Byte absolute 0;

       { This address has no actual meaning }
       MyPort: Byte absolute IOMem + $c030;

     { Beware: Using any of the variables above will crash
       your program unless you know exactly what you do!
       That's why GPC warns about it without the $X+ directive. }

     var
       x: Real;
       a: array [1 .. SizeOf (Real)] of Byte absolute x;
       i: Integer;
       b: Byte absolute a[i];  { GNU Pascal extension:
                                  non-constant memory reference. }

     begin
       x := 3.14;

       { Look at the internal representation of a real variable. }
       for i := 1 to SizeOf (Real) do
         Write (a[i] : 4);
       WriteLn;

       { The same again, more ugly ... }
       for i := 1 to SizeOf (Real) do
         Write (b : 4);
       WriteLn;

       { And yes, there's an even more ugly way to do it ... }
       for i := 1 to SizeOf (Real) do
         Write (Mem[PtrCard (@x) + i - 1] : 4);
       WriteLn
     end.

See also
--------

*Note Keywords::, *Note record::, *Note Type Casts::.


File: gpc.info,  Node: abstract,  Next: Addr,  Prev: absolute,  Up: Reference

abstract
========

Not yet implemented.

Synopsis
--------

Description
-----------

Abstract object type or method declaration.

Conforming to
-------------

`abstract' is an Object Pascal extension.

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: Addr,  Next: AlignOf,  Prev: abstract,  Up: Reference

Addr
====

Synopsis
--------

     function Addr (const Foo): Pointer;

Description
-----------

`Addr' returns the address of its argument. It is equivalent to the
address operator.

   Note: In BP, `Addr' returns an untyped pointer. GPC does this only
with `--borland-pascal'. Otherwise it returns a typed pointer. `Addr'
never depends on the `--[no]-typed-address' option/compiler directive,
unlike the address operator. (It is recommended you never rely on
untyped pointer results, but use a type-cast if really necessary.)

Conforming to
-------------

`Addr' is a Borland Pascal extension.

Example
-------

     program AddrDemo;
     var
       Foo: ^Integer;
       Bar: Integer;
     begin
       Foo := Addr (Bar);  { Let `Foo' point to `Bar'. }
       Bar := 17;
       Foo^ := 42;  { Change the value of `Bar' to 42 }
       WriteLn (Bar)
     end.

See also
--------

*Note Operators::.


File: gpc.info,  Node: AlignOf,  Next: all,  Prev: Addr,  Up: Reference

AlignOf
=======

Synopsis
--------

     function AlignOf (var x): Integer;

Description
-----------

Returns the alignment of a type or variable in bytes.

Conforming to
-------------

`AlignOf' is a GNU Pascal extension.

Example
-------

     program AlignOfDemo;
     var
       a: Integer;
       b: array [1 .. 8] of Char;
     begin
       WriteLn (AlignOf (a));  { Alignment of `Integer', e.g. 4 bytes. }
       WriteLn (AlignOf (Integer));  { The same. }
       WriteLn (AlignOf (b));  { Alignment of `Char'; usually 1 byte. }
     end.

   Although the array is bigger than a single char, it is accessed char
by char, so there usually is no need to align it on a 4 byte boundary or
such. (This may be false on some platforms.)

See also
--------

*Note SizeOf::, *Note BitSizeOf::, *Note TypeOf::.


File: gpc.info,  Node: all,  Next: and,  Prev: AlignOf,  Up: Reference

all
===

(Under construction.)

Synopsis
--------

Description
-----------

`export' extension (`export foo = all').

Conforming to
-------------

`all' is a GNU Pascal extension.

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: and,  Next: and then,  Prev: all,  Up: Reference

and
===

Synopsis
--------

     operator and (operand1, operand2: Boolean) = Result: Boolean;
or
     operator and (operand1, operand2: INTEGER_TYPE) = Result: INTEGER_TYPE;
   or
     procedure and (var operand1: INTEGER_TYPE; operand2: INTEGER_TYPE);

Description
-----------

In GNU Pascal, `and' has three built-in meanings:

  1. Logical "and" between two `Boolean'-type expressions.  The result
     of the operation is of `Boolean' type.

     By default, `and' acts as a short-circuit operator in GPC: If the
     first operand is `False', the second operand is not evaluated
     because the result is already known to be `False'.  You can change
     this to complete evaluation using the `--no-short-circuit'
     command-line option or the `{$B+}' compiler directive.

  2. Bitwise "and" between two integer-type expressions.  The result is
     of the common integer type of both expressions.

  3. Use as a "procedure": `operand1' is "and"ed bitwise with
     `operand2'; the result is stored in `operand1'.


Conforming to
-------------

The logical `and' operator is defined in ISO 7185 Pascal.

   According to ISO, you cannot rely on `and' being a short-circuit
operator. On the other hand, GPC's default behaviour does _not_
contradict the ISO standard. (See *Note and_then::.)  However, since it
seems to be a de-facto standard among ISO Pascal compilers to evaluate
both operands of `and', GPC switches to `--no-short-circuit' mode if
one of the language dialect options selecting ISO Pascal, for instance
`--extended-pascal', is given. Use `--short-circuit' to override.

   Use of `and' as a bitwise operator for integers is a Borland Pascal
extension.

   Use of `and' as a "procedure" is a GNU Pascal extension.

Example
-------

     program AndDemo;
     var
       a, b, c: Integer;
     begin
       if (a = 0) and (b = 0) then  { logical `and' }
         c := 1
       else if (a and b) = 0 then  { bitwise `and' }
         c := 2
       else
         and (c, a)  { same as `c := c and a' }
     end.

   Note the difference between the logical `and' and the bitwise `and':
When `a' is 2 and `b' is 4, then `a and b' is 0.  *Beware:* `a and b =
0' has nothing to do with `(a = 0) and (b = 0)'!

   Since bitwise `and' has a higher priority than the `=' operator,
parentheses are needed in `if (a = 0) and (b = 0)' because otherwise `0
and b' would be calculated first, and the remainder would cause a parse
error.

See also
--------

*Note Keywords::, *Note and_then::, *Note and then::, *Note or::, *Note
xor::, *Note Operators::.


File: gpc.info,  Node: and then,  Next: and_then,  Prev: and,  Up: Reference

and then
========

Synopsis
--------

     { `and then' is built in. A user-defined operator cannot consist of
        two words. }
     operator and then (operand1, operand2: Boolean) = Result: Boolean;

Description
-----------

`and then' is an alias for the short-circuit logical operator
`and_then'.

Conforming to
-------------

While `and_then' is defined in ISO 10206 Extended Pascal, `and then' is
a GNU Pascal extension.

Example
-------

     program AndThenDemo;
     var
       p: ^Integer;
     begin
       New (p);
       ReadLn (p^);
       if (p <> nil) and then (p^ < 42) then  { This is safe. }
         WriteLn (p^, ' is less than 42')
     end.

See also
--------

*Note Keywords::, *Note and_then::, *Note and::, *Note or else::.


File: gpc.info,  Node: and_then,  Next: AnsiChar,  Prev: and then,  Up: Reference

and_then
========

Synopsis
--------

     operator and_then (operand1, operand2: Boolean) = Result: Boolean;

Description
-----------

The `and_then' short-circuit logical operator performs the same
operation as the logical operator `and'. But while the ISO standard
does not specify anything about the evaluation of the operands of `and'
- they may be evaluated in any order, or not at all - `and_then' has a
well-defined behaviour: It evaluates the first operand. If the result
is `False', `and_then' returns `False' without evaluating the second
operand. If it is `True', the second operand is evaluated and returned.

   Since the behaviour described above is the most efficient way to
implement `and', GPC by default treats `and' and `and_then' exactly the
same. If you want, for some reason, to have both operands of `and'
evaluated completely, you must assign both to temporary variables and
then use `and' - or `and_then', it does not matter.

Conforming to
-------------

`and_then' is an ISO 10206 Extended Pascal extension.

   Some people think that the ISO standard requires both operands of
`and' to be evaluated. This is false. What the ISO standard _does_ say
is that you cannot rely on a certain order of evaluation of the
operands of `and'; in particular things like the following program can
crash according to ISO Pascal, although they cannot crash when compiled
with GNU Pascal running in default mode.

     program AndBug;
     var
       p: ^Integer;
     begin
       New (p);
       ReadLn (p^);
       if (p <> nil) and (p^ < 42) then  { This is NOT safe! }
         WriteLn ('You''re lucky. But the test could have crashed ...')
     end.

Example
-------

     program And_ThenDemo;
     var
       p: ^Integer;
     begin
       New (p);
       ReadLn (p^);
       if (p <> nil) and_then (p^ < 42) then  { This is safe. }
         WriteLn (p^, ' is less than 42')
     end.

See also
--------

*Note Keywords::, *Note and then::, *Note and::, *Note or_else::.


File: gpc.info,  Node: AnsiChar,  Next: AnyFile,  Prev: and_then,  Up: Reference

AnsiChar
========

Synopsis
--------

     type
       AnsiChar = Char;

Description
-----------

`AnsiChar' is an 8 bit char type. Currently, it is the same as `Char',
but this might change in the future, once `wide chars' (16 bit chars)
will be introduced into GPC. Depending on the platform, `Char' might be
either `AnsiChar' or `WideChar' then.

Conforming to
-------------

`AnsiChar' is a Borland Delphi extension.

Example
-------

     program AnsiCharDemo;
     var
       A: AnsiChar;  { There is nothing special with `AnsiChar'. }
       B: Char;
     begin
       A := 'A';
       A := B
     end.

See also
--------

*Note PAnsiChar::, *Note Char::.


File: gpc.info,  Node: AnyFile,  Next: Append,  Prev: AnsiChar,  Up: Reference

AnyFile
=======

Synopsis
--------

     type
       AnyFile  { built-in type }

Description
-----------

`AnyFile' is a built-in type that can only be used for parameters and
pointer targets. Any kind of file variable (`Text', untyped and typed
`file') can be passed to such a parameter and their address assigned to
such a pointer. On the other side, only generic file operations are
possible with `AnyFile' parameters/pointer targets.

   This type is useful for implementing generic file handling routines.
Also some built-in file routines use this type for their parameters,
e.g. `IOSelectRead' (*note Run Time System::).

   `BlockRead' (*note BlockRead::) and `BlockWrite' (*note
BlockWrite::) treat `AnyFile' specially, in that they accept all
`AnyFile's as arguments (even if the actual file is a typed or `Text'
file) and always use a block size of 1 (even if the actual file is an
untyped file with different block size or a typed file of a type with
size not equal to one). This is the only way to reliably read/write a
certain amount of data from/to an `AnyFile'.

   `AnyFile' pointers cannot be allocated with `New' (because it would
be unspecified which kind of file to create).

Conforming to
-------------

`AnyFile' is a GNU Pascal extension.

Example
-------

     program AnyFileDemo;

     procedure Test (var f: AnyFile);
     var v: ^AnyFile;
     begin
       { Generic file operations are allowed for `AnyFile' }
       Rewrite (f);

       { `AnyFile' can also be accessed via pointers }
       v := @f;
       Close (v^)
     end;

     var
       t: Text;
       f: file;
       g: file of Integer;

     begin
       { Any kind of file variable can be passed as `AnyFile' }
       Test (t);
       Test (f);
       Test (g)
     end.

See also
--------

*Note Text::, *Note file::.


File: gpc.info,  Node: Append,  Next: ArcCos,  Prev: AnyFile,  Up: Reference

Append
======

Synopsis
--------

     procedure Append (var F: ANY_FILE; [FileName: String;]
                                         [BlockSize: Cardinal]);

Description
-----------

`Append' opens a file for writing. If the file does not exist, it is
created. If it does exist, the file pointer is positioned after the
last element.

   Like `Rewrite', `Reset' and `Extend' do, `Reset' accepts an optional
second parameter for the name of the file in the filesystem and a third
parameter for the block size of the file. The third parameter is
allowed only (and by default also required) for untyped files. For
details, see *Note Rewrite::.

Conforming to
-------------

`Append', including the `BlockSize' parameter, is a Borland Pascal
extension. ISO 10206 Extended Pascal has *Note Extend:: instead.  The
`FileName' parameter is a GNU Pascal extension.

Example
-------

     program AppendDemo;
     var
       Sample: Text;
     begin
       Assign (Sample, 'sample.txt');
       Rewrite (Sample);
       WriteLn (Sample, 'Hello, World!');  { `sample.txt' now has one line }
       Close (Sample);

       { ... }

       Append (Sample);
       WriteLn (Sample, 'Hello again!');  { `sample.txt' now has two lines }
       Close (Sample)
     end.

See also
--------

*Note Assign::, *Note Reset::, *Note Rewrite::, *Note Update::, *Note
Extend::.


File: gpc.info,  Node: ArcCos,  Next: ArcSin,  Prev: Append,  Up: Reference

ArcCos
======

Synopsis
--------

     function ArcCos (x: Real): Real;
or
     function ArcCos (z: Complex): Complex;

Description
-----------

`ArcCos' returns the (principal value of the) arcus cosine of the
argument. The result is in the range `0 < ArcCos (x) < Pi' for real
arguments.

Conforming to
-------------

`ArcCos' is a GNU Pascal extension.

Example
-------

     program ArcCosDemo;
     begin
       { yields 3.14159 as ArcCos (0.5) = Pi / 3 }
       WriteLn (3 * ArcCos (0.5) : 0 : 5)
     end.

See also
--------

*Note ArcSin::, *Note ArcTan::, *Note Sin::, *Note Cos::, *Note Ln::,
*Note Arg::.


File: gpc.info,  Node: ArcSin,  Next: ArcTan,  Prev: ArcCos,  Up: Reference

ArcSin
======

Synopsis
--------

     function ArcSin (x: Real): Real;
or
     function ArcSin (z: Complex): Complex;

Description
-----------

`ArcSin' returns the (principal value of the) arcus sine of the
argument. The result is in the range `-Pi / 2 < ArcSin (x) < Pi / 2'
for real arguments.

Conforming to
-------------

`ArcSin' is a GNU Pascal extension.

Example
-------

     program ArcSinDemo;
     begin
       { yields 3.14159 as ArcSin (0.5) = Pi / 6 }
       WriteLn (6 * ArcSin (0.5) : 0 : 5)
     end.

See also
--------

*Note ArcCos::, *Note ArcTan::, *Note Sin::, *Note Cos::, *Note Ln::,
*Note Arg::.


File: gpc.info,  Node: ArcTan,  Next: Arg,  Prev: ArcSin,  Up: Reference

ArcTan
======

Synopsis
--------

     function ArcTan (x: Real): Real;
or
     function ArcTan (z: Complex): Complex;

Description
-----------

`ArcTan' returns the (principal value of the) arcus tangent of the
argument. The result is in the range `-Pi / 2 < ArcTan (x) < Pi / 2'
for real arguments.

Conforming to
-------------

`ArcTan' is defined in ISO 7185 Pascal; its application to complex
values is defined in ISO 10206 Extended Pascal.

Example
-------

     program ArcTanDemo;
     begin
       { yields 3.14159 as ArcTan (1) = Pi / 4 }
       WriteLn (4 * ArcTan (1) : 0 : 5)
     end.

See also
--------

*Note ArcSin::, *Note ArcCos::, *Note Sin::, *Note Cos::, *Note Ln::,
*Note Arg::.


File: gpc.info,  Node: Arg,  Next: array,  Prev: ArcTan,  Up: Reference

Arg
===

Synopsis
--------

     function Arg (z: Complex): Real;

Description
-----------

`Arg' returns the complex "argument", i.e. the angle (in radian) in the
complex plane with respect to the real axis, of its parameter `z'. The
result is in the range of `-Pi < Arg (z) <= Pi'.

Conforming to
-------------

`Arg' is an ISO 10206 Extended Pascal extension.

Example
-------

     program ArgDemo;
     var
       z: Complex;
     begin
       z := Cmplx (1, 1);  { 1 + i }
       WriteLn (Arg (z) : 0 : 5)  { yields 0.78540, i.e. Pi / 4 }
     end.

See also
--------

*Note ArcTan::, *Note Ln::, *Note Polar::.


File: gpc.info,  Node: array,  Next: as,  Prev: Arg,  Up: Reference

array
=====

Synopsis
--------

In type definitions:
     array [INDEX_TYPE] of ELEMENT_TYPE
   or
     array [INDEX_TYPE, ..., INDEX_TYPE] of ELEMENT_TYPE

   In parameter list declarations:
     array of ELEMENT_TYPE

Description
-----------

The reserved word `array' is used to define an array type.

   @@conformant/open arrays

Conforming to
-------------

Array types are defined in ISO 7185 Pascal.

Example
-------

     program ArrayDemo;
     type
       IntArray = array [1 .. 20] of Integer;
       WeekDayChars = array [(Mon, Tue, Wed, Thu, Fri, Sat, Sun)] of Char;
       Foo = array [0 .. 9, 'a' .. 'z', (Baz, Glork1, Fred)] of Real;
       TwoDimIntArray = array [1 .. 10] of IntArray;
       { is equivalent to: }
       TwoDimIntArray2 = array [1 .. 10, 1 .. 20] of Integer;

     procedure PrintChars (F: array of Char);
     var
       i: Integer;
     begin
       for i := Low (F) to High (F) do
         WriteLn (F[i])
     end;

     var
       Waldo: WeekDayChars;

     begin
       Waldo := 'HiWorld';
       PrintChars (Waldo)
     end.

See also
--------

*Note Keywords::, *Note Array Types::, *Note High::, *Note Low::


File: gpc.info,  Node: as,  Next: asm,  Prev: array,  Up: Reference

as
==

(Under construction.)

Synopsis
--------

Description
-----------

Object type membership test and conversion.

Conforming to
-------------

`as' is an Object Pascal and a Borland Delphi extension.

Example
-------

See also
--------

*Note Keywords::, *Note is::, *Note TypeOf::, *Note OOP::.


File: gpc.info,  Node: asm,  Next: asmname,  Prev: as,  Up: Reference

asm
===

(Under construction.)

Synopsis
--------

Description
-----------

See `http://www.gnu-pascal.de/contrib/misc/gpcasm.zip'.

Conforming to
-------------

`asm', as implemented in GPC, is a GNU Pascal extension. It is mostly
compatible to GCC's `asm', but not compatible to that of Borland Pascal.

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: asmname,  Next: Assert,  Prev: asm,  Up: Reference

asmname
=======

Synopsis
--------

Description
-----------

*Deprecated*! Use `external name' now.

Conforming to
-------------

Example
-------

See also
--------

*Note Keywords::, *Note external::, *Note name::, *Note Importing
Libraries from Other Languages::.


File: gpc.info,  Node: Assert,  Next: Assign,  Prev: asmname,  Up: Reference

Assert
======

Synopsis
--------

     procedure Assert (Condition: Boolean);
or
     procedure Assert (Condition: Boolean; const Message: String);

Description
-----------

`Assert' checks the given `Condition' at run-time. If it is true, it
does nothing. If it is false, it raises a runtime error, using the
second argument for the message if given.

   However, if the switch `--no-assertions' is given (*note GPC Command
Line Options::), `Assert' is deactivated. It still evaluates the
condition if it has side effects, but never raises a runtime error.

Conforming to
-------------

`Assert' is a Borland Delphi extension.

Example
-------

See also
--------

*Note CompilerAssert::.


File: gpc.info,  Node: Assign,  Next: Assigned,  Prev: Assert,  Up: Reference

Assign
======

(Under contruction.)

Synopsis
--------

     procedure Assign (var F: ANY_FILE; FileName: String);

Description
-----------

Conforming to
-------------

`Assign' is a Borland Pascal extension.

Example
-------

See also
--------

*Note Reset::, *Note Rewrite::, *Note Update::, *Note Extend::, *Note
Append::.


File: gpc.info,  Node: Assigned,  Next: attribute,  Prev: Assign,  Up: Reference

Assigned
========

(Under construction.)

Synopsis
--------

     function Assigned (p: Pointer): Boolean;
or
     function Assigned (p: PROCEDURAL_TYPE): Boolean;

Description
-----------

The `Assigned' function returns `True' if the pointer parameter or the
address of the procedural parameter is not `nil'; it returns `False' if
it is `nil'.

Conforming to
-------------

`Assigned' is a Borland Pascal extension.

Example
-------

     program AssignedDemo;
     type
       PInt = ^Integer;

     procedure TellIfOdd (p: PInt);
     begin
       if Assigned (p) and then Odd (p^) then
         WriteLn ('The pointer p points to an odd value.')
     end;

     var
       foo: Integer;
     begin
       TellIfOdd (nil);
       foo := 1;
       TellIfOdd (@foo);
       foo := 2;
       TellIfOdd (@foo)
     end.

See also
--------

*Note Null::, *Note nil::, *Note Pointer::.


File: gpc.info,  Node: attribute,  Next: begin,  Prev: Assigned,  Up: Reference

attribute
=========

(Under construction.)

Synopsis
--------

     DECLARATION attribute (NAME);

   or

     DECLARATION attribute (NAME = PARAMETER);

   or

     DECLARATION attribute (NAME (PARAMETER, PARAMETER ...));

Description
-----------

Several attributes can be given in one `attribute' directive, separated
with `,', or in several `attribute' directives.

   Besides the attributes that GCC supports (*note Attribute Syntax:
(gcc)Attribute Syntax.), GPC allows the following attributes for
variables:

   * static

   * register

   * volatile

   * const

   * external

   * name (with a string constant parameter)

   For routines it allows the following additional attributes:

   * ignorable

   * inline

   * iocritical

   * name (with a string constant parameter)

   For types it allows the following additional attributes:

   * iocritical (for procedural [pointer] types)

   * size (with an integer constant parameter)

   `Size' can be applied to integer and Boolean types to produce types
with a specified size in bits; for example

     type
       Card16 = Cardinal attribute (Size = 16);

defines an unsigned integer type with 16 bits.

   Variable and routine attributes are preceded by a `;', type
attributes are not. So, e.g., in the following example, the `Size'
attribute applies to the type, and the `static' attribute to the
variable.
     var a: Integer attribute (Size = 64); attribute (static);

Conforming to
-------------

`attribute' is a GNU Pascal extension.

Example
-------

     program AttributeDemo;

     { Demo for `iocritical' attribute. }

     { Program will abort with a runtime error! }

     {$I-}
     procedure p; attribute (iocritical);
     var t: Text;
     begin
       Reset (t)  { Will not cause a runtime error here because I/O
                    checking is off, but leave InOutRes set. }
     end;
     {$I+}

     begin

       p;
       { Since `p' was declared `iocritical', and I/O checking is now on,
         InOutRes is checked immediately after the call to p, and a
         runtime error raised. }

       { So this statement is never reached. }
       InOutRes := 0;

       { Neither this one, which would be reached without the
         `iocritical' attribute. }
       WriteLn ('never gets here')

     end.

See also
--------

*Note Keywords::, *Note external::.


File: gpc.info,  Node: begin,  Next: Bind,  Prev: attribute,  Up: Reference

begin
=====

Synopsis
--------

     begin
       STATEMENT;
       STATEMENT;
       ...
       STATEMENT
     end;

Description
-----------

The reserved word `begin' opens a `begin ... end' statement which joins
several STATEMENTS to one compound statement.

Conforming to
-------------

`begin' is defined in ISO 7185 Pascal and supported by all known Pascal
variants.

Example
-------

     program BeginDemo;
     begin
       if True then
         WriteLn ('single statement');
       if True then
         begin                     { clamp statement1 ... }
           WriteLn ('statement1');
           WriteLn ('statement2')
         end                       { ... to statement2 }
     end.

See also
--------

*Note Keywords::, *Note begin end Compound Statement::, *Note end::


File: gpc.info,  Node: Bind,  Next: bindable,  Prev: begin,  Up: Reference

Bind
====

(Under construction.)

Synopsis
--------

     procedure Bind (var F: ANY_FILE; B: BindingType);

Description
-----------

Conforming to
-------------

`Bind' is an ISO 10206 Extended Pascal extension.

Example
-------

See also
--------

*Note Unbind::, *Note Binding::, *Note BindingType::, *Note bindable::.


File: gpc.info,  Node: bindable,  Next: Binding,  Prev: Bind,  Up: Reference

bindable
========

(Under construction.)

Synopsis
--------

Description
-----------

External bindability of files.

Conforming to
-------------

`bindable' is an ISO 10206 Extended Pascal extension.

Example
-------

See also
--------

*Note Keywords::, *Note Bind::, *Note Unbind::, *Note Binding::, *Note
BindingType::.


File: gpc.info,  Node: Binding,  Next: BindingType,  Prev: bindable,  Up: Reference

Binding
=======

(Under construction.)

Synopsis
--------

     function Binding (F: ANY_FILE): BindingType;

Description
-----------

Conforming to
-------------

`Binding' is an ISO 10206 Extended Pascal extension.

Example
-------

See also
--------

*Note Bind::, *Note Unbind::, *Note BindingType::, *Note bindable::.


File: gpc.info,  Node: BindingType,  Next: BitSizeOf,  Prev: Binding,  Up: Reference

BindingType
===========

(Under construction.)

Synopsis
--------

     type
       UnixTimeType = LongInt;
       BindingType = packed record
         Bound,
         Force,                     { Can be set to allow binding to
                                      directories or inaccessible files }
         Extensions_Valid,
         Readable,
         Writable,
         Executable,
         Existing,                  { Binding points to an existing file }
         Directory,                 { Binding points to an existing
                                      directory; `Existing' is False
                                      in this case }
         Special,                   { Binding points to an existing
                                      special file (device, pipe, socket,
                                      etc.); `Existing' is False in
                                      this case }
         SymLink: Boolean;          { Binding points to a symbolic link }
         Size: FileSizeType;        { Size of file, or -1 if unknown }
         AccessTime,                { Time of last access }
         ModificationTime,          { Time of last modification }
         ChangeTime: UnixTimeType;  { Time of last change }
         User,                      { User ID of owner }
         Group,                     { Group ID of owner }
         Mode,                      { Access permissions, cf. ChMod }
         Device,                    { Device the file is on }
         INode,                     { Unix INode number }
         Links: Integer;            { Number of hard links }
         TextBinary: Boolean;       { Open a Text file in binary mode }
         Handle: Integer;           { Can be set to bind a Pascal file to
                                      a given file handle }
         CloseFlag: Boolean;        { If Handle is used, tell whether to
                                      close it when file is closed }
         Name: String (BindingNameLength)
       end;

   `BindingNameLength' is an implementation-defined constant.

Description
-----------

Conforming to
-------------

`BindingType' is an ISO 10206 Extended Pascal extension. The fields
`Bound' and `Name' are required by Extended Pascal, the other ones are
GNU Pascal extensions.

Example
-------

See also
--------

*Note Bind::, *Note Unbind::, *Note Binding::, *Note bindable::.


File: gpc.info,  Node: BitSizeOf,  Next: BlockRead,  Prev: BindingType,  Up: Reference

BitSizeOf
=========

Synopsis
--------

     function BitSizeOf (var x): SizeType;

Description
-----------

Returns the size of a type or variable in bits.

Conforming to
-------------

`BitSizeOf' is a GNU Pascal extension.

Example
-------

     program BitSizeOfDemo;
     type
       Int12 = Integer attribute (Size = 12);
     var
       a: Integer;
       b: array [1 .. 8] of Char;
       c: Int12;
       d: packed record
            x: Int12;
            y: 0 .. 3
          end;
     begin
       WriteLn (BitSizeOf (a));    { Size of an `Integer'; usually 32 bits. }
       WriteLn (BitSizeOf (Integer));  { The same. }
       WriteLn (BitSizeOf (b));    { Size of eight `Char's; usually 64 bits. }
       WriteLn (BitSizeOf (c));    { e.g. 16 bits (smallest addressable
                                      space holding a 12 bit integer). }
       WriteLn (BitSizeOf (d));    { e.g. 16 }
       WriteLn (BitSizeOf (d.x));  { 12 }
       WriteLn (BitSizeOf (d.y))   { 2 }
     end.

See also
--------

*Note SizeOf::, *Note AlignOf::, *Note TypeOf::.


File: gpc.info,  Node: BlockRead,  Next: BlockWrite,  Prev: BitSizeOf,  Up: Reference

BlockRead
=========

(Under construction.)

Synopsis
--------

     procedure BlockRead (var F: File; var Buffer; Blocks: Integer);
or
     procedure BlockRead (var F: File; var Buffer; Blocks: Integer;
                          var BlocksRead: Integer);

Description
-----------

Conforming to
-------------

`BlockRead' is a UCSD Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: BlockWrite,  Next: Boolean,  Prev: BlockRead,  Up: Reference

BlockWrite
==========

(Under construction.)

Synopsis
--------

     procedure BlockWrite (var F: File; const Buffer; Blocks: Integer);
or
     procedure BlockWrite (var F: File; const Buffer; Blocks: Integer;
                           var BlocksWritten: Integer);

Description
-----------

Conforming to
-------------

`BlockWrite' is a UCSD Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: Boolean,  Next: Break,  Prev: BlockWrite,  Up: Reference

Boolean
=======

Synopsis
--------

     type
       Boolean = (False, True); { built-in type }

Description
-----------

The intrinsic `Boolean' represents boolean values, i.e. it can only
assume the two values `True' and `False' (which are predefined
constants).

Conforming to
-------------

`Boolean' is defined in ISO 7185 Pascal and supported by all known
Pascal variants.

Example
-------

     program BooleanDemo;
     var
       a: Boolean;
     begin
       a := True;
       WriteLn (a)
     end.

See also
--------

*Note Boolean (Intrinsic)::, *Note True::, *Note False::, *Note
CBoolean::, *Note ByteBool::, *Note ShortBool::, *Note MedBool::, *Note
WordBool::, *Note LongBool::, *Note LongestBool::.


File: gpc.info,  Node: Break,  Next: Byte,  Prev: Boolean,  Up: Reference

Break
=====

Synopsis
--------

     Break  { simple statement }

Description
-----------

With `Break' you can exit the body of the current loop instantly. It
can only be used within a `while', `repeat' or a `for' loop.

Conforming to
-------------

`Break' is a Borland Pascal extension. Mac Pascal has `Leave' instead.

Example
-------

     program BreakDemo;
     var
       Foo: Integer;
     begin
       while True do
         begin
           repeat
             WriteLn ('Enter a number less than 100:');
             ReadLn (Foo);
             if Foo < 100 then
               Break;  { Exits `repeat' loop }
             WriteLn (Foo, ' is not exactly less than 100! Try again ...')
           until False;
           if Foo > 50 then
             Break;  { Exits `while' loop }
           WriteLn ('The number entered was not greater than 50.')
         end
     end.

See also
--------

*Note Loop Control Statements::, *Note Continue::, *Note Cycle::, *Note
Exit::, *Note Halt::, *Note Leave::, *Note Return::, *Note goto::.


File: gpc.info,  Node: Byte,  Next: ByteBool,  Prev: Break,  Up: Reference

Byte
====

Synopsis
--------

     type
       Byte  { built-in type }

Description
-----------

`Byte' is an unsigned integer type which is one "unit" wide.  On most
platforms one unit has 8 bits, therefore the type is named "byte" and
usually has a range of `0 .. 255'. (It is the same as *Note ByteCard::.)

   `Byte' in GNU Pascal is compatible to `unsigned char' in GNU C.

   There are lots of other integer types in GPC, see *Note Integer
Types::.

Conforming to
-------------

`Byte' is a Borland Pascal extension. (For something equivalent in ISO
Pascal, see *Note Subrange Types::.)

Example
-------

     program ByteDemo;
     var
       a: Byte;
     begin
       a := 42;
       WriteLn (a)
     end.

See also
--------

*Note Integer Types::, *Note Subrange Types::.


File: gpc.info,  Node: ByteBool,  Next: ByteCard,  Prev: Byte,  Up: Reference

ByteBool
========

Synopsis
--------

     type
       ByteBool = Boolean attribute (Size = BitSizeOf (Byte));

Description
-----------

The intrinsic `ByteBool' represents boolean values, but occupies the
same memory space as a `Byte'.  It is used when you need to define a
parameter or record that conforms to some external library or system
specification.

Conforming to
-------------

`ByteBool' is a Borland Pascal extension.

Example
-------

     program ByteBoolDemo;
     var
       a: ByteBool;
     begin
       Byte (a) := 1;
       if a then WriteLn ('Ord (True) = 1')
     end.

See also
--------

*Note Boolean (Intrinsic)::, *Note Boolean::, *Note True::, *Note
False::, *Note CBoolean::, *Note ShortBool::, *Note MedBool::, *Note
WordBool::, *Note LongBool::, *Note LongestBool::.


File: gpc.info,  Node: ByteCard,  Next: ByteInt,  Prev: ByteBool,  Up: Reference

ByteCard
========

Synopsis
--------

     type
       ByteCard = Cardinal attribute (Size = BitSizeOf (Byte));

Description
-----------

`ByteCard' is an unsigned integer type which is one "unit" wide.  On
most platforms one unit has 8 bits, therefore the type is prefixed
"byte-" and usually has a range of `0 .. 255'.

   `ByteCard' in GNU Pascal is compatible to `unsigned char' in GNU C.

   There are lots of other integer types in GPC, see *Note Integer
Types::.

Conforming to
-------------

`ByteCard' is a GNU Pascal extension.

Example
-------

     program ByteCardDemo;
     var
       a: ByteCard;
     begin
       a := 42;
       WriteLn (a)
     end.

See also
--------

*Note Integer Types::, *Note Subrange Types::.


File: gpc.info,  Node: ByteInt,  Next: c,  Prev: ByteCard,  Up: Reference

ByteInt
=======

Synopsis
--------

     type
       ByteInt = Integer attribute (Size = BitSizeOf (Byte));

Description
-----------

`ByteInt' is a signed integer type which is one "unit" wide.  On most
platforms one unit has 8 bits, therefore the type is prefixed "byte-"
and usually has a range of `-128 .. 127'.

   `ByteInt' in GNU Pascal is compatible to `signed char' in GNU C.

   There are lots of other integer types in GPC, see *Note Integer
Types::.

Conforming to
-------------

`ByteInt' is a GNU Pascal extension.

   `ByteInt' in GNU Pascal corresponds to *Note ShortInt:: in Borland
Pascal.

Example
-------

     program ByteIntDemo;
     var
       a: ByteInt;
     begin
       a := 42;
       WriteLn (a)
     end.

See also
--------

*Note Integer Types::, *Note Subrange Types::.


File: gpc.info,  Node: c,  Next: Card,  Prev: ByteInt,  Up: Reference

c
=

Synopsis
--------

Description
-----------

*Deprecated*! Use `external' now.

Conforming to
-------------

Example
-------

See also
--------

*Note Keywords::, *Note Importing Libraries from Other Languages::,
*Note external::.


File: gpc.info,  Node: Card,  Next: Cardinal,  Prev: c,  Up: Reference

Card
====

Synopsis
--------

     function Card (S: ANY_SET): Integer;

Description
-----------

The function `Card (S)' returns the number of elements in the set `S'.

Conforming to
-------------

`Card' is an ISO 10206 Extended Pascal extension.

Example
-------

     program CardDemo;
     var
       Foo: set of 1 .. 100;
     begin
       Foo := [1, 2, 3, 5, 1, 1, 1, 2, 2, 2, 3, 3, 5, 5];  { four elements }
       WriteLn ('foo consists of ', Card (Foo), ' elements')
     end.

See also
--------

*Note set::


File: gpc.info,  Node: Cardinal,  Next: case,  Prev: Card,  Up: Reference

Cardinal
========

Synopsis
--------

     type
       Cardinal  { built-in type }

Description
-----------

`Cardinal' is the "natural" unsigned integer type in GNU Pascal. On
some platforms it is 32 bits wide and thus has a range of `0 ..
4294967295'. Use it whenever you need a general-purpose unsigned
integer type and don't need to care about compatibility to other Pascal
dialects.

   There are lots of other integer types in GPC, see *Note Integer
Types::.

Conforming to
-------------

`Cardinal' is not defined in ISO Pascal, but several Pascal compilers
support it as an extension. In Borland Delphi, for instance, it is an
unsigned 16-bit in version 1.0, an unsigned 31-bit integer from version
2.0 on, and an unsigned 32-bit integer from version 4.0 on.

Example
-------

     program CardinalDemo;
     var
       a: Cardinal;
     begin
       a := 42;
       WriteLn (a)
     end.

See also
--------

*Note Integer Types::, *Note Subrange Types::.


File: gpc.info,  Node: case,  Next: CBoolean,  Prev: Cardinal,  Up: Reference

case
====

Synopsis
--------

     case EXPRESSION of
       SELECTOR: STATEMENT;
       ...
       SELECTOR: STATEMENT;
     end;
or, with alternative statement sequence:
     case EXPRESSION of
       SELECTOR: STATEMENT;
       ...
       SELECTOR: STATEMENT;
     otherwise  { ``else'' instead of ``otherwise'' is allowed }
       STATEMENT;
       ...
       STATEMENT;
     end;
   or, as part of the invariant `record' type definition:
     foo = record
       FIELD_DECLARATIONS
     case bar: VARIANT_TYPE of
       SELECTOR: (FIELD_DECLARATIONS);
       SELECTOR: (FIELD_DECLARATIONS);
       ...
     end;
   or, without a variant selector field,
     foo = record
       FIELD_DECLARATIONS
     case VARIANT_TYPE of
       SELECTOR: (FIELD_DECLARATIONS);
       SELECTOR: (FIELD_DECLARATIONS);
       ...
     end;

Description
-----------

`case' opens a case statement. For further description see *Note case
Statement::.

   For `case' in a variant record type definition, see *Note Record
Types::.

Conforming to
-------------

The `case' statement is defined in ISO 7185 Pascal and supported by all
known Pascal variants.

   According to ISO 7185 Pascal, the selector type must be a named
type. UCSD Pascal and Borland Pascal allow any ordinal type here.

   The alternative statement execution with `otherwise' it is an
Extended Pascal extension; with `else' it is a Borland Pascal
extension. In GNU Pascal, both are allowed.

Example
-------

     program CaseDemo;
     var
       Foo: String (10);
       Bar: Integer;
     begin
       WriteLn ('Enter up to ten arbitrary characters:');
       ReadLn (Foo);
       for Bar := 1 to Length (Foo) do
         begin
           Write (Foo[Bar], ' is ');
           case Foo[Bar] of
             'A' .. 'Z', 'a' .. 'z':
               WriteLn ('an English letter');
             '0' .. '9':
               WriteLn ('a number');
           otherwise
             WriteLn ('an unrecognized character')
           end
         end
     end.

See also
--------

*Note Keywords::, *Note if Statement::, *Note Record Types::, *Note
else::, *Note otherwise::


File: gpc.info,  Node: CBoolean,  Next: CCardinal,  Prev: case,  Up: Reference

CBoolean
========

(Under construction.)

Synopsis
--------

     type
       CBoolean  { built-in type }

Description
-----------

`CBoolean' is a Boolean type. In GNU Pascal it is compatible to `_Bool'
in GNU C (which is defined as `bool' in `stdbool.h'). This
compatibility is the reason why `CBoolean' exists.

Conforming to
-------------

`CBoolean' is a GNU Pascal extension.

Example
-------

     program CBooleanDemo;
     var
       a: CBoolean;
     begin
       a := True;
       if Ord (a) = 1 then WriteLn ('Ord (True) = 1')
     end.

See also
--------

*Note Boolean (Intrinsic)::, *Note Integer Types::, *Note Boolean::,
*Note True::, *Note False::, *Note ByteBool::, *Note ShortBool::, *Note
MedBool::, *Note WordBool::, *Note LongBool::, *Note LongestBool::.


File: gpc.info,  Node: CCardinal,  Next: Char,  Prev: CBoolean,  Up: Reference

CCardinal
=========

Synopsis
--------

     type
       CCardinal  { built-in type }

Description
-----------

`CCardinal' is an unsigned integer type. On some platforms it is 32
bits wide and thus has a range of `0 .. 4294967295'.

   `CCardinal' in GNU Pascal is compatible to `unsigned int' in GNU C.

   There are lots of other integer types in GPC, see *Note Integer
Types::.

Conforming to
-------------

`CCardinal' is a GNU Pascal extension.

Example
-------

     program CCardinalDemo;
     var
       a: CCardinal;
     begin
       a := 42;
       WriteLn (a)
     end.

See also
--------

*Note Integer Types::, *Note Subrange Types::.


File: gpc.info,  Node: Char,  Next: ChDir,  Prev: CCardinal,  Up: Reference

Char
====

Synopsis
--------

     type
       Char  { built-in type }

Description
-----------

The built-in type `Char' holds elements of the operating system's
character set (usually ASCII). The `Char' type is a special case of
ordinal type. Conversion between character types and ordinal types is
possible with the built-in functions `Ord' and `Chr'.

Conforming to
-------------

`Char' is defined in ISO 7185 Pascal and supported by all known Pascal
variants.

Example
-------

     program CharDemo;
     var
       a: Char;
     begin
       a := 'x';
       WriteLn (a)
     end.

See also
--------

*Note Character Types::, *Note Ordinal Types::, *Note Type Casts::,
*Note Ord::, *Note Chr::.


File: gpc.info,  Node: ChDir,  Next: Chr,  Prev: Char,  Up: Reference

ChDir
=====

Synopsis
--------

     procedure ChDir (Directory: String);

Description
-----------

`ChDir' changes the current directory to DIRECTORY, if its argument is
a valid parameter to the related operating system's function.
Otherwise, a runtime error is caused.

Conforming to
-------------

`ChDir' is a Borland Pascal extension.

Example
-------

     program ChDirDemo;
     var
       Foo: String (127);
     begin
       WriteLn ('Enter directory name to change to:');
       ReadLn (Foo);
       {$I-}  { Don't abort the program on error }
       ChDir (Foo);
       if IOResult <> 0 then
         WriteLn ('Cannot change to directory `', Foo, '''.')
       else
         WriteLn ('Okay.')
     end.

See also
--------

*Note MkDir::, *Note RmDir::


File: gpc.info,  Node: Chr,  Next: CInteger,  Prev: ChDir,  Up: Reference

Chr
===

Synopsis
--------

     function Chr (AsciiCode: Integer): Char;

Description
-----------

`Chr' returns a character whose ASCII code corresponds to the value
given by `AsciiCode'.

Conforming to
-------------

`Chr' is defined in ISO 7185 Pascal and supported by all known Pascal
variants.

Example
-------

     program ChrDemo;
     var
       x: Integer;
     begin
       for x := 32 to 122 do
         Write (Chr (x))
     end.

See also
--------

*Note Character Types::, *Note Ord::, *Note Char::


File: gpc.info,  Node: CInteger,  Next: c_language,  Prev: Chr,  Up: Reference

CInteger
========

Synopsis
--------

     type
       CInteger  { built-in type }

Description
-----------

`CInteger' is a signed integer type. On some platforms it is 32 bits
wide and thus has a range of `-2147483648 .. 2147483647'.

   `CInteger' in GNU Pascal is compatible to `int' in GNU C.

   There are lots of other integer types in GPC, see *Note Integer
Types::.

Conforming to
-------------

`CInteger' is a GNU Pascal extension.

Example
-------

     program CIntegerDemo;
     var
       a: CInteger;
     begin
       a := 42;
       WriteLn (a)
     end.

See also
--------

*Note Integer Types::, *Note Subrange Types::.


File: gpc.info,  Node: c_language,  Next: class,  Prev: CInteger,  Up: Reference

c_language
==========

Synopsis
--------

Description
-----------

*Deprecated*! Use `external' now.

Conforming to
-------------

Example
-------

See also
--------

*Note Keywords::, *Note Importing Libraries from Other Languages::,
*Note external::.


File: gpc.info,  Node: class,  Next: Close,  Prev: c_language,  Up: Reference

class
=====

Not yet implemented.

Synopsis
--------

Description
-----------

OOE/Delphi style object class.

Conforming to
-------------

`class' is an Object Pascal and a Borland Delphi extension.

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: Close,  Next: Cmplx,  Prev: class,  Up: Reference

Close
=====

(Under construction.)

Synopsis
--------

     procedure Close (var F: ANY_FILE);

Description
-----------

Conforming to
-------------

`Close' is a UCSD Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: Cmplx,  Next: Comp,  Prev: Close,  Up: Reference

Cmplx
=====

Synopsis
--------

     function Cmplx (RealPart, ImaginaryPart: Real): Complex;

Description
-----------

`Cmplx' makes a complex number from `RealPart' and `ImaginaryPart'.

Conforming to
-------------

`Cmplx' is an ISO 10206 Extended Pascal extension.

Example
-------

     program CmplxDemo;
     var
       z: Complex;
       x, y: Real;
     begin
       z := Cmplx (x, y)  { z := x + iy }
     end.

See also
--------

*Note Re::, *Note Im::, *Note Polar::, *Note Arg::


File: gpc.info,  Node: Comp,  Next: CompilerAssert,  Prev: Cmplx,  Up: Reference

Comp
====

Synopsis
--------

     type
       Comp = LongInt;

Description
-----------

`Comp' is a signed integer type which is longer than `Integer'. On some
platforms it is 64 bits wide and thus has a range of
`-9223372036854775808 .. 9223372036854775807'.

   There are lots of other integer types in GPC, see *Note Integer
Types::.

Conforming to
-------------

`Comp' is a Borland Pascal extension.

   In some contexts, Borland Pascal treats `Comp' as a "real" type -
this behaviour is not supported by GPC.

Example
-------

     program CompDemo;
     var
       a: Comp;
     begin
       a := 42;
       WriteLn (a)
     end.

See also
--------

*Note Integer Types::, *Note Subrange Types::.


File: gpc.info,  Node: CompilerAssert,  Next: Complex,  Prev: Comp,  Up: Reference

CompilerAssert
==============

Synopsis
--------

     procedure CompilerAssert (Condition: Boolean);
or
     function CompilerAssert (Condition: Boolean): Boolean;
   or
     function CompilerAssert (Condition: Boolean;
                ResultValue: ANY_TYPE): type of ResultValue;

Description
-----------

`CompilerAssert' checks the given `Condition' at compile-time. If it is
a compile-time constant of Boolean type with the value `True', it
returns `ResultValue', or if called with only one argument, it returns
`True' or nothing if used as a procedure.

   If `Condition' cannot be evaluated at compile-time or does not have
the value `True', it causes a compile-time error.

   So it can be used to make sure that certain assumptions hold before
relying on them.

   `CompilerAssert' does not depend on the `--[no-]assertions' options.
It does not generate any run-time code.

Conforming to
-------------

`CompilerAssert' is a GNU Pascal extension.

Example
-------

     program CompilerAssertDemo;

     var
       a: LongInt;

     const
       { Make sure that the highest value a can hold is larger than
         MaxInt, and set b to that value. }
       b = CompilerAssert (High (a) > MaxInt, High (a));

       { Do a similar check for the minimum value, setting c to True
         (which can be ignored). }
       c = CompilerAssert (Low (a) < Low (Integer));

     begin
       { Procedure-like use of CompilerAssert in the statement part. }
       CompilerAssert (MaxInt >= 100000);

       WriteLn (b, ' ', c)
     end.

See also
--------

*Note Assert::.


File: gpc.info,  Node: Complex,  Next: Concat,  Prev: CompilerAssert,  Up: Reference

Complex
=======

(Under construction.)

Synopsis
--------

     type
       Internal_Complex = record  { not visible }
         RealPart, ImaginaryPart: Real
       end;
       Complex = restricted Internal_Complex;

Description
-----------

Conforming to
-------------

`Complex' is an ISO 10206 Extended Pascal extension.

Example
-------

     program ComplexDemo;
     var
       a: Complex;
     begin
       a := Cmplx (42, 3);
       WriteLn (Re (a), ' + ', Im (a), ' i')
     end.

See also
--------


File: gpc.info,  Node: Concat,  Next: Conjugate,  Prev: Complex,  Up: Reference

Concat
======

(Under construction.)

Synopsis
--------

     function Concat (S1, S2: String): String;
or
     function Concat (S1, S2, S3: String): String;
   or
     ...

Description
-----------

Conforming to
-------------

`Concat' is a UCSD Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: Conjugate,  Next: const,  Prev: Concat,  Up: Reference

Conjugate
=========

Synopsis
--------

     function Conjugate (z: Complex): Complex;

Description
-----------

`Conjugate' computes the complex conjugate of the complex number `z'

Conforming to
-------------

`Conjugate' is a GNU Pascal extension.

Example
-------

     program ConjugateDemo;
     var
       z: Complex;
     begin
       z := Cmplx (2, 3);  { z is 2 + i * 3 }
       WriteLn ('z = ', Re (z) : 0 : 5, ' + i * ', Im (z) : 0 : 5);
       z := Conjugate (z);  { z conjugate is 2 - i * 3 }
       WriteLn ('z conjugate = ', Re (z) : 0 : 5,' + i * ', Im (z) : 0 : 5)
     end.

See also
--------

*Note Cmplx::, *Note Re::, *Note Im::, *Note Abs::


File: gpc.info,  Node: const,  Next: constructor,  Prev: Conjugate,  Up: Reference

const
=====

(Under construction.)

Synopsis
--------

Description
-----------

Constant declaration or constant parameter declaration.

Conforming to
-------------

`const' is defined in ISO 7185 Pascal and supported by all known Pascal
variants. `const' parameters are a Borland Pascal extension. Pointers
to `const' are a GNU Pascal extension.

   Constant declarations allow you to define names for constant
(unchanging) values, such as using `SecondsPerHour' instead of 3600.
This can make your program much more readable and maintainable.

   GNU Pascal allows you to define constant strings, records and arrays
as well as simple numeric constants.

   GNU Pascal also implements the const parameter extension which
allows the compiler to pass parameters by reference while still
allowing you to pass constant values as inputs.  See *Note Subroutine
Parameter List Declaration:: for more information.

   @@ Pointers to `const' @@

Example
-------

     program ConstDemo;

     type
       Rec = record
         x: Integer;
         y: Integer;
       end;

     const
       a = 5;
       constr: Rec = (10, 12);

     procedure doit (const r: Rec; const s: String);
     begin
       WriteLn (r.x);
       WriteLn (r.y);
       WriteLn (s);
     end;

     var
       variabler: Rec;

     begin
       variabler.x := 16;
       variabler.y := 7;
       doit (variabler, 'Should be 16 and 7');
       doit (constr, 'Should be 10 and 12');
     end.

See also
--------

*Note Keywords::, *Note var::, *Note protected::, *Note Subroutine
Parameter List Declaration::.


File: gpc.info,  Node: constructor,  Next: Continue,  Prev: const,  Up: Reference

constructor
===========

(Under construction.) ;-)

Synopsis
--------

Description
-----------

Object constructor.

Conforming to
-------------

`constructor' is an Object Pascal and a Borland Pascal extension.

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: Continue,  Next: Copy,  Prev: constructor,  Up: Reference

Continue
========

Synopsis
--------

     Continue  { simple statement }

Description
-----------

`Continue' goes on with loop iteration by jumping to the end of the
current loop body. Note: `Continue' can only stand within a `while',
`repeat' or a `for' loop.

Conforming to
-------------

`Continue' is a Borland Pascal extension, Mac Pascal has `Cycle'
instead.

Example
-------

     program ContinueDemo;
     var
       Foo, Bar: Integer;
     begin
       WriteLn ('Enter three numbers:');
       for Bar := 1 to 3 do
         begin
           ReadLn (Foo);
           if Foo < 5 then
             Continue;
           WriteLn ('Your number was greater than 5.')
         end
     end.

See also
--------

*Note Loop Control Statements::, *Note Break::, *Note Cycle::, *Note
Exit::, *Note Halt::, *Note Leave::, *Note Return::, *Note goto::.


File: gpc.info,  Node: Copy,  Next: Cos,  Prev: Continue,  Up: Reference

Copy
====

Synopsis
--------

     function Copy (S: String; FirstChar, Count: Integer): String;
or
     function Copy (S: String; FirstChar: Integer): String;

Description
-----------

`Copy' returns a sub-string of `S' starting with the character at
position FIRSTCHAR. If COUNT is given, such many characters will be
copied into the sub-string. If COUNT is omitted, the sub-string will
range to the end of S.

   If `Count' is too large for the sub-string to fit in S, the result
will be truncated at the end of S. If `FirstChar' exceeds the length of
S, the empty string will be returned. (For a function which does not
truncate but triggers a runtime error instead, see *Note SubStr::.)

   Please note that GPC's strings may be longer than 255 characters. If
you want to isolate the second half of a string S starting with the
third character, use `Copy (S, 3)' instead of `Copy (S, 3, 255)'.

Conforming to
-------------

`Copy' is a UCSD Pascal extension. The possibility to omit the third
parameter is a GNU Pascal extension.

Example
-------

     program CopyDemo;
     var
       S: String (42);
     begin
       S := 'Hello';
       WriteLn (Copy (S, 2, 3));  { yields `ell' }
       WriteLn (Copy (S, 3));     { yields `llo' }
       WriteLn (Copy (S, 4, 7));  { yields `lo' }
       WriteLn (Copy (S, 42))     { yields the empty string }
     end.

See also
--------

*Note SubStr::, *Note String Slice Access::.


File: gpc.info,  Node: Cos,  Next: CString,  Prev: Copy,  Up: Reference

Cos
===

Synopsis
--------

     function Cos (x: Real): Real;
or
     function Cos (z: Complex): Complex;

Description
-----------

`Cos' returns the cosine of the argument.  The result is in the range
`-1 < Cos (x) < 1' for real arguments.

Conforming to
-------------

The function `Cos' is defined in ISO 7185 Pascal; its application to
complex values is defined in ISO 10206 Extended Pascal.

Example
-------

     program CosDemo;
     begin
       { yields 0.5 since Cos (Pi / 3) = 0.5 }
       WriteLn (Cos (Pi / 3) : 0 : 5)
     end.

See also
--------

*Note ArcTan::, *Note Sin::, *Note Ln::, *Note Arg::.


File: gpc.info,  Node: CString,  Next: CString2String,  Prev: Cos,  Up: Reference

CString
=======

(Under construction.)

Synopsis
--------

     type
       CString = ^Char;

Description
-----------

Conforming to
-------------

`CString' is a GNU Pascal extension.

Example
-------

     program CStringDemo;
     var
       s: CString;
     begin
       s := 'Hello, world!';
       {$X+}
       WriteLn (s)
     end.

See also
--------


File: gpc.info,  Node: CString2String,  Next: CStringCopyString,  Prev: CString,  Up: Reference

CString2String
==============

(Under construction.)

Synopsis
--------

     function CString2String (S: CString): String;

Description
-----------

Conforming to
-------------

`CString2String' is a GNU Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: CStringCopyString,  Next: CurrentRoutineName,  Prev: CString2String,  Up: Reference

CStringCopyString
=================

(Under construction.)

Synopsis
--------

     function CStringCopyString (Dest: CString; const Source: String): CString;

Description
-----------

Conforming to
-------------

`CStringCopyString' is a GNU Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: CurrentRoutineName,  Next: CWord,  Prev: CStringCopyString,  Up: Reference

CurrentRoutineName
==================

Synopsis
--------

     function CurrentRoutineName: String;

Description
-----------

`CurrentRoutineName' returns the name of the current routine from where
it's called.

Conforming to
-------------

`CurrentRoutineName' is a GNU Pascal extension.

Example
-------

     program CurrentRoutineNameDemo;

     procedure FooBar;
     begin
       WriteLn (CurrentRoutineName)  { `FooBar' }
     end;

     begin
       WriteLn (CurrentRoutineName);  { `main program' }
       FooBar
     end.

See also
--------


File: gpc.info,  Node: CWord,  Next: Cycle,  Prev: CurrentRoutineName,  Up: Reference

CWord
=====

Synopsis
--------

     type
       CWord = CCardinal;

Description
-----------

`CCardinal' is an unsigned integer type. On some platforms it is 32
bits wide and thus has a range of `0 .. 4294967295'. It is the same as
*Note CCardinal::.

   `CWord' in GNU Pascal is compatible to `unsigned int' in GNU C.

   There are lots of other integer types in GPC, see *Note Integer
Types::.

Conforming to
-------------

`CWord' is a GNU Pascal extension.

Example
-------

     program CWordDemo;
     var
       a: CWord;
     begin
       a := 42;
       WriteLn (a)
     end.

See also
--------

*Note CCardinal::, *Note Integer Types::, *Note Subrange Types::.


File: gpc.info,  Node: Cycle,  Next: Date,  Prev: CWord,  Up: Reference

Cycle
=====

Synopsis
--------

     Cycle  { simple statement }

Description
-----------

`Cycle' goes on with loop iteration by jumping to the end of the
current loop body. Note: `Cycle' can only stand within a `while',
`repeat' or a `for' loop.

Conforming to
-------------

`Cycle' is a Mac Pascal extension. Borland Pascal has `Continue'
instead.

Example
-------

     program CycleDemo;
     var
       Foo, Bar: Integer;
     begin
       WriteLn ('Enter three numbers:');
       for Bar := 1 to 3 do
         begin
           ReadLn (Foo);
           if Foo < 5 then
             Cycle;
           WriteLn ('Your number was greater than 5.')
         end
     end.

See also
--------

*Note Loop Control Statements::, *Note Break::, *Note Continue::, *Note
Exit::, *Note Halt::, *Note Leave::, *Note Return::, *Note goto::.


File: gpc.info,  Node: Date,  Next: Dec,  Prev: Cycle,  Up: Reference

Date
====

Synopsis
--------

     function Date (T: TimeStamp): packed array [1 .. DATE_LENGTH] of Char;

Description
-----------

Date takes a `TimeStamp' parameter and returns the date as a string (in
the form of a packed array of `Char').  DATE_LENGTH is an
implementation defined invisible constant.

Conforming to
-------------

`Date' is an ISO 10206 Extended Pascal extension.

Example
-------

Set *Note TimeStamp::.

See also
--------

*Note TimeStamp::, *Note GetTimeStamp::, *Note Time::, *Note Date And
Time Routines::.


File: gpc.info,  Node: Dec,  Next: DefineSize,  Prev: Date,  Up: Reference

Dec
===

Synopsis
--------

For ordinal types:
     procedure Dec (var x: ORDINAL_TYPE);
   or
     procedure Dec (var x: ORDINAL_TYPE; Amount: AND_INTEGER_TYPE);

   For pointer types:
     procedure Dec (var p: ANY_POINTER_TYPE);
   or
     procedure Dec (var p: ANY_POINTER_TYPE; Amount: AND_INTEGER_TYPE);

Description
-----------

For ordinal types, `Dec' decreases the value of `x' by one or by
`amount' if specified.

   If the argument `p' is pointing to a specified type (typed pointer),
`Dec' decreases the address of `p' by the size of the type `p' is
pointing to or by `amount' times that size respectively. If `p' is an
untyped pointer (i.e. `p' is of type *Note Pointer::), `p' is decreased
by one, otherwise by `amount' if specified.

Conforming to
-------------

`Dec' is a Borland Pascal extension. The combination of the second
argument with application to pointers is a GNU Pascal extension.

Example
-------

     program DecDemo;
     var
       x: Integer;
       y: array [1 .. 5] of Integer;
       p: ^Integer;
     begin
       x := 9;
       Dec (x, 10);  { yields -1 }
       {$X+}         { Turn on extended systax }
       p := @y[5];   { p points to y[5] }
       Dec (p, 3)    { p points to y[2] }
     end.

See also
--------

*Note Inc::, *Note Pred::, *Note Succ::, *Note Pointer Arithmetics::.


File: gpc.info,  Node: DefineSize,  Next: Delete,  Prev: Dec,  Up: Reference

DefineSize
==========

(Under construction.)

Synopsis
--------

     procedure DefineSize (var F: ANY_FILE; NewSize: Integer);

Description
-----------

Conforming to
-------------

`DefineSize' is a GNU Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: Delete,  Next: destructor,  Prev: DefineSize,  Up: Reference

Delete
======

(Under construction.)

Synopsis
--------

     procedure Delete (var S: String; FirstChar, Count: Integer);
or
     procedure Delete (var S: String; FirstChar: Integer);

Description
-----------

Conforming to
-------------

`Delete' is a UCSD Pascal extension. The possibility to omit the third
parameter is a GNU Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: destructor,  Next: Discard,  Prev: Delete,  Up: Reference

destructor
==========

(Under construction.)

Synopsis
--------

Description
-----------

Object destructor.

Conforming to
-------------

`destructor' is an Object Pascal and a Borland Pascal extension.

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: Discard,  Next: Dispose,  Prev: destructor,  Up: Reference

Discard
=======

Synopsis
--------

     Discard (Value);

Description
-----------

`Discard' does nothing, but tells the compiler that the value given as
an argument is not further used. It can be applied, e.g., to routine
parameters which are to be ignored, so no warning about them will be
given with `-Wunused', or when calling a function and ignore its result.

   An alternative for the latter case is to give the function the
`ignorable' attribute. This is useful is the function's result is
expected to be ignored regularly. If, however, a result is generally
meaningful and only to be ignored in a particular case, using `Discard'
is preferable.

Conforming to
-------------

`Discard' is a GNU Pascal extension.

Example
-------

program DiscardDemo;

   function Foo (a: Integer): Integer; begin   WriteLn (a);   Foo := a
+ 1 end;

   { Parameter `a' is there only to make the parameter list compatible
to that of function `Foo'. } function Bar (a: Integer): Integer; begin
 Discard (a);  { Tell the compiler that we intentionally do not
          use `a' in this function. }   Bar := a + 1 end;

   var   c: Char;   f: function (a: Integer): Integer;

   begin   Write ('With output? ');   ReadLn (c);   if LoCase (c) = 'y'
then     f := Foo   else     f := Bar;   Discard (f (42))  { Call the
function, but ignore its result } end.

See also
--------


File: gpc.info,  Node: Dispose,  Next: div,  Prev: Discard,  Up: Reference

Dispose
=======

(Under construction.)

Synopsis
--------

     Dispose (PointerVar: Pointer);
or
     Dispose (PointerVar: Pointer; TAG_FIELD_VALUES);
   or
     Dispose (ObjectPointerVar: Pointer; DESTRUCTOR_CALL);

Description
-----------

Conforming to
-------------

`Dispose' is defined in ISO 7185 Pascal and supported by most known
Pascal variants, but not by UCSD Pascal. Its use for objects is a
Borland Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: div,  Next: do,  Prev: Dispose,  Up: Reference

div
===

Synopsis
--------

     operator div (p, q: Integer) = r: Integer;

Description
-----------

Integer division operator.

Conforming to
-------------

`div' is defined in ISO 7185 Pascal and supported by all known Pascal
variants.

Example
-------

     program DivDemo;

     var
       a, b: Integer;

     begin
       a := 16;
       b := 7;
       WriteLn (a div b);  { `2' }
     end.

See also
--------

*Note Keywords::.


File: gpc.info,  Node: do,  Next: Double,  Prev: div,  Up: Reference

do
==

Synopsis
--------

     for ... do
       STATEMENT
or
     while ... do
       STATEMENT
   or
     with ... do
       STATEMENT
   or
     to begin do
       STATEMENT
   or
     to end do
       STATEMENT

Description
-----------

The `do' reserved word is used in combination with other Pascal
keywords in many ways. For description and examples see the relevant
reference sections: `for', `while', `with', `to begin', `to end'.

Conforming to
-------------

`do' is defined in ISO 7185 Pascal and supported by all known Pascal
variants.

Example
-------

See references.

See also
--------

*Note Keywords::, *Note for::, *Note while::, *Note with::, *Note to
begin do::, *Note to end do::.


File: gpc.info,  Node: Double,  Next: downto,  Prev: do,  Up: Reference

Double
======

(Under construction.)

Synopsis
--------

     type
       Double = Real;

Description
-----------

`Double' is a synonym for the `Real' data type and supported for
compatibility with other compilers.

Conforming to
-------------

`Double' is a Borland Pascal extension.

Example
-------

     program DoubleDemo;
     var
       A: Double;  { There is nothing special with `Double'. }
       B: Real;
     begin
       A := Pi;
       A := B
     end.

See also
--------


File: gpc.info,  Node: downto,  Next: else,  Prev: Double,  Up: Reference

downto
======

Synopsis
--------

     for VARIABLE := VALUE1 downto VALUE2 do
       STATEMENT

Description
-----------

The `downto' reserved word is used in combination with `for' to build a
`for' loop.

Conforming to
-------------

`downto' is defined in ISO 7185 Pascal and supported by all known
Pascal variants.

Example
-------

program DowntoDemo; var   i: Integer; begin   for i := 10 downto 1 do
WriteLn (i) end.

See also
--------

*Note Keywords::, *Note for::.


File: gpc.info,  Node: else,  Next: Empty,  Prev: downto,  Up: Reference

else
====

Synopsis
--------

As part of the `if' ... `then' ... `else' statement:
     if BOOLEAN_EXPRESSION then
       STATEMENT1
     else
       STATEMENT2
   or, as part of the `case' ... `else' statement:
     case EXPRESSION of
       SELECTOR: STATEMENT;
       ...
       SELECTOR: STATEMENT
     else  { ``otherwise'' instead of ``else'' is allowed }
       STATEMENT;
       ...
       STATEMENT
     end

Description
-----------

`else' is part of the `if ... then ... else' statement which provides a
possibility to execute statements alternatively. In the `case'
statement, `else' starts a series of statements which is executed if no
selector fit in EXPRESSION. In this situation, `else' is a synonym for
`otherwise'.

Conforming to
-------------

`else' in `if' statements is defined in ISO 7185 Pascal and supported
by all known Pascal variants. `else' in `case' statements is a Borland
Pascal extension; ISO 10206 Extended Pascal has `otherwise' instead.

Example
-------

     program ElseDemo;
     var
       i: Integer;
     begin
       Write ('Enter a number: ');
       ReadLn (i);
       if i > 42 then
         WriteLn ('The number is greater than 42')
       else
         WriteLn ('The number is not greater than 42')
     end.

See also
--------

*Note Keywords::, *Note if::, *Note case::, *Note otherwise::.


File: gpc.info,  Node: Empty,  Next: end,  Prev: else,  Up: Reference

Empty
=====

(Under construction.)

Synopsis
--------

     function Empty (var F: ANY_FILE): Boolean;

Description
-----------

Conforming to
-------------

`Empty' is an ISO 10206 Extended Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: end,  Next: EOF,  Prev: Empty,  Up: Reference

end
===

Synopsis
--------

     begin
       STATEMENT;
       STATEMENT;
       ...
       STATEMENT
     end

Description
-----------

The reserved word `end' closes a `begin' ... `end'; statement which
joins several STATEMENTS together into one compound statement.

   @@ end of a `case' statement @@ end of a record or object declaration
@@ part of a `to end do' module destructor

Conforming to
-------------

`end' is defined in ISO 7185 Pascal and supported by all known Pascal
variants.

Example
-------

     program EndDemo;
     begin
       if True then
         WriteLn ('single statement');
       if True then
         begin  { clamp statement1 ... }
           WriteLn ('statement1');
           WriteLn ('statement2')
         end    { ... to statement2 }
     end.

See also
--------

*Note Keywords::, *Note begin end Compound Statement::, *Note begin::


File: gpc.info,  Node: EOF,  Next: EOLn,  Prev: end,  Up: Reference

EOF
===

(Under construction.)

Synopsis
--------

     function EOF ([var F: ANY_FILE]): Boolean;
or
     function EOF: Boolean;

Description
-----------

Conforming to
-------------

`EOF' is defined in ISO 7185 Pascal and supported by all known Pascal
variants.

Example
-------

See also
--------


File: gpc.info,  Node: EOLn,  Next: EpsReal,  Prev: EOF,  Up: Reference

EOLn
====

(Under construction.)

Synopsis
--------

     function EOLn ([var F: Text]): Boolean;
or
     function EOLn: Boolean;

Description
-----------

Conforming to
-------------

`EOLn' is defined in ISO 7185 Pascal and supported by all known Pascal
variants.

Example
-------

See also
--------


File: gpc.info,  Node: EpsReal,  Next: EQ,  Prev: EOLn,  Up: Reference

EpsReal
=======

(Under construction.)

Synopsis
--------

Description
-----------

Conforming to
-------------

`EpsReal' is an ISO 10206 Extended Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: EQ,  Next: EQPad,  Prev: EpsReal,  Up: Reference

EQ
==

(Under construction.)

Synopsis
--------

     function EQ (S1, S2: String): Boolean;

Description
-----------

Conforming to
-------------

`EQ' is an ISO 10206 Extended Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: EQPad,  Next: Erase,  Prev: EQ,  Up: Reference

EQPad
=====

(Under construction.)

Synopsis
--------

     function EQPad (S1, S2: String): Boolean;

Description
-----------

Conforming to
-------------

`EQPad' is a GNU Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: Erase,  Next: except,  Prev: EQPad,  Up: Reference

Erase
=====

(Under construction.)

Synopsis
--------

     procedure Erase (var F: ANY_FILE);

Description
-----------

Conforming to
-------------

`Erase' is a Borland Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: except,  Next: Exclude,  Prev: Erase,  Up: Reference

except
======

Not yet implemented.

Synopsis
--------

Conforming to
-------------

`except' is a Borland Delphi extension.

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: Exclude,  Next: Exit,  Prev: except,  Up: Reference

Exclude
=======

Synopsis
--------

     Exclude (SET_VARIABLE, ORDINAL_VALUE);

Description
-----------

Remove (subtract) a single element from a set.  ORDINAL_VALUE must be
compatible with the base type of SET_VARIABLE.  Exclude is equivalent
to:

     SET_VARIABLE := SET_VARIABLE - [ORDINAL_VALUE];

   If SET_VARIABLE does not contain ORDINAL_VALUE, nothing happens.

Conforming to
-------------

`Exclude' is a Borland Pascal extension.

Example
-------

     program ExcludeDemo;

     var
       Ch: Char;
       MyCharSet: set of Char;

     begin
       MyCharSet := ['P', 'N', 'L'];
       Exclude (MyCharSet , 'N')  { L, P }
     end.

   See other examples in *Note set:: and *Note Set Operations::.

See also
--------

*Note Keywords::, *Note Set Operations::, *Note set::, *Note in::,
*Note Include::.


File: gpc.info,  Node: Exit,  Next: Exp,  Prev: Exclude,  Up: Reference

Exit
====

Synopsis
--------

     procedure Exit;

   or

     procedure Exit (program);

   or

     procedure Exit (Identifier);

Description
-----------

`Exit' without an argument leaves the currently executed procedure or
function. Note: If `Exit' is called within the main program, it will be
terminated instantly.

   `Exit' with an argument that is `program' or the name of the current
program, terminates the program, and is equivalent to `Halt'.

   `Exit' with an argument that is the name of the current or an
encompassing routine leaves that routine.

Conforming to
-------------

`Exit' is a UCSD Pascal extension. Borland Pascal only allows it
without an argument.

Example
-------

     program ExitDemo;

     procedure Foo (Bar: Integer);
     var
       Baz, Fac: Integer;
     begin
       if Bar < 1 then
         Exit;  { Exit `Foo' }
       Fac := 1;
       for Baz := 1 to Bar do
         begin
           Fac := Fac * Baz;
           if Fac >= Bar then
             Exit;  { Exit `Foo' }
           WriteLn (Bar,' is greater than ', Baz, '!, which is equal to ', Fac)
       end
     end;

     begin
       Foo (-1);
       Foo (789);
       Exit;            { Terminates program }
       Foo (987654321)  { This is not executed anymore }
     end.

See also
--------

*Note Break::, *Note Continue::, *Note Halt::.


File: gpc.info,  Node: Exp,  Next: export,  Prev: Exit,  Up: Reference

Exp
===

Synopsis
--------

     function Exp (x: Real): Real;
or
     function Exp (z: Complex): Complex;

Description
-----------

The exponential function `Exp' computes the value of e to the power of
x, where the Euler number e = Exp (1) is the base of the natural
logarithm.

Conforming to
-------------

The function `Exp' is defined in ISO 7185 Pascal; its application to
complex values is defined in ISO 10206 Extended Pascal.

Example
-------

     program ExpDemo;
     var
       z: Complex;
     begin
       z := Cmplx (1, - 2 * Pi);  { z = 1 - 2 pi i }
       z := Exp (z);  { yields e = Exp (1), since Exp ix = Cos x + i Sin x }
       WriteLn (Ln (Re (z)) : 0 : 5)  { prints 1 = Ln (Exp (1)) }
     end.

See also
--------

*Note Ln::


File: gpc.info,  Node: export,  Next: exports,  Prev: Exp,  Up: Reference

export
======

(Under construction.)

Synopsis
--------

     export `interface_name' = (IDENTIFIER, IDENTIFIER, ...);

   or

     export `interface_name' = all;

Description
-----------

Interface export for Extended Pascal modules.

   `all' means to automatically export all identifiers declared in the
interface module.

Conforming to
-------------

`export' is an ISO 10206 Extended Pascal extension. It also exists in
Borland Pascal, but with a different meaning, not (yet) supported by
GPC.

   `export all' is a GNU Pascal extension.

Example
-------

     program ExportDemo;

     import AllInterface in 'somemodule.pas';

     begin
       Bar (a);
       WriteLn (b)
     end.

     module SomeModule interface;

     export
       SomeInterface = (a);
       AllInterface = all;  { Same as `AllInterface = (a, b, Bar);' }

     var
       a, b: Integer;

     procedure Bar (i: Integer);

     end.

     module SomeModule implementation;

     procedure Bar (i: Integer);
     begin
       b := a
     end;

     to begin do
       a := 42;

     end.

See also
--------

*Note Keywords::, *Note Modules::.


File: gpc.info,  Node: exports,  Next: Extend,  Prev: export,  Up: Reference

exports
=======

Not yet implemented.

Synopsis
--------

Description
-----------

Library export.

Conforming to
-------------

`exports' is a Borland Pascal extension.

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: Extend,  Next: Extended,  Prev: exports,  Up: Reference

Extend
======

(Under construction.)

Synopsis
--------

     procedure Extend (var F: ANY_FILE; [FileName: String;]
                                         [BlockSize: Cardinal]);

Description
-----------

`Extend' opens a file for writing. If the file does not exist, it is
created. If it does exist, the file pointer is positioned after the
last element.

   Like `Rewrite', `Reset' and `Append' do, `Reset' accepts an optional
second parameter for the name of the file in the filesystem and a third
parameter for the block size of the file. The third parameter is
allowed only (and by default also required) for untyped files. For
details, see *Note Rewrite::.

Conforming to
-------------

`Extend' is an ISO 10206 Extended extension. Borland Pascal has *Note
Append:: instead.  The `BlockSize' parameter is a Borland Pascal
extension.  The `FileName' parameter is a GNU Pascal extension.

Example
-------

     program ExtendDemo;
     var
       Sample: Text;
     begin
       Assign (Sample, 'sample.txt');
       Rewrite (Sample);
       WriteLn (Sample, 'Hello, World!');  { `sample.txt' now has one line }
       Close (Sample);

       { ... }

       Extend (Sample);
       WriteLn (Sample, 'Hello again!');  { `sample.txt' now has two lines }
       Close (Sample)
     end.

See also
--------

*Note Assign::, *Note Reset::, *Note Rewrite::, *Note Update::, *Note
Append::.


File: gpc.info,  Node: Extended,  Next: external,  Prev: Extend,  Up: Reference

Extended
========

(Under construction.)

Synopsis
--------

     type
       Extended = LongReal;

Description
-----------

Conforming to
-------------

`Extended' is a Borland Pascal extension.

Example
-------

     program ExtendedDemo;
     var
       a: Extended;
     begin
       a := 42;
       WriteLn (a)
     end.

See also
--------


File: gpc.info,  Node: external,  Next: Fail,  Prev: Extended,  Up: Reference

external
========

(Under construction.)

Synopsis
--------

     DECLARATION external;

   or

     DECLARATION external name LINKER_NAME;

Description
-----------

Declaration of external object.

Conforming to
-------------

`external' is a UCSD Pascal extension.

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: Fail,  Next: False,  Prev: external,  Up: Reference

Fail
====

(Under construction.)

Synopsis
--------

Description
-----------

Conforming to
-------------

`Fail' is a Borland Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: False,  Next: far,  Prev: Fail,  Up: Reference

False
=====

Synopsis
--------

     type
       Boolean = (False, True);  { built-in type }

Description
-----------

`False' is one of the two Boolean values and is used to represent a
condition which is never fullfilled. For example, the expression, `1 =
2' always yields `False'. It is the opposite of `True'. `False' has the
ordinal value 0.

Conforming to
-------------

`False' is defined in ISO 7185 Pascal and supported by all known Pascal
variants.

Example
-------

     program FalseDemo;

     var
       a: Boolean;

     begin
       a := 1 = 2;  { yields False }
       WriteLn (Ord (False));  { 0 }
       WriteLn (a);  { False }
       if False then WriteLn ('This is not executed.')
     end.

See also
--------

*Note Boolean (Intrinsic)::, *Note True::, *Note Boolean::.


File: gpc.info,  Node: far,  Next: file,  Prev: False,  Up: Reference

far
===

Synopsis
--------

Description
-----------

The `far' directive can be appended to a procedure or function heading
but is ignored by GPC. It is there for Borland compatibility, only.
(Since the GNU compilers provide a flat memory model, the distinction
between `near' and `far' pointers is void.)

Conforming to
-------------

`far' is a Borland Pascal extension.

Example
-------

     program FarDemo;

     var
       p: procedure;

     {$W no-near-far}  { Don't warn about the uselessness of `far' }

     procedure Foo; far;  { `far' has no effect in GPC }
     begin
       WriteLn ('Foo')
     end;

     begin
       p := Foo;  { Would also work without `far' in GPC. }
       p
     end.

See also
--------

*Note Keywords::, *Note near::.


File: gpc.info,  Node: file,  Next: FilePos,  Prev: far,  Up: Reference

file
====

(Under construction.)

Synopsis
--------

In type definitions:
     file of TYPE
   or
     file

Description
-----------

Non-text file type declaration.

Conforming to
-------------

Typed files (`file of TYPE') are defined in ISO 7185 Pascal and
supported by all known Pascal variants. Untyped files (`file') are a
Borland Pascal extension.

Example
-------

See also
--------

*Note Keywords::, *Note Text::, *Note AnyFile::.


File: gpc.info,  Node: FilePos,  Next: FileSize,  Prev: file,  Up: Reference

FilePos
=======

(Under construction.)

Synopsis
--------

     function FilePos (var F: ANY_FILE): Integer;

Description
-----------

Conforming to
-------------

`FilePos' is a Borland Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: FileSize,  Next: FillChar,  Prev: FilePos,  Up: Reference

FileSize
========

(Under construction.)

Synopsis
--------

     function FileSize (var F: ANY_FILE): Integer;

Description
-----------

Conforming to
-------------

`FileSize' is a Borland Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: FillChar,  Next: finalization,  Prev: FileSize,  Up: Reference

FillChar
========

(Under construction.)

Synopsis
--------

     procedure FillChar (var Dest; Count: SizeType; Val: Char);
or
     procedure FillChar (var Dest; Count: SizeType; Val: Byte);

Description
-----------

Conforming to
-------------

`FillChar' is a UCSD Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: finalization,  Next: Finalize,  Prev: FillChar,  Up: Reference

finalization
============

(Under construction.)

Synopsis
--------

Description
-----------

Unit finalization.

   It is equivalent to Extended Pascal's `to end do'.

Conforming to
-------------

`finalization' is a Borland Delphi extension.

Example
-------

See also
--------

*Note Keywords::, *Note initialization::, *Note to end do::.


File: gpc.info,  Node: Finalize,  Next: finally,  Prev: finalization,  Up: Reference

Finalize
========

(Under construction.)

Synopsis
--------

     procedure Finalize (var Aynthing);

Description
-----------

`Finalize' does all necessary clean-ups for the parameter. This is
normally done automatically when a variable goes out of scope, so you
need to call `Finalize' only in special situations, e.g.  when you
deallocate a dynamic variable with `FreeMem' rather than `Dispose'.

   Using a variable after applying `Finalize' to it (and without
applying `Initialize' to it again) is invalid and produces undefined
results.

Conforming to
-------------

`Finalize' is a Borland Delphi extension.

Example
-------

See also
--------

*Note Initialize::, *Note Dispose::, *Note FreeMem::.


File: gpc.info,  Node: finally,  Next: Flush,  Prev: Finalize,  Up: Reference

finally
=======

Not yet implemented.

Synopsis
--------

Conforming to
-------------

`finally' is a Borland Delphi extension.

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: Flush,  Next: for,  Prev: finally,  Up: Reference

Flush
=====

(Under construction.)

Synopsis
--------

     procedure Flush (var F: ANY_FILE);

Description
-----------

Conforming to
-------------

`Flush' is a Borland Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: for,  Next: FormatString,  Prev: Flush,  Up: Reference

for
===

Synopsis
--------

For ordinal index variables:
     for ORDINAL_VARIABLE := INITIAL_VALUE to FINAL_VALUE do
       STATEMENT
   or
     for ORDINAL_VARIABLE := INITIAL_VALUE downto FINAL_VALUE do
       STATEMENT

   For sets:
     for SET_ELEMENT_TYPE_VARIABLE in SOME_SET do
       STATEMENT

   For pointer index variables:
     for POINTER_VARIABLE := INITIAL_ADDRESS to FINAL_ADDRESS do
       STATEMENT
   or
     for POINTER_VARIABLE := INITIAL_ADDRESS downto FINAL_ADDRESS do
       STATEMENT

   @@ Set member iteration

Description
-----------

The `for' statement is a count loop. For further information see *Note
for Statement::.

Conforming to
-------------

`for' is defined in ISO 7185 Pascal and supported by all known Pascal
variants. Iteration of Pointers is a Borland Pascal extension. Set
member iteration is an ISO 10206 Extended Pascal extension.

Example
-------

     program ForDemo;
     var
       CharSet: set of Char;
       c: Char;
       n: Integer;
       Fac: array [0 .. 10] of Integer;
       PInt: ^Integer;
     begin
       CharSet := ['g', 'p', 'c'];
       for c in CharSet do
         WriteLn (c);  { prints `c', `g', `p' in three lines }
       Fac[0] := 1;
       for n := 1 to 10 do  { computes the factorial of n for n = 0 .. 10 }
         Fac[n] := Fac[n - 1] * n;
       {$X+}
       { prints n! for n = 0 .. 10 }
       for PInt := @Fac[0] to @Fac[10] do
         WriteLn (PInt - @Fac[0], '! = ', PInt^)
     end.

See also
--------

*Note Keywords::, *Note Set Types::, *Note Pointer Arithmetics::


File: gpc.info,  Node: FormatString,  Next: forward,  Prev: for,  Up: Reference

FormatString
============

(Under construction.)

Synopsis
--------

Description
-----------

Conforming to
-------------

`FormatString' is a GNU Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: forward,  Next: Frac,  Prev: FormatString,  Up: Reference

forward
=======

(Under construction.)

Synopsis
--------

Description
-----------

Declaration of a routine whose definition follows below.

Conforming to
-------------

`forward' is a UCSD Pascal extension.

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: Frac,  Next: FrameAddress,  Prev: forward,  Up: Reference

Frac
====

Synopsis
--------

     function Frac (x: Real): Real;

Description
-----------

`Frac' returns the fractional part of a floating point number.

Conforming to
-------------

`Frac' is a Borland Pascal extension.

Example
-------

     program FracDemo;

     begin
       WriteLn (Frac (12.345) : 1 : 5);  { 0.34500 }
       WriteLn (Int (12.345) : 1 : 5);  { 12.00000 }
       WriteLn (Round (12.345) : 1);  { 12 }
       WriteLn (Trunc (12.345) : 1);  { 12 }

       WriteLn (Frac (-12.345) : 1 : 5);  { -0.34500 }
       WriteLn (Int (-12.345) : 1 : 5);  { -12.00000 }
       WriteLn (Round (-12.345) : 1);  { -12 }
       WriteLn (Trunc (-12.345) : 1);  { -12 }

       WriteLn (Frac (12.543) : 1 : 5);  { 0.54300 }
       WriteLn (Int (12.543) : 1 : 5);  { 12.00000 }
       WriteLn (Round (12.543) : 1);  { 13 }
       WriteLn (Trunc (12.543) : 1);  { 12 }

       WriteLn (Frac (-12.543) : 1 : 5);  { -0.54300 }
       WriteLn (Int (-12.543) : 1 : 5);  { -12.00000 }
       WriteLn (Round (-12.543) : 1);  { -13 }
       WriteLn (Trunc (-12.543) : 1);  { -12 }
     end.

See also
--------

*Note Real Types::, *Note Real::, *Note Int::, *Note Round::, *Note
Trunc::.


File: gpc.info,  Node: FrameAddress,  Next: FreeMem,  Prev: Frac,  Up: Reference

FrameAddress
============

(Under construction.)

Synopsis
--------

Description
-----------

Conforming to
-------------

`FrameAddress' is a GNU Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: FreeMem,  Next: function,  Prev: FrameAddress,  Up: Reference

FreeMem
=======

Synopsis
--------

     procedure FreeMem (var p: Pointer; Size: Cardinal);
or
     procedure FreeMem (var p: Pointer);

Description
-----------

Releases a chunk of memory previously allocated using `GetMem'.  The
parameter SIZE is optional. Its value is currently ignored.

   Since Extended Pascal's schemata provide a cleaner way to implement
dynamical arrays and such, we recommend using `GetMem' and `FreeMem'
only for low-level applications or for interfacing with other languages.

Conforming to
-------------

`FreeMem' is a Borland Pascal extension. `FreeMem' with only one
parameter is a GNU Pascal extension.

Example
-------

*Note GetMem::.

See also
--------

*Note GetMem::, *Note Schema Types::, *Note Dispose::, *Note Mark::,
*Note Release::.


File: gpc.info,  Node: function,  Next: GE,  Prev: FreeMem,  Up: Reference

function
========

(Under construction.)

Synopsis
--------

Description
-----------

Function declaration.

Conforming to
-------------

`function' is defined in ISO 7185 Pascal and supported by all known
Pascal variants.

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: GE,  Next: GEPad,  Prev: function,  Up: Reference

GE
==

(Under construction.)

Synopsis
--------

     function GE (S1, S2: String): Boolean;

Description
-----------

Conforming to
-------------

`GE' is an ISO 10206 Extended Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: GEPad,  Next: Get,  Prev: GE,  Up: Reference

GEPad
=====

(Under construction.)

Synopsis
--------

     function GEPad (S1, S2: String): Boolean;

Description
-----------

Conforming to
-------------

`GEPad' is a GNU Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: Get,  Next: GetMem,  Prev: GEPad,  Up: Reference

Get
===

(Under construction.)

Synopsis
--------

     procedure Get (var F: TYPED_FILE);

Description
-----------

Conforming to
-------------

`Get' is defined in ISO 7185 Pascal and supported by all known Pascal
variants except UCSD/Borland Pascal and its variants.

Example
-------

See also
--------


File: gpc.info,  Node: GetMem,  Next: GetTimeStamp,  Prev: Get,  Up: Reference

GetMem
======

Synopsis
--------

     procedure GetMem (var p: Pointeger; Size: Cardinal);

Description
-----------

Allocates dynamical storage on the heap and returns a pointer to it in
`p'.

   Since Extended Pascal's schemata provide a cleaner way to implement
dynamical arrays and such, we recommend using `GetMem' and `FreeMem'
only for low-level applications.

Conforming to
-------------

`GetMem' is a Borland Pascal extension.

Example
-------

The Borland-comatibility unit `Graph' from the `BPcompat' package
supports a `GetImage' and a `PutImage' procedure which need a variable
of size `ImageSize' as a buffer. Since these are "black box" routines,
the buffer can't reasonably be a schema providing a dynamical array.
Instead, we have to use `GetMem' and `FreeMem' for dynamical memory
allocation.

     program GetMemDemo;
     var
       Buffer: Pointer;
       Size: Cardinal;
     begin
       Size := Random (10000);  { the size can be determined at run time }
       GetMem (Buffer, Size);
       { Do something with Buffer }
       FreeMem (Buffer)  { or: FreeMem (Buffer, Size) }
     end.

See also
--------

*Note FreeMem::, *Note New::, *Note Schema Types::.


File: gpc.info,  Node: GetTimeStamp,  Next: goto,  Prev: GetMem,  Up: Reference

GetTimeStamp
============

Synopsis
--------

     procedure GetTimeStamp (var T: TimeStamp);

Description
-----------

GetTimeStamp gets the current local date and time as a `TimeStamp'
record containing the Year, Month, Day, Hour, Minute, Second, and so on.

Conforming to
-------------

`GetTimeStamp' is an ISO 10206 Extended Pascal extension.

Example
-------

Set *Note TimeStamp::.

See also
--------

*Note TimeStamp::, *Note Date::, *Note Time::, *Note Date And Time
Routines::.


File: gpc.info,  Node: goto,  Next: GT,  Prev: GetTimeStamp,  Up: Reference

goto
====

(Under construction.)

Synopsis
--------

     goto LABEL

Description
-----------

The `goto' statement transfers control to statement with the label
`label'.

Conforming to
-------------

`goto' is defined in ISO 7185 Pascal and supported by all known Pascal
variants.

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: GT,  Next: GTPad,  Prev: goto,  Up: Reference

GT
==

(Under construction.)

Synopsis
--------

     function GT (S1, S2: String): Boolean;

Description
-----------

Conforming to
-------------

`GT' is an ISO 10206 Extended Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: GTPad,  Next: Halt,  Prev: GT,  Up: Reference

GTPad
=====

(Under construction.)

Synopsis
--------

     function GTPad (S1, S2: String): Boolean;

Description
-----------

Conforming to
-------------

`GTPad' is a GNU Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: Halt,  Next: High,  Prev: GTPad,  Up: Reference

Halt
====

Synopsis
--------

     Halt;
or
     Halt (ExitCode: Integer);

Description
-----------

`Halt' terminates the program with exitcode 0. If `ExitCode', is
specified, it is returned by `Halt' on exit.

Conforming to
-------------

`Halt' is an Extended Pascal and a UCSD Pascal extension.

Example
-------

     program HaltDemo;
     begin
       WriteLn ('This string will always be this program''s output.');
       Halt;  { Terminate right here and right now. }
       WriteLn ('And this string won''t ever!')
     end.

See also
--------

*Note Break::, *Note Continue::, *Note Exit::, *Note Return::, *Note
goto::.


File: gpc.info,  Node: High,  Next: if,  Prev: Halt,  Up: Reference

High
====

Synopsis
--------

     function High (ORDINAL_TYPE_OR_VARIABLE): ORDINAL_TYPE;
or
     function High (ARRAY_TYPE_OR_VARIABLE): ARRAY_INDEX_TYPE;
   or
     function High (STRING_VARIABLE): Integer;

Description
-----------

For ordinal types or variables of that type, `High' returns the highest
value a variable of that type can assume.

   For array types or variables of that type, `High' returns the
highest index a variable of that type can assume. Note: the result is of
the same type as the array index is. If the array has more than one
dimension, `High' returns the highest index in the first dimension.

   If the argument is a string variable, `High' returns the
discriminant of the string type (i.e. its capacity).

Conforming to
-------------

`High' is a Borland Pascal extension.

Example
-------

     program HighDemo;
     type
       Colors = (Red, Green, Blue);
     var
       Col: array [Colors] of (Love, Hope, Faithfulness);
       Foo: Colors;
       Bar: Integer;
       Baz: String (123);
     begin
       Foo := High (Col);             { yields Blue }
       Bar := Ord (High (Col[Foo]));  { yields Ord (Faithfulness), i.e., 2 }
       Bar := High (Integer);         { highest possible value of `Integer' }
       Bar := High (Baz)              { returns 123 }
     end.

See also
--------

*Note Low::


File: gpc.info,  Node: if,  Next: Im,  Prev: High,  Up: Reference

if
==

Synopsis
--------

     if BOOLEAN_EXPRESSION then
       STATEMENT
or with an alternative statement:
     if BOOLEAN_EXPRESSION then
       STATEMENT1
     else
       STATEMENT2

Description
-----------

The `if ... then' statement executes STATEMENT1 depending on `Boolean
expression' being true. If `else' is specified, it continues executing
STATEMENT2 instead.

Conforming to
-------------

`if' is defined in ISO 7185 Pascal and supported by all known Pascal
variants.

Example
-------

     program IfDemo;
     var
       Foo, Bar: Boolean;
     begin
       Foo := True;
       Bar := False;
       if ((1 = 1) or (2 = 3)) and (Foo = not Bar) then
         begin
           { This is executed if either Foo is true but not Bar or vice versa }
           WriteLn ('Either Foo or Bar is true.');
           if Bar then
             WriteLn ('You will see this text if Bar is true.')
         end
       else  { This whole `else' branch is not executed }
         if 1 = 1 then
           if True = False then
             WriteLn ('This text is never written on screen.')
           else  { Note: This ``else'' belongs to ``if True = False'' }
             WriteLn ('This text is never written on screen as well.')
         else  { Note: This ``else'' belongs to ``if 1 = 1'' }
           WriteLn ('Nor is this.')
     end.

See also
--------

*Note Keywords::, *Note if Statement::, *Note else::, *Note then::


File: gpc.info,  Node: Im,  Next: implementation,  Prev: if,  Up: Reference

Im
==

Synopsis
--------

     function Im (z: Complex): Real;

Description
-----------

`Im' extracts the imaginary part of the complex number `z'.  The result
is a real value.

Conforming to
-------------

`Im' is an ISO 10206 Extended Pascal extension.

Example
-------

     program ImDemo;
     var
       z: Complex;
     begin
       z := Cmplx (1, 2);  { 1 + i * 2 }
       WriteLn (Im (z) : 0 : 5)  { 2.00000 }
     end.

See also
--------

*Note Cmplx::, *Note Re::, *Note Arg::.


File: gpc.info,  Node: implementation,  Next: import,  Prev: Im,  Up: Reference

implementation
==============

(Under construction.)

Synopsis
--------

Description
-----------

Module or unit implementation part.

Conforming to
-------------

`implementation' is an Extended Pascal and a UCSD Pascal extension.

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: import,  Next: in,  Prev: implementation,  Up: Reference

import
======

Synopsis
--------

     program @@fragment foo;

     import
       bar1;
       bar3 (baz1 => glork1) in 'baz.pas';
       bar2 only (baz2, baz3 => glork2);
       bar4 qualified;

     [...]

   In module:

     module @@fragment Bar;

     import
       bar1;
       bar3 (baz1 => glork1) in 'baz.pas';
       bar2 only (baz2, baz3 => glork2);
       bar4 qualified;

     [...]

Description
-----------

The reserved word `import' in the _import part_ of a program makes the
program import an interface.

   The `in' above tells GPC to look for the module in the specified
file; otherwise the file name is derived from the name of the interface
by adding first `.p', then `.pas' - which only works if the name of the
exported interface coincides with the file name.

   The symbol `=>' denotes import renaming: The entity which is
exported under the name `baz1' by the interface `bar3' will be known
under the new name `glork1' in the program.

   The `only' qualifier means that only the listed identifiers will be
imported from the interface. Renaming works together with `only', too.

   The `qualified' qualifier means "qualified import": The imported
identifiers will be accessible only trough a "qualified name". The
entity which is exported under the name `baz2' by the interface `bar4'
will be accessible as `bar4.baz2'.

   There must be at most one import part at the begining of a block.
Each module or function/procedure (and also main program) can have its
own import part. A single import part can import arbitrarly many
interfaces.

   The interfaces needn't be exported by Extended Pascal modules but
may be UCSD/Borland Pascal units as well. GPC also allows `import'
parts in units.

Conforming to
-------------

`import' and modules in general are an ISO 10206 Extended Pascal
extension.

Example
-------

See also
--------

*Note Keywords::, *Note module::, *Note unit::, *Note uses::.


File: gpc.info,  Node: in,  Next: Inc,  Prev: import,  Up: Reference

in
==

Synopsis
--------

As part of the `set' membership test, as a boolean expression:
     ORDINAL_VALUE in SET_EXPRESSION
   or, as part of a `for' loop iterating through a set:
     for ORDINAL_VARIABLE in SET_EXPRESSION do ...

Description
-----------

When `in' is used as a membership test, it acts as a binary operator
taking ORDINAL_VALUE as its left parameter and SET_EXPRESSION as its
right parameter and returning a boolean result which is true if
SET_EXPRESSION contains the element ORDINAL_VALUE.

   When `in' is used as part of a `for' loop, it iterates
ORDINAL_VARIABLE over the elements contained in SET_EXPRESSION, that is
every ORDINAL_VALUE that would return true if tested as `ORDINAL_VALUE
in SET_EXPRESSION'.

Conforming to
-------------

`in' is defined in ISO 7185 Pascal and supported by all known Pascal
variants.

Example
-------

Set *Note set::

See also
--------

*Note Keywords::, *Note Set Operations::, *Note set::, *Note Exclude::,
*Note Include::, *Note for::.


File: gpc.info,  Node: Inc,  Next: Include,  Prev: in,  Up: Reference

Inc
===

Synopsis
--------

For ordinal types:
     procedure Inc (var x: ORDINAL_TYPE);
   or
     procedure Inc (var x: ORDINAL_TYPE; Amount: AND_INTEGER_TYPE);

   For pointer types:
     procedure Inc (var p: ANY_POINTER_TYPE);
   or
     procedure Inc (var p: ANY_POINTER_TYPE; Amount: AND_INTEGER_TYPE);

Description
-----------

For ordinal types, `inc' increases the value of `x' by one or by
`amount' if it is given.

   If the argument `p' is pointing to a specified type (typed pointer),
`inc' increases the address of `p' by the size of the type `p' is
pointing to or by `amount' times that size respectively. If `p' is an
untyped pointer (i.e. `p' is of type *Note Pointer::), `p' is increased
by one.

Conforming to
-------------

`Inc' is a Borland Pascal extension.  Yet application of `Inc' to
pointers is defined in Borland Pascal.  The combination of the second
argument with application to pointers is a GNU Pascal extension.

Example
-------

     program IncDemo;
     var
       Foo: Integer;
       Bar: array [1 .. 5] of Integer;
       Baz: ^Integer;
     begin
       Foo := 4;
       Inc (Foo, 5);      { yields 9 }
       {$X+}            { Turn on extended systax }
       Baz := @Bar[1];   { Baz points to y[1] }
       Inc (Baz, 2);      { Baz points to y[3] }
     end.

See also
--------

*Note Dec::, *Note Pred::, *Note Succ::, *Note Pointer Arithmetics::.


File: gpc.info,  Node: Include,  Next: Index,  Prev: Inc,  Up: Reference

Include
=======

Synopsis
--------

     Include (SET_VARIABLE, ORDINAL_VALUE);

Description
-----------

Add (join) a single element to a set. ORDINAL_VALUE must be compatible
with the base type of SET_VARIABLE.  Include is equivalent to:

     SET_VARIABLE := SET_VARIABLE + [ORDINAL_VALUE];

   If SET_VARIABLE already contains ORDINAL_VALUE, nothing happens.

Conforming to
-------------

`Include' is a Borland Pascal extension.

Example
-------

     program IncludeDemo;

     var
       Ch: Char;
       MyCharSet: set of Char;

     begin
       MyCharSet := ['P', 'N', 'L'];
       Include (MyCharSet , 'A')  { A, L, N, P }
     end.

   See other examples in *Note set:: and *Note Set Operations::.

See also
--------

*Note Keywords::, *Note Set Operations::, *Note set::, *Note in::,
*Note Exclude::.


File: gpc.info,  Node: Index,  Next: inherited,  Prev: Include,  Up: Reference

Index
=====

(Under construction.)

Synopsis
--------

Description
-----------

Conforming to
-------------

`Index' is an ISO 10206 Extended Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: inherited,  Next: initialization,  Prev: Index,  Up: Reference

inherited
=========

(Under construction.)

Synopsis
--------

Description
-----------

Reference to methods of ancestor object types.

Conforming to
-------------

`inherited' is an Object Pascal, Borland Pascal and traditional
Macintosh Pascal extension.

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: initialization,  Next: Initialize,  Prev: inherited,  Up: Reference

initialization
==============

(Under construction.)

Synopsis
--------

Description
-----------

Unit initialization.

   It is equivalent to Extended Pascal's `to begin do'.

Conforming to
-------------

`initialization' is a Borland Delphi extension.

Example
-------

See also
--------

*Note Keywords::, *Note finalization::, *Note to begin do::.


File: gpc.info,  Node: Initialize,  Next: InOutRes,  Prev: initialization,  Up: Reference

Initialize
==========

(Under construction.)

Synopsis
--------

     procedure Initialize (var Aynthing);

Description
-----------

`Initialize' does all necessary initializations for the parameter
(e.g., setting of string and schema discriminants, and object VMT
pointers, initialization of file variables). This is normally done
automatically at the start of the lifetime of a variable, so you need
to call `Initialize' only in special situations, e.g. when you allocate
a dynamic variable with `GetMem' rather than `New'.

Conforming to
-------------

`Initialize' is a Borland Delphi extension.

Example
-------

See also
--------

*Note Finalize::, *Note New::, *Note GetMem::.


File: gpc.info,  Node: InOutRes,  Next: Input,  Prev: Initialize,  Up: Reference

InOutRes
========

(Under construction.)

Synopsis
--------

     var
       InOutRes: Integer;

Description
-----------

Conforming to
-------------

`InOutRes' is a UCSD Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: Input,  Next: Insert,  Prev: InOutRes,  Up: Reference

Input
=====

(Under construction.)

Synopsis
--------

     var
       Input: Text;

Description
-----------

Conforming to
-------------

`Input' is defined in ISO 7185 Pascal and supported by all known Pascal
variants.

Example
-------

See also
--------


File: gpc.info,  Node: Insert,  Next: Int,  Prev: Input,  Up: Reference

Insert
======

(Under construction.)

Synopsis
--------

     procedure Insert (Source: String; var Dest: String; Position: Integer);

Description
-----------

Conforming to
-------------

`Insert' is a UCSD Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: Int,  Next: Integer,  Prev: Insert,  Up: Reference

Int
===

Synopsis
--------

     function Int (x: Real): Real;

Description
-----------

`Int' returns the integer part of a floating point number as a floating
point number. Use `Trunc' to get the integer part as an integer.

Conforming to
-------------

`Int' is a UCSD Pascal extension.

Example
-------

     program IntDemo;

     begin
       WriteLn (Frac (12.345) : 1 : 5);  { 0.34500 }
       WriteLn (Int (12.345) : 1 : 5);  { 12.00000 }
       WriteLn (Round (12.345) : 1);  { 12 }
       WriteLn (Trunc (12.345) : 1);  { 12 }

       WriteLn (Frac (-12.345) : 1 : 5);  { -0.34500 }
       WriteLn (Int (-12.345) : 1 : 5);  { -12.00000 }
       WriteLn (Round (-12.345) : 1);  { -12 }
       WriteLn (Trunc (-12.345) : 1);  { -12 }

       WriteLn (Frac (12.543) : 1 : 5);  { 0.54300 }
       WriteLn (Int (12.543) : 1 : 5);  { 12.00000 }
       WriteLn (Round (12.543) : 1);  { 13 }
       WriteLn (Trunc (12.543) : 1);  { 12 }

       WriteLn (Frac (-12.543) : 1 : 5);  { -0.54300 }
       WriteLn (Int (-12.543) : 1 : 5);  { -12.00000 }
       WriteLn (Round (-12.543) : 1);  { -13 }
       WriteLn (Trunc (-12.543) : 1);  { -12 }
     end.

See also
--------

*Note Real Types::, *Note Real::, *Note Frac::, *Note Round::, *Note
Trunc::.


File: gpc.info,  Node: Integer,  Next: interface,  Prev: Int,  Up: Reference

Integer
=======

Synopsis
--------

     type
       Integer  { built-in type }

Description
-----------

`Integer' is the "natural" signed integer type in GNU Pascal.  On some
platforms it is 32 bits wide and thus has a range of `-2147483648 ..
2147483647'. Use it whenever you need a general-purpose signed integer
type.

   There are lots of other integer types in GPC, see *Note Integer
Types::.

Conforming to
-------------

In ISO Pascal, `Integer' is the only built-in integer type.  (However
see *Note Subrange Types::.)

Example
-------

     program IntegerDemo;
     var
       a: Integer;
     begin
       a := 42;
       WriteLn (a)
     end.

See also
--------

*Note Integer Types::, *Note Subrange Types::.


File: gpc.info,  Node: interface,  Next: interrupt,  Prev: Integer,  Up: Reference

interface
=========

(Under construction.)

Synopsis
--------

Description
-----------

Module or unit interface part.

Conforming to
-------------

`interface' is an Extended Pascal and a UCSD Pascal extension.

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: interrupt,  Next: IOResult,  Prev: interface,  Up: Reference

interrupt
=========

Not yet implemented.

Synopsis
--------

Description
-----------

Interrupt handler declaration (not yet implemented).

Conforming to
-------------

`interrupt' is a Borland Pascal extension.

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: IOResult,  Next: is,  Prev: interrupt,  Up: Reference

IOResult
========

(Under construction.)

Synopsis
--------

     function IOResult: Integer;

Description
-----------

Conforming to
-------------

`IOResult' is a UCSD Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: is,  Next: label,  Prev: IOResult,  Up: Reference

is
==

Synopsis
--------

Description
-----------

Object type membership test.

Conforming to
-------------

`is' is an Object Pascal and a Borland Delphi extension.

Example
-------

See also
--------

*Note Keywords::, *Note as::, *Note TypeOf::, *Note OOP::.


File: gpc.info,  Node: label,  Next: LastPosition,  Prev: is,  Up: Reference

label
=====

(Under construction.)

Synopsis
--------

Description
-----------

Label declaration for a `goto' statement.

Conforming to
-------------

`label' is defined in ISO 7185 Pascal and supported by all known Pascal
variants.

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: LastPosition,  Next: LE,  Prev: label,  Up: Reference

LastPosition
============

(Under construction.)

Synopsis
--------

     function LastPosition (var F: TYPED_FILE): INDEX_TYPE;

Description
-----------

Conforming to
-------------

`LastPosition' is an ISO 10206 Extended Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: LE,  Next: Leave,  Prev: LastPosition,  Up: Reference

LE
==

(Under construction.)

Synopsis
--------

     function LE (S1, S2: String): Boolean;

Description
-----------

Conforming to
-------------

`LE' is an ISO 10206 Extended Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: Leave,  Next: Length,  Prev: LE,  Up: Reference

Leave
=====

Synopsis
--------

     Leave  { simple statement }

Description
-----------

With `Leave' you can exit the body of the current loop instantly. It
can only be used within a `while', `repeat' or a `for' loop.

Conforming to
-------------

`Leave' is a Mac Pascal extension. Borland Pascal has `Break' instead.

Example
-------

     program LeaveDemo;
     var
       Foo: Integer;
     begin
       while True do
         begin
           repeat
             WriteLn ('Enter a number less than 100:');
             ReadLn (Foo);
             if Foo < 100 then
               Leave;  { Exits `repeat' loop }
             WriteLn (Foo, ' is not exactly less than 100! Try again ...')
           until False;
           if Foo > 50 then
             Leave;  { Exits `while' loop }
           WriteLn ('The number entered was not greater than 50.')
         end
     end.

See also
--------

*Note Loop Control Statements::, *Note Break::, *Note Continue::, *Note
Cycle::, *Note Exit::, *Note Halt::, *Note Return::, *Note goto::.


File: gpc.info,  Node: Length,  Next: LEPad,  Prev: Leave,  Up: Reference

Length
======

(Under construction.)

Synopsis
--------

     function Length (S: String): Integer;

Description
-----------

Conforming to
-------------

`Length' is an Extended Pascal and a UCSD Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: LEPad,  Next: library,  Prev: Length,  Up: Reference

LEPad
=====

(Under construction.)

Synopsis
--------

     function LEPad (S1, S2: String): Boolean;

Description
-----------

Conforming to
-------------

`LEPad' is a GNU Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: library,  Next: Ln,  Prev: LEPad,  Up: Reference

library
=======

Not yet implemented.

Synopsis
--------

Description
-----------

Library declaration.

Conforming to
-------------

`library' is a Borland Pascal extension.

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: Ln,  Next: LoCase,  Prev: library,  Up: Reference

Ln
==

Synopsis
--------

     function Ln (x: Real): Real;
or
     function Ln (z: Complex): Complex;

Description
-----------

The natural logarith `Ln' is the logarithm with base e, where e is the
Euler number e = Exp (1) = 2.718281828...

Conforming to
-------------

The function `Ln' is defined in ISO 7185 Pascal; its application to
complex values is defined in ISO 10206 Extended Pascal.

Example
-------

     program LnDemo;
     var
       z: Complex;
     begin
       z := Cmplx (1, 1);
       z := Ln (z)  { yields Ln (SqRt (2)) + i * Pi / 4 }
                    { since Ln (i * x) = Ln Abs (x) + i * Arg (x) }
     end.

See also
--------


File: gpc.info,  Node: LoCase,  Next: LongBool,  Prev: Ln,  Up: Reference

LoCase
======

(Under construction.)

Synopsis
--------

     function LoCase (Ch: Char): Char;

Description
-----------

Conforming to
-------------

`LoCase' is a GNU Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: LongBool,  Next: LongCard,  Prev: LoCase,  Up: Reference

LongBool
========

Synopsis
--------

     type
       LongBool = Boolean attribute (Size = BitSizeOf (LongInt));

Description
-----------

The intrinsic `LongBool' represents boolean values, but occupies the
same memory space as a `LongInt'.  It is used when you need to define a
parameter or record that conforms to some external library or system
specification.

Conforming to
-------------

`LongBool' is a Borland Pascal extension.

Example
-------

     program LongBoolDemo;
     var
       a: LongBool;
     begin
       LongInt (a) := 1;
       if a then WriteLn ('Ord (True) = 1')
     end.

See also
--------

*Note Boolean (Intrinsic)::, *Note Boolean::, *Note True::, *Note
False::, *Note CBoolean::, *Note ByteBool::, *Note ShortBool::, *Note
MedBool::, *Note WordBool::, *Note LongestBool::.


File: gpc.info,  Node: LongCard,  Next: LongestBool,  Prev: LongBool,  Up: Reference

LongCard
========

Synopsis
--------

     type
       LongCard = Cardinal attribute (Size = BitSizeOf (LongInt));

Description
-----------

`LongCard' is an unsigned integer type which is longer than `Cardinal'.
On some platforms it is 64 bits wide and thus has a range of `0 ..
18446744073709551615'.

   `LongCard' in GNU Pascal is compatible to `long long unsigned int'
in GNU C.

   There are lots of other integer types in GPC, see *Note Integer
Types::.

Conforming to
-------------

`LongCard' is a GNU Pascal extension.

Example
-------

     program LongCardDemo;
     var
       a: LongCard;
     begin
       a := 42;
       WriteLn (a)
     end.

See also
--------

*Note Integer Types::, *Note Subrange Types::.


File: gpc.info,  Node: LongestBool,  Next: LongestCard,  Prev: LongCard,  Up: Reference

LongestBool
===========

Synopsis
--------

     type
       LongestBool = Boolean attribute (Size = BitSizeOf (LongestInt));

Description
-----------

The intrinsic `LongestBool' represents boolean values, but occupies the
same memory space as a `LongestInt'.  It is used when you need to
define a parameter or record that conforms to some external library or
system specification.

Conforming to
-------------

`LongestBool' is a GNU Pascal extension.

Example
-------

     program LongestBoolDemo;
     var
       a: LongestBool;
     begin
       LongestInt (a) := 1;
       if a then WriteLn ('Ord (True) = 1')
     end.

See also
--------

*Note Boolean (Intrinsic)::, *Note Boolean::, *Note True::, *Note
False::, *Note CBoolean::, *Note ByteBool::, *Note ShortBool::, *Note
MedBool::, *Note WordBool::, *Note LongBool::.


File: gpc.info,  Node: LongestCard,  Next: LongestInt,  Prev: LongestBool,  Up: Reference

LongestCard
===========

Synopsis
--------

     type
       LongestCard = Cardinal attribute (Size = BitSizeOf (LongestInt));

Description
-----------

`LongestCard' is GPC's longest-possible unsigned integer type.
Currently, this is the same as *Note LongCard::.  On some platforms it
is 64 bits wide and thus has a range of `0 .. 18446744073709551615'.

   There are lots of other integer types in GPC, see *Note Integer
Types::.

Conforming to
-------------

`LongestCard' is a GNU Pascal extension.

Example
-------

     program LongestCardDemo;
     var
       a: LongestCard;
     begin
       a := 42;
       WriteLn (a)
     end.

See also
--------

*Note Integer Types::, *Note Subrange Types::.


File: gpc.info,  Node: LongestInt,  Next: LongestReal,  Prev: LongestCard,  Up: Reference

LongestInt
==========

Synopsis
--------

     type
       LongestInt = LongInt;  { might get bigger than LongInt someday }

Description
-----------

`LongestInt' is GPC's longest-possible signed integer type.  Currently,
this is the same as *Note LongInt::. On some platforms it is 64 bits
wide and thus has a range of `-9223372036854775808 ..
9223372036854775807'.

   There are lots of other integer types in GPC, see *Note Integer
Types::.

Conforming to
-------------

`LongestInt' is a GNU Pascal extension.

Example
-------

     program LongestIntDemo;
     var
       a: LongestInt;
     begin
       a := 42;
       WriteLn (a)
     end.

See also
--------

*Note Integer Types::, *Note Subrange Types::.


File: gpc.info,  Node: LongestReal,  Next: LongestWord,  Prev: LongestInt,  Up: Reference

LongestReal
===========

(Under construction.)

Synopsis
--------

     type
       LongestReal = LongReal;  { might get bigger than LongReal someday }

Description
-----------

Conforming to
-------------

`LongestReal' is a GNU Pascal extension.

Example
-------

     program LongestRealDemo;
     var
       a: LongestReal;
     begin
       a := 42;
       WriteLn (a)
     end.

See also
--------


File: gpc.info,  Node: LongestWord,  Next: LongInt,  Prev: LongestReal,  Up: Reference

LongestWord
===========

Synopsis
--------

     type
       LongestWord = LongestCard;

Description
-----------

`LongestWord' is GPC's longest-possible unsigned integer type.
Currently, this is the same as *Note LongWord::. On some platforms it
is 64 bits wide and thus has a range of `0 ..  18446744073709551615'.
(It is the same as *Note LongestCard::.)

   There are lots of other integer types in GPC, see *Note Integer
Types::.

Conforming to
-------------

`LongestWord' is a GNU Pascal extension.

Example
-------

     program LongestWordDemo;
     var
       a: LongestWord;
     begin
       a := 42;
       WriteLn (a)
     end.

See also
--------

*Note LongestCard::, *Note Integer Types::, *Note Subrange Types::.


File: gpc.info,  Node: LongInt,  Next: LongReal,  Prev: LongestWord,  Up: Reference

LongInt
=======

Synopsis
--------

     type
       LongInt  { built-in type }

Description
-----------

`LongInt' is a signed integer type which is longer than `Integer'. On
some platforms it is 64 bits wide and thus has a range of
`-9223372036854775808 .. 9223372036854775807'.

   `LongInt' in GNU Pascal is compatible to `long long int' in GNU C.

   There are lots of other integer types in GPC, see *Note Integer
Types::.

Conforming to
-------------

`LongInt' is a Borland Pascal extension. Borland Pascal defines
`LongInt' as a 32-bit signed integer type (*Note Integer:: in GNU
Pascal).

Example
-------

     program LongIntDemo;
     var
       a: LongInt;
     begin
       a := 42;
       WriteLn (a)
     end.

See also
--------

*Note Integer Types::, *Note Subrange Types::.


File: gpc.info,  Node: LongReal,  Next: LongWord,  Prev: LongInt,  Up: Reference

LongReal
========

(Under construction.)

Synopsis
--------

     type
       LongReal  { built-in type }

Description
-----------

Conforming to
-------------

`LongReal' is a GNU Pascal extension.

Example
-------

     program LongRealDemo;
     var
       a: LongReal;
     begin
       a := 42;
       WriteLn (a)
     end.

See also
--------


File: gpc.info,  Node: LongWord,  Next: Low,  Prev: LongReal,  Up: Reference

LongWord
========

Synopsis
--------

     type
       LongWord = LongCard;

Description
-----------

`LongWord' is an unsigned integer type which is larger than `Word'. On
some platforms it is 64 bits wide and thus has a range of `0 ..
18446744073709551615'. It is the same as *Note LongCard::.

   `LongWord' in GNU Pascal is compatible to `long long unsigned int'
in GNU C.

   There are lots of other integer types in GPC, see *Note Integer
Types::.

Conforming to
-------------

`LongWord' is a GNU Pascal extension.

Example
-------

     program LongWordDemo;
     var
       a: LongWord;
     begin
       a := 42;
       WriteLn (a)
     end.

See also
--------

*Note LongCard::, *Note Integer Types::, *Note Subrange Types::.


File: gpc.info,  Node: Low,  Next: LT,  Prev: LongWord,  Up: Reference

Low
===

Synopsis
--------

     function Low (ORDINAL_TYPE_OR_VARIABLE): ORDINAL_TYPE;
or
     function Low (ARRAY_TYPE_OR_VARIABLE): ARRAY_ELEMENT_TYPE;
   or
     function Low (STRING_VARIABLE): Integer;

Description
-----------

For ordinal types or variables of that type, `Low' returns the lowest
value a variable of that type can assume.

   For array types or variables of that type, `Low' returns the lowest
index a variable of that type can assume. Note: the result is of the
same type as the array index is. If the array has more than one
dimension, `Low' returns the lowest index in the first dimension.

   If the argument is a string variable, `Low' returns one.

Conforming to
-------------

`Low' is a Borland Pascal extension.

Example
-------

     program LowDemo;
     type
       Colors = (Red, Green, Blue);
     var
       Col: array [12 .. 20] of Colors;
       Foo: 12 .. 20;
       Bar: Integer;
     begin
       Foo := Low (Col);            { returns 12 }
       Col[Foo] := Low (Col[Foo]);  { returns Red }
       Bar := Low (Integer)         { lowest possible value of `Integer' }
     end.

See also
--------

*Note High::


File: gpc.info,  Node: LT,  Next: LTPad,  Prev: Low,  Up: Reference

LT
==

(Under construction.)

Synopsis
--------

     function LT (S1, S2: String): Boolean;

Description
-----------

Conforming to
-------------

`LT' is an ISO 10206 Extended Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: LTPad,  Next: Mark,  Prev: LT,  Up: Reference

LTPad
=====

(Under construction.)

Synopsis
--------

     function LTPad (S1, S2: String): Boolean;

Description
-----------

Conforming to
-------------

`LTPad' is a GNU Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: Mark,  Next: Max,  Prev: LTPad,  Up: Reference

Mark
====

(Under construction.)

Synopsis
--------

     procedure Mark (var P: Pointer);

Description
-----------

Conforming to
-------------

`Mark' is a UCSD Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: Max,  Next: MaxChar,  Prev: Mark,  Up: Reference

Max
===

(Under construction.)

Synopsis
--------

     function Max (x1, x2: ORDINAL_OR_REAL_TYPE): SAME_TYPE;

Description
-----------

Conforming to
-------------

`Max' is a GNU Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: MaxChar,  Next: MaxInt,  Prev: Max,  Up: Reference

MaxChar
=======

(Under construction.)

Synopsis
--------

Description
-----------

The value of `MaxChar' is the largest value of `Char'.

Conforming to
-------------

`MaxChar' is an ISO 10206 Extended Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: MaxInt,  Next: MaxReal,  Prev: MaxChar,  Up: Reference

MaxInt
======

(Under construction.)

Synopsis
--------

Description
-----------

The `MaxInt' constant defines the maximum value of `Integer'. This
constant is a built-in compiler value.

Conforming to
-------------

`MaxInt' is defined in ISO 7185 Pascal and supported by all known
Pascal variants.

Example
-------

See also
--------


File: gpc.info,  Node: MaxReal,  Next: MedBool,  Prev: MaxInt,  Up: Reference

MaxReal
=======

(Under construction.)

Synopsis
--------

Description
-----------

Conforming to
-------------

`MaxReal' is an ISO 10206 Extended Pascal extension.

Example
-------

See also
--------

*Note MinReal::.


File: gpc.info,  Node: MedBool,  Next: MedCard,  Prev: MaxReal,  Up: Reference

MedBool
=======

Synopsis
--------

     type
       MedBool = Boolean attribute (Size = BitSizeOf (MedInt));

Description
-----------

The intrinsic `MedBool' represents boolean values, but occupies the
same memory space as a `MedInt'.  It is used when you need to define a
parameter or record that conforms to some external library or system
specification.

Conforming to
-------------

`MedBool' is a GNU Pascal extension.

Example
-------

     program MedBoolDemo;
     var
       a: MedBool;
     begin
       MedInt (a) := 1;
       if a then WriteLn ('Ord (True) = 1')
     end.

See also
--------

*Note Boolean (Intrinsic)::, *Note Boolean::, *Note True::, *Note
False::, *Note CBoolean::, *Note ByteBool::, *Note ShortBool::, *Note
WordBool::, *Note LongBool::, *Note LongestBool::.


File: gpc.info,  Node: MedCard,  Next: MedInt,  Prev: MedBool,  Up: Reference

MedCard
=======

Synopsis
--------

     type
       MedCard = Cardinal attribute (Size = BitSizeOf (MedInt));

Description
-----------

`MedCard' is an unsigned integer type which is not smaller than
`Cardinal'. On some platforms it actually is the same as `Cardinal' and
32 bits wide and thus has a range of `0 .. 4294967295'.

   `MedCard' in GNU Pascal is compatible to `long unsigned int' in GNU
C. This compatibility is the reason why `MedCard' exists.

   There are lots of other integer types in GPC, see *Note Integer
Types::.

Conforming to
-------------

`MedCard' is a GNU Pascal extension.

Example
-------

     program MedCardDemo;
     var
       a: MedCard;
     begin
       a := 42;
       WriteLn (a)
     end.

See also
--------

*Note Integer Types::, *Note Subrange Types::.


File: gpc.info,  Node: MedInt,  Next: MedReal,  Prev: MedCard,  Up: Reference

MedInt
======

Synopsis
--------

     type
       MedInt  { built-in type }

Description
-----------

`MedInt' is a signed integer type which is not smaller than `Integer'.
On some platforms it actually is the same as `Integer' and 32 bits wide
and thus has a range of `-2147483648 .. 2147483647'.

   `MedInt' in GNU Pascal is compatible to `long int' in GNU C. This
compatibility is the reason why `MedInt' exists.

   There are lots of other integer types in GPC, see *Note Integer
Types::.

Conforming to
-------------

`MedInt' is a GNU Pascal extension.

Example
-------

     program MedIntDemo;
     var
       a: MedInt;
     begin
       a := 42;
       WriteLn (a)
     end.

See also
--------

*Note Integer Types::, *Note Subrange Types::.


File: gpc.info,  Node: MedReal,  Next: MedWord,  Prev: MedInt,  Up: Reference

MedReal
=======

(Under construction.)

Synopsis
--------

     type
       MedReal = Real;

Description
-----------

Conforming to
-------------

`MedReal' is a GNU Pascal extension.

Example
-------

     program MedRealDemo;
     var
       a: MedReal;
     begin
       a := 42;
       WriteLn (a)
     end.

See also
--------


File: gpc.info,  Node: MedWord,  Next: Min,  Prev: MedReal,  Up: Reference

MedWord
=======

Synopsis
--------

     type
       MedWord = MedCard;

Description
-----------

`MedWord' is an unsigned integer type which is not smaller than `Word'.
On some platforms it actually is the same as `Word' and 32 bits wide
and thus has a range of `0 .. 4294967295'. It is the same as *Note
MedCard::.

   `MedWord' in GNU Pascal is compatible to `long unsigned int' in GNU
C. This compatibility is the reason why `MedWord' exists.

   There are lots of other integer types in GPC, see *Note Integer
Types::.

Conforming to
-------------

`MedWord' is a GNU Pascal extension.

Example
-------

     program MedWordDemo;
     var
       a: MedWord;
     begin
       a := 42;
       WriteLn (a)
     end.

See also
--------

*Note MedCard::, *Note Integer Types::, *Note Subrange Types::.


File: gpc.info,  Node: Min,  Next: MinReal,  Prev: MedWord,  Up: Reference

Min
===

(Under construction.)

Synopsis
--------

     function Min (x1, x2: ORDINAL_OR_REAL_TYPE): SAME_TYPE;

Description
-----------

Conforming to
-------------

`Min' is a GNU Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: MinReal,  Next: MkDir,  Prev: Min,  Up: Reference

MinReal
=======

(Under construction.)

Synopsis
--------

Description
-----------

Conforming to
-------------

`MinReal' is an ISO 10206 Extended Pascal extension.

Example
-------

See also
--------

*Note MaxReal::.


File: gpc.info,  Node: MkDir,  Next: mod,  Prev: MinReal,  Up: Reference

MkDir
=====

Synopsis
--------

     procedure MkDir (Directory: String);

Description
-----------

`MkDir' creates the given DIRECTORY, if its argument is a valid
parameter to the related operating system's function.  Otherwise a
runtime error is caused.

Conforming to
-------------

`MkDir' is a Borland Pascal extension.

Example
-------

     program MkDirDemo;
     var
       Foo: String (127);
     begin
       WriteLn ('Enter directory name to create:');
       ReadLn (Foo);
       {$I-}  { Don't abort program on error }
       MkDir (Foo);
       if IOResult <> 0 then
         WriteLn ('Directory `', Foo, ''' could not be created')
       else
         WriteLn ('Okay')
     end.

See also
--------

*Note ChDir::, *Note RmDir::


File: gpc.info,  Node: mod,  Next: module,  Prev: MkDir,  Up: Reference

mod
===

(Under construction.)

Synopsis
--------

     operator mod (p, q: Integer) = r: Integer;

Description
-----------

Integer remainder operator.

Conforming to
-------------

`mod' is defined in ISO 7185 Pascal and supported by all known Pascal
variants.

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: module,  Next: Move,  Prev: mod,  Up: Reference

module
======

(Under construction.)

Synopsis
--------

Description
-----------

EP style or PXSC style module.

Conforming to
-------------

`module' is an ISO 10206 Extended Pascal extension.

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: Move,  Next: MoveLeft,  Prev: module,  Up: Reference

Move
====

(Under construction.)

Synopsis
--------

     procedure Move (const Source; var Dest; Count: Integer);

Description
-----------

Conforming to
-------------

`Move' is a Borland Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: MoveLeft,  Next: MoveRight,  Prev: Move,  Up: Reference

MoveLeft
========

(Under construction.)

Synopsis
--------

     procedure MoveLeft (const Source; var Dest; Count: Integer);

Description
-----------

Conforming to
-------------

`MoveLeft' is a UCSD Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: MoveRight,  Next: name,  Prev: MoveLeft,  Up: Reference

MoveRight
=========

(Under construction.)

Synopsis
--------

     procedure MoveRight (const Source; var Dest; count: Integer);

Description
-----------

Conforming to
-------------

`MoveRight' is a UCSD Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: name,  Next: NE,  Prev: MoveRight,  Up: Reference

name
====

(Under construction.)

Synopsis
--------

PROCEDURE/FUNCTION_HEADER; external name NAME;

   PROCEDURE/FUNCTION_HEADER; attribute (name = NAME);

   or

   VARIABLE_DECLARATION; external name NAME;

   VARIABLE_DECLARATION; attribute (name = NAME);

   or

   unit NAME; attribute (name = NAME);

Description
-----------

The `name' directive declares the external name of a procedure,
function or variable. It can be used after `external' or within
`attribute'.

   This directive declares the external name of a procedure, function
or variable. The external name of the routine is given explicitly as a
case-sensitive constant string expression. This is useful when
interfacing with libraries written in other languages.

   With this extension it is possible to access all external functions,
for example the X11 interface functions, and not only those written in
lowercase.

   `name' can also be applied to units and module interfaces. In this
case it denotes the _prefix_ prepended to the external name of the
initializer of the unit: While it is normally called `init_Modulename',
it is called `init_NAME_Modulename' when `name' is given.

   This is not of interest under normal circumstances since the
initializers are called automatically. It can help avoiding conflicts
when there are several units of the same name within one program.
Again, this does not happen normally, but e.g., when a program uses a
unit/module that has the same name as one of the units the RTS consists
of: The RTS uses `GPC' as the name for its units to avoid conflicts.

   In the future, a `name' directive applied to units, modules and
programs (the latter is recognized syntactically already, but has no
effect yet) will also affect the default external name of routines and
variables which have no `name' directive themselves. Again, this is
mostly useful for libraries etc., and will not be necessary for normal
units, modules and programs.

Conforming to
-------------

`name' is a Borland Pascal extension. `attribute' and the application
of `name' to units, modules and programs are GNU Pascal extensions.

Example
-------

     program NameDemo;

     { Make two variables aliases of each other by using `name'.
       This is not good style. If you must have aliases for any reason,
       `absolute' declarations may be the lesser evil ... }
     var
       Foo: Integer; attribute (name = 'Foo_Bar');
       Bar: Integer; external name 'Foo_Bar';

     { A function from the C library }
     function PutS (Str: CString): Integer; external name 'puts';

     var
       Result: Integer;
     begin
       Result := PutS ('Hello World!');
       WriteLn ('puts wrote ', Result, ' characters (including a newline).');
       Foo := 42;
       WriteLn ('Foo = ', Foo);
       Bar := 17;
       WriteLn ('Setting Bar to 17.');
       WriteLn ('Now, Foo = ', Foo, '!!!')
     end.

See also
--------

*Note Keywords::, *Note attribute::, *Note external::, *Note Importing
Libraries from Other Languages::.


File: gpc.info,  Node: NE,  Next: near,  Prev: name,  Up: Reference

NE
==

(Under construction.)

Synopsis
--------

     function NE (S1, S2: String): Boolean;

Description
-----------

Conforming to
-------------

`NE' is an ISO 10206 Extended Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: near,  Next: NEPad,  Prev: NE,  Up: Reference

near
====

Synopsis
--------

Description
-----------

The `near' directive can be appended to a procedure or function heading
but is ignored by GPC. It is there for Borland compatibility, only.
(Since the GNU compilers provide a flat memory model, the distinction
between `near' and `far' pointers is void.)

Conforming to
-------------

`near' is a Borland Pascal extension.

Example
-------

     program NearDemo;

     var
       p: procedure;

     {$W no-near-far}  { Don't warn about the uselessness of `near' }

     procedure Foo; near;  { `near' has no effect in GPC }
     begin
       WriteLn ('Foo')
     end;

     begin
       p := Foo;  { Works, despite the `near'. }
       p
     end.

See also
--------

*Note Keywords::, *Note far::.


File: gpc.info,  Node: NEPad,  Next: New,  Prev: near,  Up: Reference

NEPad
=====

(Under construction.)

Synopsis
--------

     function NEPad (S1, S2: String): Boolean;

Description
-----------

Conforming to
-------------

`NEPad' is a GNU Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: New,  Next: NewCString,  Prev: NEPad,  Up: Reference

New
===

(Under construction.)

Synopsis
--------

     procedure New (var P: ANY_POINTER);
or
     procedure New (var P: POINTER_TO_A_VARIANT_RECORD; TAG_FIELDS);
   or
     procedure New (var P: POINTER_TO_A_SCHEMA; DISCRIMINANTS);
   or
     procedure New (var P: POINTER_TO_AN_OBJECT; CONSTRUCTOR_CALL);
   or
     function New (ANY_POINTER_TYPE): SAME_TYPE;
   or
     function New (VARIANT_RECORD_POINTER_TYPE;
                   TAG_FIELDS): SAME_TYPE;
   or
     function New (SCHEMA_POINTER_TYPE;
                   DISCRIMINANTS): SAME_TYPE;
   or
     function New (OBJECT_POINTER_TYPE;
                   CONSTRUCTOR_CALL): SAME_TYPE;

Description
-----------

Conforming to
-------------

`New' is defined in ISO 7185 Pascal and supported by all known Pascal
variants.

Example
-------

See also
--------


File: gpc.info,  Node: NewCString,  Next: nil,  Prev: New,  Up: Reference

NewCString
==========

(Under construction.)

Synopsis
--------

     function NewCString (const S: String): CString;

Description
-----------

Conforming to
-------------

`NewCString' is a GNU Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: nil,  Next: not,  Prev: NewCString,  Up: Reference

nil
===

Synopsis
--------

`nil' is a predefined constant

Description
-----------

`nil' is a predefined pointer constant that indicates an unassigned
pointer. "nil" stands for "not in list". _Every_ pointer type can be
associated with this constant.

Conforming to
-------------

`nil' is defined in ISO 7185 Pascal and supported by all known Pascal
variants.

Example
-------

     program NilDemo;
     const
       NodeNum = 10;
     type
       PNode = ^TNode;
       TNode = record
         Key: Integer;
         Next: PNode
       end;
     var
       Root, Node: PNode;
       Foo: Integer;
     begin
       New (Root);
       Root^.Key := 1;             { Set root key }
       Node := Root;
       for Foo := 2 to NodeNum do  { Create linked list with NODE_NUM nodes }
         begin
           New (Node^.Next);
           Node := Node^.Next;
           Node^.Key := Foo        { Set key }
         end;
       Node^.Next := nil;          { Mark end of linked list }
       { Shorten list by removing its first element until list is empty }
       while Root <> nil do
         begin
           Node := Root;
           WriteLn ('Current key:', Root^.Key);
           Root := Root^.Next;
           Dispose (Node);
           Node := nil             { Indicate old node is not assigned }
         end
     end.

See also
--------

*Note Keywords::, *Note Assigned::, *Note Pointer::


File: gpc.info,  Node: not,  Next: Null,  Prev: nil,  Up: Reference

not
===

(Under construction.)

Synopsis
--------

     operator not (b1, b2: Boolean) = Result: Boolean;
or
     operator not (i1, i2: INTEGER_TYPE) = Result: INTEGER_TYPE;

Description
-----------

Boolean or bitwise negation operator.

Conforming to
-------------

`not' is defined in ISO 7185 Pascal and supported by all known Pascal
variants.

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: Null,  Next: object,  Prev: not,  Up: Reference

Null
====

Synopsis
--------

     var
       Null: Void absolute 0;

Description
-----------

`Null' is a predefined variable at address `nil'.  `Null' can be passed
as a "void" argument to a procedure, function or operator expecting a
"var" parameter. _Note_: Make sure they can handle this case, otherwise
this is likely to cause an exception and the program will be
terminated. Since `Null' is an L-value, it can be taken as
"nil-reference".

Conforming to
-------------

`Null' is a Borland Delphi extension.

Example
-------

     program NullDemo;
     type
       PString = ^String;
     var
       Com1: String (25) = 'This is an amazing number';
       Com2: String (25) = 'This is a boring number';

     procedure FooBar (Foo: Integer; var Comment: PString);
     begin
       if Odd (Foo) then
         WriteLn ('FooBar:', Foo, ' is odd')
        else
         WriteLn ('FooBar:', Foo, ' is even');
       if @Comment <> nil then
         if not Odd (Foo) then
           Comment := @Com1
         else
           Comment := @Com2
     end;

     var
       S: String (25);
       P: PString value @S;

     begin
       { FooBar allows you to leave out variables
         for any information you might not need }
       FooBar (1, Null);
       { But FooBar is flexible, after all }
       FooBar (6, P);
       WriteLn ('FooBar said about 6: `', P^, '''')
     end.

See also
--------

*Note nil::


File: gpc.info,  Node: object,  Next: Odd,  Prev: Null,  Up: Reference

object
======

Synopsis
--------

Description
-----------

The keyword `object' is used to declare a new object type:

     type
       foo = object
         a: Integer;
         constructor Init;
         procedure Bar (x: Integer); virtual;
       end;

   (For a longer example, see *Note OOP::.)

Conforming to
-------------

GNU Pascal follows the Borland Pascal 7.0 object model.

   ISO Pascal does not support Object-oriented programming. There is an
ANSI draft for an "Object Pascal" language which is not yet supported
by GPC, but planned. The Delphi language, also called "Object Pascal"
by Borland, is currently not supported by GPC either.

Example
-------

See also
--------

*Note Keywords::, *Note OOP::, *Note record::.


File: gpc.info,  Node: Odd,  Next: of,  Prev: object,  Up: Reference

Odd
===

Synopsis
--------

     function Odd (i: Integer): Boolean;

Description
-----------

`Odd' checks the parity of its argument `i'. It returns `True' if the
argument is odd, `False' if it is even.

Conforming to
-------------

`Odd' is defined in ISO 7185 Pascal and supported by all known Pascal
variants.

Example
-------

     program OddDemo;
     var
       Foo: Integer;
     begin
       Write ('Please enter an odd number: ');
       ReadLn (Foo);
       if not Odd (Foo) then
         WriteLn ('Odd''s not even! Something''s odd out there ...')
       else
         WriteLn (Foo, ' is pretty odd.')
     end.

See also
--------


File: gpc.info,  Node: of,  Next: on,  Prev: Odd,  Up: Reference

of
==

(Under construction.)

Synopsis
--------

Description
-----------

Part of an `array', `set' or typed `file' type declaration, a `case'
statement, a variant `record' type or a `type of' type inquiry.

Conforming to
-------------

`of' is defined in ISO 7185 Pascal and supported by all known Pascal
variants.

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: on,  Next: only,  Prev: of,  Up: Reference

on
==

Not yet implemented.

Synopsis
--------

Conforming to
-------------

`on' is a Borland Delphi extension.

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: only,  Next: operator,  Prev: on,  Up: Reference

only
====

(Under construction.)

Synopsis
--------

Description
-----------

Import specification.

Conforming to
-------------

`only' is an ISO 10206 Extended Pascal extension.

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: operator,  Next: or,  Prev: only,  Up: Reference

operator
========

(Under construction.)

Synopsis
--------

Description
-----------

Operator declaration.

Conforming to
-------------

`operator' is PASCAL_SC extension.

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: or,  Next: Ord,  Prev: operator,  Up: Reference

or
==

Synopsis
--------

     operator or (operand1, operand2: Boolean) = Result: Boolean;
or
     operator or (operand1, operand2: INTEGER_TYPE) = Result: INTEGER_TYPE;
   or
     procedure or (var operand1: INTEGER_TYPE; operand2: INTEGER_TYPE);

Description
-----------

In GNU Pascal, `or' has three built-in meanings:

  1. Logical "or" between two `Boolean'-type expressions.  The result
     of the operation is of `Boolean' type.

     By default, `or' acts as a short-circuit operator in GPC: If the
     first operand is `True', the second operand is not evaluated
     because the result is already known to be `True'. You can change
     this to complete evaluation using the `--no-short-circuit'
     command-line option or the `{$B+}' compiler directive.

  2. Bitwise "or" between two integer-type expressions.  The result is
     of the common integer type of both expressions.

  3. Use as a "procedure": `operand1' is "or"ed bitwise with
     `operand2'; the result is stored in `operand1'.


Conforming to
-------------

The logical `or' operator is defined in ISO 7185 Pascal.

   According to ISO, you cannot rely on `or' being a short-circuit
operator. On the other hand, GPC's default behaviour does _not_
contradict the ISO standard. (See *Note or_else::.) However, since it
seems to be a de-facto standard among ISO Pascal compilers to evaluate
both operands of `or', GPC switches to `--no-short-circuit' mode if one
of the language dialect options selecting ISO Pascal, for instance
`--extended-pascal', is given. Use `--short-circuit' to override.

   Use of `or' as a bitwise operator for integers is a Borland Pascal
extension.

   Use of `or' as a "procedure" is a GNU Pascal extension.

Example
-------

     program OrDemo;
     var
       a, b, c: Integer;
     begin
       if (a = 0) or (b = 0) then  { logical `or' }
         c := 1
       else if (a or b) = 0 then  { bitwise `or' }
         c := 2
       else
         or (c, a)  { same as `c := c or a' }
     end.

   Note the difference between the logical `or' and the bitwise `or':
When `a' is 2 and `b' is 4, then `a or b' is 6. *Beware:* `a or b = 0'
happens to mean the same as `(a = 0) and (b = 0)'. (Note the `and'!)

   Since bitwise `or' has a higher priority than the `=' operator,
parentheses are needed in `if (a = 0) or (b = 0)' because otherwise `0
or b' would be calculated first, and the remainder would cause a parse
error.

See also
--------

*Note Keywords::, *Note and::, *Note xor::, *Note Operators::.


File: gpc.info,  Node: Ord,  Next: or else,  Prev: or,  Up: Reference

Ord
===

Synopsis
--------

     function Ord (ORDINAL_VALUE): Integer;

Description
-----------

`Ord' returns the ordinal value of any ordinal variable or constant.
For characters, this would be the ASCII code corresponding to the
character. For enumerated types, this would be the ordinal value of the
constant or variable (remember that ordinal value of enumerated
constants start from zero).

Conforming to
-------------

`Ord' is defined in ISO 7185 Pascal and supported by all known Pascal
variants.

Example
-------

     program OrdDemo;
     var
       Ch: Char;
       Day: (Monday, Tuesday, Wednesday, Thursday, Friday);
     begin
       Ch := 'A';
       WriteLn (Ord (Ch));  { 65 }
       Day := Thursday;
       WriteLn (Ord (Day));  { 3 }
     end.

See also
--------

*Note Character Types::, *Note Ordinal Types::, *Note Chr::, *Note
Char::


File: gpc.info,  Node: or else,  Next: or_else,  Prev: Ord,  Up: Reference

or else
=======

Synopsis
--------

     { `or else' is built in. A user-defined operator cannot consist of
        two words. }
     operator or else (operand1, operand2: Boolean) = Result: Boolean;

Description
-----------

`or else' is an alias for the short-circuit logical operator `or_else'.

Conforming to
-------------

While `or_else' is defined in ISO 10206 Extended Pascal, `or else' is a
GNU Pascal extension.

Example
-------

     program OrElseDemo;
     var
       a: Integer;
     begin
       ReadLn (a);
       if (a = 0) or else (100 div a > 42) then  { This is safe. }
         WriteLn ('100 div a > 42')
     end.

See also
--------

*Note Keywords::, *Note or_else::, *Note or::, *Note and then::.


File: gpc.info,  Node: or_else,  Next: otherwise,  Prev: or else,  Up: Reference

or_else
=======

Synopsis
--------

     operator or_else (operand1, operand2: Boolean) = Result: Boolean;

Description
-----------

The `or_else' short-circuit logical operator performs the same
operation as the logical operator `or'. But while the ISO standard does
not specify anything about the evaluation of the operands of `or' -
they may be evaluated in any order, or not at all - `or_else' has a
well-defined behaviour: It evaluates the first operand. If the result
is `True', `or_else' returns `True' without evaluating the second
operand. If it is `False', the second operand is evaluated and returned.

   GPC by default treats `or' and `or_else' exactly the same.  If you
want, for some reason, to have both operands of `or' evaluated
completely, you must assign both to temporary variables and then use
`or' - or `or_else', it does not matter.

Conforming to
-------------

`or_else' is an ISO 10206 Extended Pascal extension.

   Some people think that the ISO standard requires both operands of
`or' to be evaluated. This is false. What the ISO standard _does_ say
is that you cannot rely on a certain order of evaluation of the
operands of `or'; in particular things like the following program can
crash according to ISO Pascal, although they cannot crash when compiled
with GNU Pascal running in default mode.

     program OrBug;
     var
       a: Integer;
     begin
       ReadLn (a);
       if (a = 0) or (100 div a > 42) then  { This is *not* safe! }
         WriteLn ('You''re lucky. But the test could have crashed ...')
     end.

Example
-------

     program Or_ElseDemo;
     var
       a: Integer;
     begin
       ReadLn (a);
       if (a = 0) or_else (100 div a > 42) then  { This is safe. }
         WriteLn ('100 div a > 42')
     end.

See also
--------

*Note Keywords::, *Note or else::, *Note or::, *Note and_then::.


File: gpc.info,  Node: otherwise,  Next: Output,  Prev: or_else,  Up: Reference

otherwise
=========

Synopsis
--------

Default `case' branch as part of the `case' ...  `otherwise' statement:
     case EXPRESSION of
       SELECTOR: STATEMENT;
       ...
       SELECTOR: STATEMENT
     otherwise  { ``else'' instead of ``otherwise'' is allowed }
       STATEMENT;
       ...
       STATEMENT
     end

   Use in a structured value of `array' type:
     [INDEX1: VALUE1; INDEX2: VALUE2
      otherwise VALUE_OTHERWISE]

Description
-----------

`otherwise' starts a series of statements which is executed if no
selector matches EXPRESSION. In this situation, `else' is a synonym for
`otherwise'.

   `otherwise' also defines the default value in an Extended Pascal
structured values of array type.

Conforming to
-------------

`otherwise' is an ISO 10206 Extended Pascal extension.

Example
-------

     program OtherwiseDemo;

     var
       i: Integer;
       a: array [1 .. 10] of Integer value [1: 2; 4: 5 otherwise 3];

     begin
       for i := 1 to 10 do
         case a[i] of
           2:        WriteLn ('a[', i, '] has value two.');
           3:        WriteLn ('a[', i, '] has value three.');
           otherwise WriteLn ('a[', i, '] has neither value two nor three.')
         end
     end.

See also
--------

*Note Keywords::, *Note case Statement::, *Note case::, *Note else::.


File: gpc.info,  Node: Output,  Next: overload,  Prev: otherwise,  Up: Reference

Output
======

(Under construction.)

Synopsis
--------

     var
       Output: Text;

Description
-----------

Conforming to
-------------

`Output' is defined in ISO 7185 Pascal and supported by all known
Pascal variants.

Example
-------

See also
--------


File: gpc.info,  Node: overload,  Next: override,  Prev: Output,  Up: Reference

overload
========

Not yet implemented.

Synopsis
--------

Conforming to
-------------

`overload' is a Borland Delphi extension.

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: override,  Next: Pack,  Prev: overload,  Up: Reference

override
========

(Under construction.)

Synopsis
--------

Description
-----------

Conforming to
-------------

`override' directive is defined in OOE draft and supported by Delphi
and Mac Pascal

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: Pack,  Next: packed,  Prev: override,  Up: Reference

Pack
====

(Under construction.)

Synopsis
--------

Description
-----------

     procedure Pack (Source: UNPACKED_ARRAY;
                     FirstElement: INDEX_TYPE;
                     var Dest: PACKED_ARRAY);

Conforming to
-------------

`Pack' is defined in ISO 7185 Pascal and supported by all known Pascal
variants except UCSD/Borland Pascal and its variants.

Example
-------

See also
--------


File: gpc.info,  Node: packed,  Next: Page,  Prev: Pack,  Up: Reference

packed
======

Synopsis
--------

Description
-----------

`packed' is a reserved word. According to ISO 7185 Pascal it can
precede `array' and `record' type definitions to indicate that memory
usage should be minimized for variables of this type, possibly at the
expense of loss of speed.

   As a GNU Pascal extension, `packed' can also be applied to *Note
Subrange Types::.

Conforming to
-------------

The reserved word `packed' is defined in ISO 7185 Pascal.

   According to ISO standard, only _packed_ arrays of char with lower
bound 1 qualify as strings of fixed length. GNU Pascal neither requires
`packed' nor the lower bound of 1 here.

Example
-------

     program PackedDemo;

     type
       MonthInt = packed 1 .. 12;  { needs one byte }
       FastMonthInt = 1 .. 12;     { needs e.g. four bytes }

       FixString10 = packed array [1 .. 10] of Char;
       FoxyString10 = array [0 .. 9] of Char;

       Flags = packed array [1 .. 32] of Boolean;  { needs four bytes }

       Int15 = Integer attribute (Size = 15);
       DateRec = packed record
         Day: 1 .. 31;       { five bits }
         Month: MonthInt;    { four bits }
         Year: Int15         { 15 bits = -16384 .. 16383 }
       end;

       Dates = array [1 .. 1000] of DateRec;

     var
       S: FixString10;
       T: FoxyString10;

     begin
       S := 'Hello!';  { blank padded }
       WriteLn (S);

       T := 'GNU Pascal';  { GPC extension: this also works. }
       WriteLn (T)
     end.

   `DateRec' has 24 bits = 3 bytes in total; `Dates' has 3000 bytes.

See also
--------

*Note Keywords::, *Note Pack::, *Note Unpack::, *Note SizeOf::, *Note
AlignOf::, *Note BitSizeOf::.


File: gpc.info,  Node: Page,  Next: PAnsiChar,  Prev: packed,  Up: Reference

Page
====

(Under construction.)

Synopsis
--------

     procedure Page ([var F: Text]);
or
     procedure Page;

Description
-----------

Conforming to
-------------

`Page' is defined in ISO 7185 Pascal, but missing in Borland Pascal.

Example
-------

See also
--------


File: gpc.info,  Node: PAnsiChar,  Next: ParamCount,  Prev: Page,  Up: Reference

PAnsiChar
=========

(Under construction.)

Synopsis
--------

     type
       PAnsiChar = ^AnsiChar;

Description
-----------

Conforming to
-------------

`PAnsiChar' is a Borland Delphi extension.

Example
-------

     program PAnsiCharDemo;
     var
       s: PAnsiChar;
     begin
       s := 'Hello, world!';
       {$X+}
       WriteLn (s)
     end.

See also
--------


File: gpc.info,  Node: ParamCount,  Next: ParamStr,  Prev: PAnsiChar,  Up: Reference

ParamCount
==========

Synopsis
--------

     function ParamCount: Integer;

Description
-----------

`ParamCount' returns the number of command-line arguments given to the
program. `ParamCount' returns 0 if no arguments have been given to the
program; the name of the program as an implicit argument is not counted.

Conforming to
-------------

`ParamCount' is a Borland Pascal extension.

Example
-------

     program ParamCountDemo;

     var
       i: Integer;

     begin
       WriteLn ('You have invoked this program with ',
                ParamCount, ' arguments.');
       WriteLn ('These are:');
       for i := 1 to ParamCount do
         WriteLn (ParamStr (i))
     end.

See also
--------

*Note ParamStr::.


File: gpc.info,  Node: ParamStr,  Next: PChar,  Prev: ParamCount,  Up: Reference

ParamStr
========

(Under construction.)

Synopsis
--------

     function ParamStr (ParmNumber: Integer): String;

Description
-----------

*Please note:* If you are using the Dos (DJGPP) or MS-Windows (mingw32)
version of GPC and are getting unexpected results from `ParamStr',
please see the section "Command-line Arguments Handling in DJGPP" of
the DJGPP FAQ list.

Conforming to
-------------

`ParamStr' is a Borland Pascal extension.

Example
-------

     program ParamStrDemo;

     var
       i: Integer;

     begin
       WriteLn ('You have invoked this program with ',
                ParamCount, ' arguments.');
       WriteLn ('These are:');
       for i := 1 to ParamCount do
         WriteLn (ParamStr (i))
     end.

See also
--------


File: gpc.info,  Node: PChar,  Next: Pi,  Prev: ParamStr,  Up: Reference

PChar
=====

(Under construction.)

Synopsis
--------

     type
       PChar = ^Char;
or
     type
       PChar = CString;

Description
-----------

Conforming to
-------------

`PChar' is a Borland Pascal extension.

Example
-------

     program PCharDemo;
     var
       s: PChar;
     begin
       s := 'Hello, world!';
       {$X+}
       WriteLn (s)
     end.

See also
--------


File: gpc.info,  Node: Pi,  Next: PObjectType,  Prev: PChar,  Up: Reference

Pi
==

(Under construction.)

Synopsis
--------

Description
-----------

Conforming to
-------------

`Pi' is a Borland Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: PObjectType,  Next: Pointer,  Prev: Pi,  Up: Reference

PObjectType
===========

Synopsis
--------

     type
       InternalSignedSizeType =
         Integer attribute (Size = BitSizeOf (SizeType));
       PObjectType = ^const record
         Size:        SizeType;
         NegatedSize: InternalSignedSizeType;
         Parent:      PObjectType;
         Name:        ^const String
       end;

   (Note: `^record' is not valid syntax. It is just used here in the
explanation because the record type has no name by itself.  Because of
the added method pointers (see below), there is no useful usage of the
record type.)

Description
-----------

`PObjectType' is the type returned by `TypeOf' and required by
`SetType'. In fact, the record pointed to (the "VMT", "virtual method
table") also contains pointers to the virtual methods. However, these
are not declared in `PObjectType' because they vary from object type to
object type. The fields declared here are those that are shared by every
object type and can be accessed via `TypeOf'.

   `Size' contains the size of the object type, `NegatedSize' contains
the size negated (for runtime checks). `Parent' contains a pointer to
the parent type's VMT (or nil if the type has no parent). `Name' points
to a string containing the type's name.

Conforming to
-------------

`PObjectType' is a GNU Pascal extension.

Example
-------

See also
--------

*Note TypeOf::, *Note SetType::, *Note OOP::.


File: gpc.info,  Node: Pointer,  Next: Polar,  Prev: PObjectType,  Up: Reference

Pointer
=======

(Under construction.)

Synopsis
--------

     type
       Pointer  { built-in type }

Description
-----------

Conforming to
-------------

`Pointer' is a Borland Pascal extension.

Example
-------

     program PointerDemo;
     var
       a: Integer;
       b: Boolean;
       p: Pointer;
     begin
       p := nil;
       p := @a;
       p := @b
     end.

See also
--------


File: gpc.info,  Node: Polar,  Next: Pos,  Prev: Pointer,  Up: Reference

Polar
=====

(Under construction.)

Synopsis
--------

     function Polar (rho, phi: Real): Complex;

Description
-----------

Conforming to
-------------

`Polar' is an ISO 10206 Extended Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: Pos,  Next: Position,  Prev: Polar,  Up: Reference

Pos
===

(Under construction.)

Synopsis
--------

     function Pos (SearchPattern, Source: String): Integer;

Description
-----------

Conforming to
-------------

`Pos' is a UCSD Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: Position,  Next: pow,  Prev: Pos,  Up: Reference

Position
========

(Under construction.)

Synopsis
--------

     function Position (var F: TYPED_FILE): INDEX_TYPE;

Description
-----------

Conforming to
-------------

`Position' is an ISO 10206 Extended Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: pow,  Next: Pred,  Prev: Position,  Up: Reference

pow
===

(Under construction.)

Synopsis
--------

     operator pow (base: Real; exponent: Integer) = power: Real;
or
     operator pow (base: Complex; exponent: Integer) = power: Complex;

Description
-----------

Exponentiation operator with integer exponent.

Conforming to
-------------

`pow' is an ISO 10206 Extended Pascal extension.

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: Pred,  Next: private,  Prev: pow,  Up: Reference

Pred
====

Synopsis
--------

     function Pred (i: ORDINAL_TYPE): ORDINAL_TYPE;
or
     function Pred (i: ORDINAL_TYPE; j: AND_INTEGER_TYPE): ORDINAL_TYPE;

   or, with extended syntax (`--extended-syntax' or `{$X+}'),

     function Pred (p: POINTER_TYPE): POINTER_TYPE;
   or
     function Pred (p: POINTER_TYPE; j: AND_INTEGER_TYPE): POINTER_TYPE;

Description
-----------

Returns the predecessor of the ORDINAL_TYPE value `i', or, if the
second argument `j' is given, its `j'th predecessor. For integer values
`i', this is `i - 1' (or `i - j'). (No, `Pred' does _not_ work faster
than plain subtraction. Both are optimized the same way, often to a
single machine instruction.)

   If extended syntax is on, the argument may also be a pointer value.
In this case, the address is decremented by the size of the variable
pointed to, or, if `j' is given, by `j' times the size of the variable
pointed to. If `p' points to an element of an array, the returned
pointer will point to the (`j'th) previous element of the array.

Conforming to
-------------

The `Pred' function is defined in ISO 7185 Pascal. The optional second
parameter is defined in ISO 10206 Extended Pascal.  Application of
`Pred' to pointers is defined in Borland Pascal.  The combination of
the second argument with application to pointers is a GNU Pascal
extension.

Example
-------

     program PredDemo;

     type
       Metasyntactical = (foo, bar, baz);

     var
       m: Metasyntactical;
       c: Char;
       a: array [1 .. 7] of Integer;
       p: ^Integer;

     begin
       m := Pred (bar);     { foo }
       c := Pred ('Z', 2);  { 'X' }
       a[1] := 42;
       a[4] := Pred (a[1]);     { 41 }
       a[5] := Pred (a[4], 3);  { 38 }
       {$X+}
       p := @a[5];
       p := Pred (p);     { now p points to a[4] }
       p := Pred (p, 3);  { now p points to a[1] }
     end.

See also
--------

*Note Succ::, *Note Dec::, *Note Pointer Arithmetics::.


File: gpc.info,  Node: private,  Next: procedure,  Prev: Pred,  Up: Reference

private
=======

(Under construction.)

Synopsis
--------

Description
-----------

GPC currently accepts but ignores the `private' directive in object
type declarations.

Conforming to
-------------

`private' is a Borland Pascal extension.

Example
-------

See also
--------

*Note Keywords::, *Note protected::, *Note public::, *Note published::.


File: gpc.info,  Node: procedure,  Next: program,  Prev: private,  Up: Reference

procedure
=========

(Under construction.)

Synopsis
--------

Description
-----------

Procedure declaration.

Conforming to
-------------

`procedure' is defined in ISO 7185 Pascal and supported by all known
Pascal variants.

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: program,  Next: property,  Prev: procedure,  Up: Reference

program
=======

(Under construction.)

Synopsis
--------

Description
-----------

Start of a Pascal program.

Conforming to
-------------

`program' is defined in ISO 7185 Pascal and supported by all known
Pascal variants.

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: property,  Next: protected,  Prev: program,  Up: Reference

property
========

Not yet implemented.

Synopsis
--------

Description
-----------

Object properties.

Conforming to
-------------

`property' is an Object Pascal and a Borland Delphi extension.

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: protected,  Next: PtrCard,  Prev: property,  Up: Reference

protected
=========

(Under construction.)

Synopsis
--------

Description
-----------

The Extended Pascal meaning of `protected' is supported by GPC.

   GPC currently accepts but ignores the `protected' directive in
object type declarations.

Conforming to
-------------

Extended Pascal and Borland Pascal, but with different meanings.

Example
-------

See also
--------

*Note Keywords::, *Note const::, *Note import::, *Note private::, *Note
public::, *Note published::.


File: gpc.info,  Node: PtrCard,  Next: PtrDiffType,  Prev: protected,  Up: Reference

PtrCard
=======

(Under construction.)

Synopsis
--------

     type
       PtrCard = Cardinal attribute (Size = BitSizeOf (Pointer));

Description
-----------

An unsigned integer type of the same size as a pointer.

Conforming to
-------------

`PtrCard' is a GNU Pascal extension.

Example
-------

     program PtrCardDemo;
     var
       a: PtrCard;
       p: Pointer;
     begin
       GetMem (p, 10);
       a := PtrCard (p);
       Inc (a);
       p := Pointer (a)
     end.

See also
--------


File: gpc.info,  Node: PtrDiffType,  Next: PtrInt,  Prev: PtrCard,  Up: Reference

PtrDiffType
===========

(Under construction.)

Synopsis
--------

     type
       PtrDiffType  { built-in type }

Description
-----------

`PtrDiffType' is a (signed) integer type to represent the difference
between two positions in memory. It is not needed except for rather
low-level purposes.

Conforming to
-------------

`PtrDiffType' is a GNU Pascal extension.

Example
-------

     program PtrDiffTypeDemo;
     var
       a: array [1 .. 10] of Integer;
       d: PtrDiffType;
       p, q: ^Integer;
     begin
       p := @a[1];
       q := @a[4];
       {$X+}
       d := q - p
     end.

See also
--------


File: gpc.info,  Node: PtrInt,  Next: PtrWord,  Prev: PtrDiffType,  Up: Reference

PtrInt
======

(Under construction.)

Synopsis
--------

     type
       PtrCard = Integer attribute (Size = BitSizeOf (Pointer));

Description
-----------

A signed integer type of the same size as a pointer.

Conforming to
-------------

`PtrInt' is a GNU Pascal extension.

Example
-------

     program PtrIntDemo;
     var
       a: PtrInt;
       p: Pointer;
     begin
       GetMem (p, 10);
       a := PtrInt (p);
       Inc (a);
       p := Pointer (a)
     end.

See also
--------


File: gpc.info,  Node: PtrWord,  Next: public,  Prev: PtrInt,  Up: Reference

PtrWord
=======

(Under construction.)

Synopsis
--------

     type
       PtrWord = PtrCard;

Description
-----------

An unsigned integer type of the same size as a pointer.

Conforming to
-------------

`PtrWord' is a GNU Pascal extension.

Example
-------

     program PtrWordDemo;
     var
       a: PtrWord;
       p: Pointer;
     begin
       GetMem (p, 10);
       a := PtrWord (p);
       Inc (a);
       p := Pointer (a)
     end.

See also
--------

*Note PtrCard::, *Note Integer Types::.


File: gpc.info,  Node: public,  Next: published,  Prev: PtrWord,  Up: Reference

public
======

(Under construction.)

Synopsis
--------

Description
-----------

GPC currently accepts but ignores the `public' directive in object type
declarations.

Conforming to
-------------

`public' is a Borland Pascal extension.

Example
-------

See also
--------

*Note Keywords::, *Note private::, *Note protected::, *Note published::.


File: gpc.info,  Node: published,  Next: Put,  Prev: public,  Up: Reference

published
=========

(Under construction.)

Synopsis
--------

Description
-----------

GPC currently accepts but ignores the `published' directive in object
type declarations.

Conforming to
-------------

`published' is a Borland Delphi extension.

Example
-------

See also
--------

*Note Keywords::, *Note private::, *Note protected::, *Note public::.


File: gpc.info,  Node: Put,  Next: qualified,  Prev: published,  Up: Reference

Put
===

(Under construction.)

Synopsis
--------

     procedure Put (var F: TYPED_FILE);

Description
-----------

Conforming to
-------------

`Put' is defined in ISO 7185 Pascal and supported by all known Pascal
variants except UCSD/Borland Pascal and its variants.

Example
-------

See also
--------


File: gpc.info,  Node: qualified,  Next: raise,  Prev: Put,  Up: Reference

qualified
=========

(Under construction.)

Synopsis
--------

Description
-----------

Import specification.

Conforming to
-------------

`qualified' is an ISO 10206 Extended Pascal extension.

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: raise,  Next: Random,  Prev: qualified,  Up: Reference

raise
=====

Not yet implemented.

Synopsis
--------

Conforming to
-------------

`overload' is a Borland Delphi extension.

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: Random,  Next: Randomize,  Prev: raise,  Up: Reference

Random
======

(Under construction.)

Synopsis
--------

Description
-----------

Conforming to
-------------

`Random' is a UCSD Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: Randomize,  Next: Re,  Prev: Random,  Up: Reference

Randomize
=========

(Under construction.)

Synopsis
--------

Description
-----------

Conforming to
-------------

`Randomize' is a UCSD Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: Re,  Next: Read,  Prev: Randomize,  Up: Reference

Re
==

Synopsis
--------

     function Re (z: Complex): Real;

Description
-----------

`Re' extracts the real part of the complex number `z'.

Conforming to
-------------

`Re' is an ISO 10206 Extended Pascal extension.

Example
-------

     program ReDemo;
     var
       z: Complex;
     begin
       z := Cmplx (1, 2);
       WriteLn (Re (z) : 0 : 5)
     end.

See also
--------

*Note Cmplx::, *Note Im::, *Note Arg::


File: gpc.info,  Node: Read,  Next: ReadLn,  Prev: Re,  Up: Reference

Read
====

(Under construction.)

Synopsis
--------

     procedure Read (var F: TYPED_FILE; VARIABLE);
or
     procedure Read (var F: Text; VARIABLES);
   or
     procedure Read (VARIABLES);

Description
-----------

Conforming to
-------------

`Read' is defined in ISO 7185 Pascal and supported by all known Pascal
variants.

Example
-------

See also
--------


File: gpc.info,  Node: ReadLn,  Next: ReadStr,  Prev: Read,  Up: Reference

ReadLn
======

(Under construction.)

Synopsis
--------

     procedure ReadLn (var F: Text; VARIABLES);
or
     procedure ReadLn (VARIABLES);

Description
-----------

Conforming to
-------------

`ReadLn' is defined in ISO 7185 Pascal and supported by all known
Pascal variants.

Example
-------

See also
--------


File: gpc.info,  Node: ReadStr,  Next: Real,  Prev: ReadLn,  Up: Reference

ReadStr
=======

(Under construction.)

Synopsis
--------

     procedure ReadStr (const S: String; VARIABLES);

Description
-----------

Conforming to
-------------

`ReadStr' is an ISO 10206 Extended Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: Real,  Next: record,  Prev: ReadStr,  Up: Reference

Real
====

(Under construction.)

Synopsis
--------

     type
       Real  { built-in type }

Description
-----------

Conforming to
-------------

`Real' is defined in ISO 7185 Pascal and supported by all known Pascal
variants.

Example
-------

     program RealDemo;
     var
       a: Real;
     begin
       a := 42;
       WriteLn (a)
     end.

See also
--------

*Note Real Types::, *Note Int::, *Note Frac::, *Note Round::, *Note
Trunc::.


File: gpc.info,  Node: record,  Next: Release,  Prev: Real,  Up: Reference

record
======

Synopsis
--------

In type definitions:
     RECORD_TYPE_IDENTIFIER = record
       FIELD_IDENTIFIER: TYPE_DEFINITION
       ...
       FIELD_IDENTIFIER: TYPE_DEFINITION
     end;

   or, with a variant part,

     RECORD_TYPE_IDENTIFIER = record
       FIELD_IDENTIFIER: TYPE_DEFINITION
       ...
       FIELD_IDENTIFIER: TYPE_DEFINITION
       case bar: VARIANT_TYPE of
         SELECTOR: (FIELD_DECLARATIONS);
         SELECTOR: (FIELD_DECLARATIONS);
         ...
     end;

   or, without a variant selector field,

     RECORD_TYPE_IDENTIFIER = record
       FIELD_IDENTIFIER: TYPE_DEFINITION
       ...
       FIELD_IDENTIFIER: TYPE_DEFINITION
       case VARIANT_TYPE of
         SELECTOR: (FIELD_DECLARATIONS);
         SELECTOR: (FIELD_DECLARATIONS);
         ...
     end;

Description
-----------

The reserved word `record' starts the definition of a new record type.

   Records can be `packed' to save memory usage at the expense of speed.

   The variants of a variant record may - but are not required to -
share one location in memory (inside the record).

   Sometimes variant records are used to emulate type casting in ISO
7185 Pascal. This is in fact a violation of the standard and not
portable. There is intentionally _no_ possibility in ISO 7185 Pascal to
emulate type casting.

Conforming to
-------------

The reserved word `record' and record types are defined in ISO 7185
Pascal.

   According to ISO Pascal, the variant type must be an identifier.
GNU Pascal, like UCSD and Borland Pascal, also allows a subrange here.

   Subranges in the variant fields, e.g. `case Integer of 2 .. 5', are
a GPC extension.

Example
-------

     program RecordDemo;

     type
       FooPtr = ^Foo;

       Foo = record
         Bar: Integer;
         NextFoo: FooPtr;
         case Choice: 1 .. 3 of
           1: (a: Integer);  { These three choices may share }
           2: (b: Real);     { one location in memory. }
           3: (c: Char;
               d: Boolean);
       end;

       Int5 = Integer attribute (Size = 5);
       SmallFoo = packed record
         b: 0 .. 3;
         a: Int5;
         r: Boolean
       end;  { needs 1 byte }

     var
       f: Foo;

     begin
       f.b := 3.14;
       WriteLn (f.a)  { yields some strange number which is part of the   }
                      { internal representation of the real number `f.b'. }
     end.

See also
--------

*Note Keywords::, *Note packed::, *Note case Statement::


File: gpc.info,  Node: Release,  Next: Rename,  Prev: record,  Up: Reference

Release
=======

(Under construction.)

Synopsis
--------

     procedure Release (P: Pointer);

Description
-----------

Conforming to
-------------

`Release' is a UCSD Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: Rename,  Next: repeat,  Prev: Release,  Up: Reference

Rename
======

(Under construction.)

Synopsis
--------

     procedure Rename (var F: ANY_FILE; NewName: String);

Description
-----------

Conforming to
-------------

`Rename' is a Borland Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: repeat,  Next: Reset,  Prev: Rename,  Up: Reference

repeat
======

Synopsis
--------

     repeat
       STATEMENT;
       ...
       STATEMENT;
     until BOOLEAN_EXPRESSION;

Description
-----------

The `repeat ... until' statement declares a loop. For further
description see *Note repeat Statement::.

Conforming to
-------------

`repeat' is defined in ISO 7185 Pascal and supported by all known
Pascal variants.

Example
-------

     program RepeatDemo;
     var
       Number, Sum: Integer;
     begin
       WriteLn ('Black Jack for beginners.');
       WriteLn ('You can choose your cards yourself. :-)');
       Sum := 0;
       repeat
         Write ('Your card (number)? ');
         ReadLn (Number);
         Inc (Sum, Number);
         WriteLn ('You have ', Sum, '.')
       until Sum >= 21;
       if Sum = 21 then
         WriteLn ('You win!')
       else
         WriteLn ('You lose.')
     end.

See also
--------

*Note Keywords::, *Note while Statement::, *Note for Statement::.


File: gpc.info,  Node: Reset,  Next: resident,  Prev: repeat,  Up: Reference

Reset
=====

(Under construction.)

Synopsis
--------

     procedure Reset (var F: ANY_FILE; [FileName: String;]
                                         [BlockSize: Cardinal]);

Description
-----------

`Reset' opens an existing file for reading. The file pointer is
positioned at the beginning of the file.

   Like `Rewrite', `Append' and `Extend' do, `Reset' accepts an
optional second parameter for the name of the file in the filesystem
and a third parameter for the block size of the file. The third
parameter is allowed only (and by default also required) for untyped
files. For details, see *Note Rewrite::.

Conforming to
-------------

`Reset' is defined in ISO 7185 Pascal.  The `BlockSize' parameter is a
Borland Pascal extension.  The `FileName' parameter is a GNU Pascal
extension.

Example
-------

     program ResetDemo;
     var
       Sample: Text;
       s: String (42);
     begin
       Rewrite (Sample);  { Open an internal file for writing }
       WriteLn (Sample, 'Hello, World!');
       Reset (Sample);  { Open it again for reading }
       ReadLn (Sample, s);
       WriteLn (s);
       Close (Sample)
     end.

See also
--------

*Note Assign::, *Note Rewrite::, *Note Append::, *Note Extend::.


File: gpc.info,  Node: resident,  Next: restricted,  Prev: Reset,  Up: Reference

resident
========

Not yet implemented.

Synopsis
--------

Description
-----------

Library export specification.

Conforming to
-------------

`resident' is a Borland Pascal extension.

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: restricted,  Next: Result,  Prev: resident,  Up: Reference

restricted
==========

(Under construction.)

Synopsis
--------

Description
-----------

Restricted type specification.

Conforming to
-------------

`restricted' is an ISO 10206 Extended Pascal extension.

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: Result,  Next: Return,  Prev: restricted,  Up: Reference

Result
======

(Under construction.)

Synopsis
--------

Description
-----------

*Please note:* GPC _deactivates_ `Result' by default because it is
incompatible with standard program semantics.  Only in `--delphi' mode
or with the option `--implicit-result', it is activated. Explicit
result variables provide a safer alternative that works in default mode.

Conforming to
-------------

`Result' is a Borland Delphi extension.

Example
-------

See also
--------


File: gpc.info,  Node: Return,  Next: ReturnAddress,  Prev: Result,  Up: Reference

Return
======

(Under construction.)

Synopsis
--------

Description
-----------

Conforming to
-------------

`Return' is a GNU Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: ReturnAddress,  Next: Rewrite,  Prev: Return,  Up: Reference

ReturnAddress
=============

(Under construction.)

Synopsis
--------

Description
-----------

Conforming to
-------------

`ReturnAddress' is a GNU Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: Rewrite,  Next: RmDir,  Prev: ReturnAddress,  Up: Reference

Rewrite
=======

(Under construction.)

Synopsis
--------

     procedure Rewrite (var F: ANY_FILE; [FileName: String;]
                                         [BlockSize: Cardinal]);

Description
-----------

`Rewrite' opens a file for writing. If the file does not exist, it is
created. The file pointer is positioned at the beginning of the file.

   Like `Reset', `Append' and `Extend' do, `Rewrite' accepts an
optional second and third parameter.

   The second parameter can specify the name of the file in the
filesystem. If it is omitted, the following alternative ways can be
used to specify the name. There are so many different ways in order to
be compatible to the idiosyncrasies of as many other Pascal compilers
as possible. (If you know about yet other ways, let us know ...)

   - The `Assign' procedure (*note Assign::)

   - The `Bind' procedure (*note Bind::)

   The following ways are only available if the file is external, i.e.
a global variable which is mentioned in the program header.  Otherwise,
the file will be internal, i.e. get no name in the file system (it may
get a name temporarily, but will then be erased automatically again).
This is useful to store some data and read them back within a program
without the need for permanent storage.

   - A command-line parameter of the form `--gpc-rts=-nF:NAME' where F
     is the identifier of the file variable.

   - If the file was mentioned in the program header and the option
     `--transparent file names' (*note GPC Command Line Options::) was
     set, the file name will be identical to the identifier converted
     to lower-case.

   - Otherwise, the user will be prompted for a file name.

   The last optional parameter determines the block size of the file.
It is valid only for untyped files. Often 1 is a reasonable value here.
However, the existence of this parameter is a BP compatibility feature,
and in BP it defaults to 128 because of historic misdesign.  Therefore,
GPC requires this parameter to be present. In `--borland-pascal' mode,
it makes it optional (like BP does), but warns about the strange
default if omitted.

Conforming to
-------------

`Rewrite' is defined in ISO 7185 Pascal.  The `BlockSize' parameter is
a Borland Pascal extension.  The `FileName' parameter is a GNU Pascal
extension.

Example
-------

     program RewriteDemo;
     var
       Sample: Text;
     begin
       Assign (Sample, 'sample.txt');
       Rewrite (Sample);
       WriteLn (Sample, 'Hello, World!');
       Close (Sample)
     end.

See also
--------

*Note Assign::, *Note Reset::, *Note Append::, *Note Extend::, *Note
Update::.


File: gpc.info,  Node: RmDir,  Next: Round,  Prev: Rewrite,  Up: Reference

RmDir
=====

Synopsis
--------

     procedure RmDir (Directory: String);

Description
-----------

`RmDir' removes the given DIRECTORY if its argument is a valid
parameter to the related operating system's function. Otherwise a
runtime error is caused.

Conforming to
-------------

`RmDir' is a Borland Pascal extension.

Example
-------

     program RmDirDemo;
     var
       Foo: String (127);
     begin
       WriteLn ('Enter directory name to remove: ');
       ReadLn (Foo);
       {$I-}  { Don't abort on I/O errors }
       RmDir (Foo);
       if IOResult <> 0 then
         WriteLn ('Directory ', Foo, ' could not be removed.')
       else
         WriteLn ('Okay.')
     end.

See also
--------

*Note ChDir::, *Note MkDir::


File: gpc.info,  Node: Round,  Next: RunError,  Prev: RmDir,  Up: Reference

Round
=====

Synopsis
--------

     function Round (x: Real): Integer;

Description
-----------

`Round' returns the nearest integer to `x'. The result is of type
integer. In the case of equidistance, the result is machine-dependent
(or depends on the behaviour of the processor).

Conforming to
-------------

`Round' is defined in ISO 7185 Pascal and supported by all known Pascal
variants.

Example
-------

     program RoundDemo;
     var
       Foo: Real;
     begin
       Foo := 9.876543;
       WriteLn (Round (Foo));  { Prints 10 }
       Foo := 3.456789;
       WriteLn (Round (Foo));  { Prints 3 }

       WriteLn (Frac (12.345) : 1 : 5);  { 0.34500 }
       WriteLn (Int (12.345) : 1 : 5);  { 12.00000 }
       WriteLn (Round (12.345) : 1);  { 12 }
       WriteLn (Trunc (12.345) : 1);  { 12 }

       WriteLn (Frac (-12.345) : 1 : 5);  { -0.34500 }
       WriteLn (Int (-12.345) : 1 : 5);  { -12.00000 }
       WriteLn (Round (-12.345) : 1);  { -12 }
       WriteLn (Trunc (-12.345) : 1);  { -12 }

       WriteLn (Frac (12.543) : 1 : 5);  { 0.54300 }
       WriteLn (Int (12.543) : 1 : 5);  { 12.00000 }
       WriteLn (Round (12.543) : 1);  { 13 }
       WriteLn (Trunc (12.543) : 1);  { 12 }

       WriteLn (Frac (-12.543) : 1 : 5);  { -0.54300 }
       WriteLn (Int (-12.543) : 1 : 5);  { -12.00000 }
       WriteLn (Round (-12.543) : 1);  { -13 }
       WriteLn (Trunc (-12.543) : 1);  { -12 }
     end.

See also
--------

*Note Real Types::, *Note Real::, *Note Int::, *Note Frac::, *Note
Trunc::.


File: gpc.info,  Node: RunError,  Next: Seek,  Prev: Round,  Up: Reference

RunError
========

(Under construction.)

Synopsis
--------

     procedure RunError (ErrorCode: Integer);

Description
-----------

Conforming to
-------------

`RunError' is a Borland Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: Seek,  Next: SeekEOF,  Prev: RunError,  Up: Reference

Seek
====

(Under construction.)

Synopsis
--------

     procedure Seek (var F: TYPED_FILE; NewPosition: INDEX_TYPE);

Description
-----------

Conforming to
-------------

`Seek' is a UCSD Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: SeekEOF,  Next: SeekEOLn,  Prev: Seek,  Up: Reference

SeekEOF
=======

(Under construction.)

Synopsis
--------

     function SeekEOF ([var F: Text]): Boolean;

Description
-----------

Conforming to
-------------

`SeekEOF' is a Borland Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: SeekEOLn,  Next: SeekRead,  Prev: SeekEOF,  Up: Reference

SeekEOLn
========

(Under construction.)

Synopsis
--------

     function SeekEOLn ([var F: Text]): Boolean;

Description
-----------

Conforming to
-------------

`SeekEOLn' is a Borland Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: SeekRead,  Next: SeekUpdate,  Prev: SeekEOLn,  Up: Reference

SeekRead
========

(Under construction.)

Synopsis
--------

     procedure SeekRead (var F: TYPED_FILE; NewPosition: INDEX_TYPE);

Description
-----------

Conforming to
-------------

`SeekRead' is an ISO 10206 Extended Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: SeekUpdate,  Next: SeekWrite,  Prev: SeekRead,  Up: Reference

SeekUpdate
==========

(Under construction.)

Synopsis
--------

     procedure SeekUpdate (var F: TYPED_FILE; NewPosition: INDEX_TYPE);

Description
-----------

Conforming to
-------------

`SeekUpdate' is an ISO 10206 Extended Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: SeekWrite,  Next: segment,  Prev: SeekUpdate,  Up: Reference

SeekWrite
=========

(Under construction.)

Synopsis
--------

     procedure SeekWrite (var F: TYPED_FILE; NewPosition: INDEX_TYPE);

Description
-----------

Conforming to
-------------

`SeekWrite' is an ISO 10206 Extended Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: segment,  Next: Self,  Prev: SeekWrite,  Up: Reference

segment
=======

Not yet implemented.

Synopsis
--------

Description
-----------

Segment specification.

Conforming to
-------------

`segment' is a UCSD Pascal extension.

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: Self,  Next: set,  Prev: segment,  Up: Reference

Self
====

(Under construction.)

Synopsis
--------

Description
-----------

Conforming to
-------------

`Self' is an Object Pascal and a Borland Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: set,  Next: SetFileTime,  Prev: Self,  Up: Reference

set
===

Synopsis
--------

In type definitions:
     set of ORDINAL_TYPE  { built-in type class }

Description
-----------

A set contains zero or more elements from an ordinal type, e.g.  Char,
a subrange of Char, or a subrange of an enumerated type or integers.
The elements of a sets do not have any ordering (that is a set
containing 'B' and 'A' is the same as a set containing 'A' and 'B'),
nor can an element be included more than once. Sets simply store the
information about which elements are included in the set.

Conforming to
-------------

`set' is defined in ISO 7185 Pascal and supported by all known Pascal
variants.

Example
-------

     program SetDemo;

     type
       TCharSet = set of Char;

     var
       Ch: Char;
       MyCharSet: TCharSet;
     begin
       MyCharSet := ['P','N','L'];
       if 'A' in MyCharSet then
         WriteLn ('Wrong: A in set MyCharSet')
       else
         WriteLn ('Right: A is not in set MyCharSet');
       Include (MyCharSet, 'A');  { A, L, N, P }
       Exclude (MyCharSet, 'N');  { A, L, P }
       MyCharSet := MyCharSet + ['B','C'];  { A, B, C, L, P }
       MyCharSet := MyCharSet - ['C','D'];  { A, B, L, P }
       WriteLn ('set MyCharSet contains:');
       for Ch in MyCharSet do
         WriteLn (Ch);
     end.

   Set also *Note Set Operations:: or examples of some of the many set
operations.

See also
--------

*Note Keywords::, *Note Set Operations::, *Note in::, *Note Exclude::,
*Note Include::.


File: gpc.info,  Node: SetFileTime,  Next: SetLength,  Prev: set,  Up: Reference

SetFileTime
===========

     procedure SetFileTime (var f: ANY_FILE;
                            AccessTime, ModificationTime: UnixTimeType);

Synopsis
--------

Description
-----------

Conforming to
-------------

`SetFileTime' is a GNU Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: SetLength,  Next: SetType,  Prev: SetFileTime,  Up: Reference

SetLength
=========

Synopsis
--------

     procedure SetLength (var S: String; NewLength: Integer);

Description
-----------

`SetLength' explicitly assigns a new length `NewLength' to the string
parameter `S'. The contents of the string elements (characters) are
_not_ changed; if the operation increases the length of the string, the
characters appended at the end are _undefined_.

Conforming to
-------------

`SetLength' is a Borland Delphi 2.0 extension.

Example
-------

     program SetLengthDemo;

     var
       S: String (26);

     begin
       S := 'Hello, world!';
       SetLength (S, Length ('Hello'));
       WriteLn (S);                                           { 'Hello' }

       SetLength (S, 26);
       WriteLn (S);                     { 'Hello, world!(%$xy"!#&~+(/]' }
                                 { undefined characters ^^^^^^^^^^^^^^  }

       { SetLength (S, 42);  GPC detects this overflow at compile time. }
     end.

See also
--------

*Note Length::, *Note String::.


File: gpc.info,  Node: SetType,  Next: shl,  Prev: SetLength,  Up: Reference

SetType
=======

Synopsis
--------

     procedure SetType (var SomeObject; VMT: PObjectType);

Description
-----------

The procedure `SetType' explicitly assigns a value to the implicit VMT
field of an object. This is normally done implicitly when a constructor
is called.

   You can use this to write a polymorphic I/O routine which reads an
object from a file. In this case, you cannot reasonably use `New' to
allocate the storage, but you `GetMem' it and initialize the object
manually using `SetType' before calling the constructor explicitly.

   The only values you should assign to an object via `SetType' are
actual VMT pointers that were obtained via `TypeOf'. In particular,
declaring a record like the one shown in the description of
`PObjectType' and assigning a pointer to it to an object via `SetType'
will usually not work because the virtual method pointers are missing.

   Since `SetType' is a dangerous feature, it yields a warning unless
`{$X+}' is given.

Conforming to
-------------

`SetType' is a GNU Pascal extension.

Example
-------

     program SetTypeDemo;

     type
       BasePtr = ^BaseObj;

       BaseObj = object
         constructor Load;
       end;

       ChildObj = object (BaseObj)
         constructor Load;
       end;

     constructor BaseObj.Load;
     begin
     end;

     constructor ChildObj.Load;
     begin
     end;

     {$X+}

     { This is somewhat fragmentary code. }
     function GetObject (var InputFile: File) = Result: BasePtr;
     const
       VMTTable: array [1 .. 2] of PObjectType =
         (TypeOf (BaseObj), TypeOf (ChildObj));
     var
       Size: Cardinal;
       TypeID: Integer;
       VMT: PObjectType;
     begin
       { Read the size of the object from some file and store it in `Size'. }
       BlockRead (InputFile, Size, SizeOf (Size));

       { Allocate memory for the object. }
       GetMem (Result, Size);

       { Read some ID from some file. }
       BlockRead (InputFile, TypeID, SizeOf (TypeID));

       { Look up the `VMT' from some table. }
       { Explicit range checking wouldn't be a bad idea here ... }
       { Without it, a wrong value just leads to a runtime error. }
       VMT := VMTTable[TypeID];

       SetType (Result^, VMT);

       { Now the object is ready, and the constructor can be called. }
       { Look up the correct constructor from some table and call it. }
     end;

     begin
     end.

See also
--------

*Note PObjectType::, *Note TypeOf::, *Note OOP::.


File: gpc.info,  Node: shl,  Next: ShortBool,  Prev: SetType,  Up: Reference

shl
===

Synopsis
--------

     operator shl (operand1, operand2: INTEGER_TYPE) = Result: INTEGER_TYPE;
or
     procedure shl (var operand1: INTEGER_TYPE; operand2: INTEGER_TYPE);

Description
-----------

In GNU Pascal, `shl' has two built-in meanings:

  1. Bitwise shift left of an integer-type expression by another
     integer value.  The result is of the type of the first operand.

  2. Use as a "procedure": `operand1' is shifted left by `operand2';
     the result is stored in `operand1'.


Conforming to
-------------

`shl' is a Borland Pascal extension.

   Use of `shl' as a "procedure" is a GNU Pascal extension.

Example
-------

     program ShlDemo;
     var
       a: Integer;
     begin
       a := 1 shl 7;  { yields 128 = 2 pow 7 }
       shl (a, 4)  { same as `a := a shl 4' }
     end.

See also
--------

*Note Keywords::, *Note shr::, *Note Operators::.


File: gpc.info,  Node: ShortBool,  Next: ShortCard,  Prev: shl,  Up: Reference

ShortBool
=========

Synopsis
--------

     type
       ShortBool = Boolean attribute (Size = BitSizeOf (ShortInt));

Description
-----------

The intrinsic `ShortBool' represents boolean values, but occupies the
same memory space as a `ShortInt'.  It is used when you need to define
a parameter or record that conforms to some external library or system
specification.

Conforming to
-------------

`ShortBool' is a GNU Pascal extension.

Example
-------

     program ShortBoolDemo;
     var
       a: ShortBool;
     begin
       ShortInt (a) := 1;
       if a then WriteLn ('Ord (True) = 1')
     end.

See also
--------

*Note Boolean (Intrinsic)::, *Note Boolean::, *Note True::, *Note
False::, *Note CBoolean::, *Note ByteBool::, *Note MedBool::, *Note
WordBool::, *Note LongBool::, *Note LongestBool::.


File: gpc.info,  Node: ShortCard,  Next: ShortInt,  Prev: ShortBool,  Up: Reference

ShortCard
=========

Synopsis
--------

     type
       ShortCard = Cardinal attribute (Size = BitSizeOf (ShortInt));

Description
-----------

`ShortCard' is an unsigned integer type which is not larger than
`Cardinal'. On some platforms it is 16 bits wide and thus has a range
of `0 .. 65535'.

   `ShortCard' in GNU Pascal is compatible to `short unsigned int' in
GNU C.

   There are lots of other integer types in GPC, see *Note Integer
Types::.

Conforming to
-------------

`ShortCard' is a GNU Pascal extension.

Example
-------

     program ShortCardDemo;
     var
       a: ShortCard;
     begin
       a := 42;
       WriteLn (a)
     end.

See also
--------

*Note Integer Types::, *Note Subrange Types::.


File: gpc.info,  Node: ShortInt,  Next: ShortReal,  Prev: ShortCard,  Up: Reference

ShortInt
========

Synopsis
--------

     type
       ShortInt  { built-in type }

Description
-----------

`ShortInt' is a signed integer type which is not larger than `Integer'.
On some platforms it is 16 bits wide and thus has a range of `-32768 ..
32767'.

   `ShortInt' in GNU Pascal is compatible to `short int' in GNU C.

   There are lots of other integer types in GPC, see *Note Integer
Types::.

Conforming to
-------------

`ShortInt' is a Borland Pascal extension. In Borland Pascal, `ShortInt'
is an 8-bit signed integer type (`ByteInt' in GNU Pascal).

Example
-------

     program ShortIntDemo;
     var
       a: ShortInt;
     begin
       a := 42;
       WriteLn (a)
     end.

See also
--------

*Note Integer Types::, *Note Subrange Types::.


File: gpc.info,  Node: ShortReal,  Next: ShortWord,  Prev: ShortInt,  Up: Reference

ShortReal
=========

(Under construction.)

Synopsis
--------

     type
       ShortReal  { built-in type }

Description
-----------

Conforming to
-------------

`ShortReal' is a GNU Pascal extension.

Example
-------

     program ShortRealDemo;
     var
       a: ShortReal;
     begin
       a := 42;
       WriteLn (a)
     end.

See also
--------


File: gpc.info,  Node: ShortWord,  Next: shr,  Prev: ShortReal,  Up: Reference

ShortWord
=========

Synopsis
--------

     type
       ShortWord = ShortCard;

Description
-----------

`ShortWord' is an unsigned integer type which is not larger than
`Word'. On some platforms it is 16 bits wide and thus has a range of `0
.. 65535'. It is the same as *Note ShortCard::.

   `ShortWord' in GNU Pascal is compatible to `short unsigned int' in
GNU C.

   There are lots of other integer types in GPC, see *Note Integer
Types::.

Conforming to
-------------

`ShortWord' is a GNU Pascal extension.

   `ShortWord' in GNU Pascal essentially corresponds to `Word' in
Borland Pascal and Delphi where it is a 16-bit unsigned integer type.

Example
-------

     program ShortWordDemo;
     var
       a: ShortWord;
     begin
       a := 42;
       WriteLn (a)
     end.

See also
--------

*Note ShortCard::, *Note Integer Types::, *Note Subrange Types::.


File: gpc.info,  Node: shr,  Next: Sin,  Prev: ShortWord,  Up: Reference

shr
===

Synopsis
--------

     operator shr (operand1, operand2: INTEGER_TYPE) = Result: INTEGER_TYPE;
or
     procedure shr (var operand1: INTEGER_TYPE; operand2: INTEGER_TYPE);

Description
-----------

In GNU Pascal, `shr' has two built-in meanings:

  1. Bitwise shift right of an integer-type expression by another
     integer value.  The result is of the type of the first operand.

  2. Use as a "procedure": `operand1' is shifted right by `operand2';
     the result is stored in `operand1'.


Conforming to
-------------

`shr' is a Borland Pascal extension.

   Unlike the Borland compilers, GNU Pascal cares about the signedness
of the first operand: If a signed integer with a negative value is
shifted right, "one" bits are filled in from the left.

   Use of `shr' as a "procedure" is a GNU Pascal extension.

Example
-------

     program ShrDemo;
     var
       a: Integer;
     begin
       a := 1024 shr 4;  { yields 64 }
       a := -127 shr 4;  { yields -8 }
       shr (a, 2)  { same as `a := a shr 2' }
     end.

See also
--------

*Note Keywords::, *Note shl::, *Note Operators::.


File: gpc.info,  Node: Sin,  Next: Single,  Prev: shr,  Up: Reference

Sin
===

Synopsis
--------

     function Sin (x: Real): Real;
or
     function Sin (z: Complex): Complex;

Description
-----------

`Sin' returns the sine of the argument.  The result is in the range `-1
<= Sin (x) <= 1' for real arguments.

Conforming to
-------------

The function `Sin' is defined in ISO 7185 Pascal; its application to
complex values is defined in ISO 10206 Extended Pascal.

Example
-------

     program SinDemo;
     begin
       { yields 0.5 since Sin (Pi / 6) = 0.5 }
       WriteLn (Sin (Pi / 6) : 0 : 5)
     end.

See also
--------

*Note ArcTan::, *Note Cos::, *Note Ln::, *Note Arg::.


File: gpc.info,  Node: Single,  Next: SizeOf,  Prev: Sin,  Up: Reference

Single
======

(Under construction.)

Synopsis
--------

     type
       Single = ShortReal;

Description
-----------

Conforming to
-------------

`Single' is a Borland Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: SizeOf,  Next: SizeType,  Prev: Single,  Up: Reference

SizeOf
======

Synopsis
--------

     function SizeOf (var x): SizeType;

Description
-----------

Returns the size of a type or variable in bytes.

   `SizeOf' can be applied to expressions and type names. If the
argument is a polymorphic object, the size of its actual type is
returned.

Conforming to
-------------

`SizeOf' is a UCSD Pascal extension.

Example
-------

     program SizeOfDemo;
     var
       a: Integer;
       b: array [1 .. 8] of Char;
     begin
       WriteLn (SizeOf (a));        { Size of an `Integer'; often 4 bytes. }
       WriteLn (SizeOf (Integer));  { The same. }
       WriteLn (SizeOf (b))         { Size of eight `Char's; usually 8 bytes. }
     end.

See also
--------

*Note BitSizeOf::, *Note AlignOf::, *Note TypeOf::.


File: gpc.info,  Node: SizeType,  Next: SmallInt,  Prev: SizeOf,  Up: Reference

SizeType
========

Synopsis
--------

     type
       SizeType  { built-in type }

Description
-----------

`SizeType' is an integer type (usually unsigned) to represent the size
of objects in memory.

Conforming to
-------------

`SizeType' is a GNU Pascal extension.

Example
-------

     program SizeTypeDemo;
     var
       a: array [1 .. 10] of Integer;
       Size: SizeType;
     begin
       Size := SizeOf (a);
       WriteLn (Size)
     end.

See also
--------


File: gpc.info,  Node: SmallInt,  Next: Sqr,  Prev: SizeType,  Up: Reference

SmallInt
========

Synopsis
--------

     type
       SmallInt = ShortInt;

Description
-----------

`SmallInt' is a signed integer type which is not larger than `Integer'.
On some platforms it is 16 bits wide and thus has a range of `-32768 ..
32767'. It is the same as `ShortInt' (see *Note ShortInt::).

   There are lots of other integer types in GPC, see *Note Integer
Types::.

Conforming to
-------------

`SmallInt' is a Borland Delphi 2.0 extension.

Example
-------

     program SmallIntDemo;
     var
       a: SmallInt;
     begin
       a := 42;
       WriteLn (a)
     end.

See also
--------

*Note ShortInt::, *Note Integer Types::, *Note Subrange Types::.


File: gpc.info,  Node: Sqr,  Next: SqRt,  Prev: SmallInt,  Up: Reference

Sqr
===

Synopsis
--------

     function Sqr (i: INTEGER_TYPE): INTEGER_TYPE;
or
     function Sqr (x: REAL_TYPE): REAL_TYPE;
   or
     function Sqr (z: COMPLEX_TYPE): COMPLEX_TYPE;

Description
-----------

Returns the square of the argument:

     function Sqr (x: SOME_TYPE): SOME_TYPE;
     begin
       Sqr := x * x  { or: x pow 2 }
     end;

Conforming to
-------------

The function `Sqr' is defined in ISO 7185 Pascal; its application to
complex values is defined in ISO 10206 Extended Pascal.

Example
-------

     program SqrDemo;

     var
       i: Complex;

     begin
       i := Cmplx (0, 1);
       WriteLn (Re (Sqr (i)) : 0 : 3)  { yields -1.000 }
     end.

See also
--------

*Note pow::, *Note SqRt::, *Note Abs::, *Note Operators::.


File: gpc.info,  Node: SqRt,  Next: StandardError,  Prev: Sqr,  Up: Reference

SqRt
====

Synopsis
--------

     function SqRt (x: REAL_TYPE): REAL_TYPE;
or
     function SqRt (z: COMPLEX_TYPE): COMPLEX_TYPE;

Description
-----------

Returns the positive square root of the argument.

   For real arguments, it is an error if the argument is negative.

   For complex arguments, `SqRt' returns the principal value of the
root of the argument, i.e. the root with positive real part, or, if the
real part is zero, that one with positive imaginary part.

Conforming to
-------------

The function `SqRt' is defined in ISO 7185 Pascal; its application to
complex values is defined in ISO 10206 Extended Pascal.

Example
-------

     program SqRtDemo;

     var
       m1: Complex;

     begin
       m1 := Cmplx (-1, 0);  { -1 }
       WriteLn (Re (SqRt (m1)) : 6 : 3, Im (SqRt (m1)) : 6 : 3);
         { yields 1.000 -1.000, i.e. the imaginary unit, i }
     end.

See also
--------

*Note pow::, *Note Sqr::, *Note Operators::.


File: gpc.info,  Node: StandardError,  Next: StandardInput,  Prev: SqRt,  Up: Reference

StandardError
=============

(Under construction.)

Synopsis
--------

Description
-----------

Conforming to
-------------

`StandardError' is a GNU Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: StandardInput,  Next: StandardOutput,  Prev: StandardError,  Up: Reference

StandardInput
=============

(Under construction.)

Synopsis
--------

Description
-----------

Conforming to
-------------

`StandardInput' is an ISO 10206 Extended Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: StandardOutput,  Next: StdErr,  Prev: StandardInput,  Up: Reference

StandardOutput
==============

(Under construction.)

Synopsis
--------

Description
-----------

Conforming to
-------------

`StandardOutput' is an ISO 10206 Extended Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: StdErr,  Next: Str,  Prev: StandardOutput,  Up: Reference

StdErr
======

Synopsis
--------

     var
       StdErr: Text;

Description
-----------

The `StdErr' variable is connected to the standard error file handle.
To report errors, you should prefer `WriteLn (StdErr, 'everything
wrong')' over `WriteLn ('everything wrong')'.

Conforming to
-------------

`StdErr' is a GNU Pascal extension.

Example
-------

     program StdErrDemo;
     var
       Denominator: Integer;
     begin
       ReadLn (Denominator);
       if Denominator = 0 then
         WriteLn (StdErr, ParamStr (0), ': division by zero')
       else
         WriteLn ('1 / ', Denominator, ' = ', 1 / Denominator)
     end.

See also
--------

*Note StandardError::, *Note Output::, *Note Input::.


File: gpc.info,  Node: Str,  Next: String,  Prev: StdErr,  Up: Reference

Str
===

(Under construction.)

Synopsis
--------

     procedure Str (x: INTEGER_OR_REAL; var Dest: String);
or
     procedure Str (x: INTEGER_OR_REAL : FIELD_WIDTH; var Dest: String);
   or
     procedure Str (x: Real : FIELD_WIDTH : PRECISION; var Dest: String);
   or
     procedure Str (REPEATED_CONSTRUCTS_AS_DESCRIBED_ABOVE; var Dest: String);

Description
-----------

Conforming to
-------------

`Str' is a UCSD Pascal extension, generalized by Borland Pascal. The
possibility to handle more than one variable in one `Str' statement is
a GNU Pascal extension.

   ISO 10206 Extended Pascal defines `WriteStr' instead of `Str'.

Example
-------

See also
--------

*Note WriteStr::.


File: gpc.info,  Node: String,  Next: String2CString,  Prev: Str,  Up: Reference

String
======

(Under construction.)

Synopsis
--------

Description
-----------

Conforming to
-------------

`String' is an Extended Pascal and a UCSD Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: String2CString,  Next: SubStr,  Prev: String,  Up: Reference

String2CString
==============

(Under construction.)

Synopsis
--------

     function String2CString (const S: String): CString;

Description
-----------

Conforming to
-------------

`String2CString' is a GNU Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: SubStr,  Next: Succ,  Prev: String2CString,  Up: Reference

SubStr
======

Synopsis
--------

     function SubStr (S: String; FirstChar: Integer): String;
or
     function SubStr (S: String; FirstChar, Count: Integer): String;

Description
-----------

`SubStr' returns a sub-string of S starting with the character at
position FIRSTCHAR. If COUNT is given, such many characters will be
copied into the sub-string. If COUNT is omitted, the sub-string will
range to the end of S.

   If `Count' is too large for the sub-string to fit in S or if
`FirstChar' exceeds the length of S, `SubStr' triggers a runtime error.
(For a function returning the empty string instead, see *Note Copy::.)

Conforming to
-------------

`SubStr' is an ISO 10206 Extended Pascal extension.

Example
-------

     program SubStrDemo;
     var
       S: String (42);
     begin
       S := 'Hello';
       WriteLn (SubStr (S, 2, 3));   { yields `ell' }
       WriteLn (SubStr (S, 3));      { yields `llo' }
       WriteLn (SubStr (S, 4, 7));   { yields a runtime error }
       WriteLn (SubStr (S, 42));     { yields a runtime error }
     end.

See also
--------

*Note Copy::, *Note String Slice Access::.


File: gpc.info,  Node: Succ,  Next: Text,  Prev: SubStr,  Up: Reference

Succ
====

Synopsis
--------

     function Succ (i: ORDINAL_TYPE): ORDINAL_TYPE;
or
     function Succ (i: ORDINAL_TYPE; j: AND_INTEGER_TYPE): ORDINAL_TYPE;

   or, with extended syntax (`--extended-syntax' or `{$X+}'),

     function Succ (p: POINTER_TYPE): POINTER_TYPE;
   or
     function Succ (p: POINTER_TYPE; j: AND_INTEGER_TYPE): POINTER_TYPE;

Description
-----------

Returns the successor of the ORDINAL_TYPE value `i', or, if the second
argument `j' is given, its `j'th successor.  For integer values `i',
this is `i + 1' (or `i + j').  (No, `Succ' does _not_ work faster than
plain addition.  Both are optimized the same way, often to a single
machine instruction.)

   If extended syntax is on, the argument may also be a pointer value.
In this case, the address is incremented by the size of the variable
pointed to, or, if `j' is given, by `j' times the size of the variable
pointed to. If `p' points to an element of an array, the returned
pointer will point to the (`j'th) next element of the array.

Conforming to
-------------

The `Succ' function is defined in ISO 7185 Pascal. The optional second
parameter is defined in ISO 10206 Extended Pascal.  Application of
`Succ' to pointers is defined in Borland Pascal.  The combination of
the second argument with application to pointers is a GNU Pascal
extension.

Example
-------

     program SuccDemo;

     type
       Metasyntactical = (foo, bar, baz);

     var
       m: Metasyntactical;
       c: Char;
       a: array [1 .. 7] of Integer;
       p: ^Integer;

     begin
       m := Succ (foo);     { bar }
       c := Succ ('A', 4);  { 'E' }
       a[1] := 42;
       a[2] := Succ (a[1]);     { 43 }
       a[5] := Succ (a[2], 7);  { 50 }
       {$X+}
       p := @a[1];
       p := Succ (p);     { points to `a[2]' now }
       p := Succ (p, 3);  { points to `a[5]' now }
     end.

See also
--------

*Note Pred::, *Note Inc::, *Note Pointer Arithmetics::.


File: gpc.info,  Node: Text,  Next: then,  Prev: Succ,  Up: Reference

Text
====

(Under construction.)

Synopsis
--------

     type
       Text  { built-in type }

Description
-----------

Conforming to
-------------

`Text' is defined in ISO 7185 Pascal and supported by all known Pascal
variants.

Example
-------

     program TextDemo;
     var
       t: Text;
     begin
       Rewrite (t, 'hello.txt');
       WriteLn (t, 'Hello, world!')
     end.

See also
--------

*Note file::, *Note AnyFile::.


File: gpc.info,  Node: then,  Next: Time,  Prev: Text,  Up: Reference

then
====

(Under construction.)

Synopsis
--------

Description
-----------

Part of an `if' statement or part of the `and then' operator.

Conforming to
-------------

`then' is defined in ISO 7185 Pascal and supported by all known Pascal
variants.

Example
-------

     program ThenDemo;
     var
       i: Integer;
     begin
       Write ('Enter a number: ');
       ReadLn (i);
       if i > 42 then
         WriteLn ('The number is greater than 42')
     end.

See also
--------

*Note Keywords::.


File: gpc.info,  Node: Time,  Next: TimeStamp,  Prev: then,  Up: Reference

Time
====

Synopsis
--------

     function Time (T: TimeStamp): packed array [1 .. TIME_LENGTH] of Char;

Description
-----------

Date takes a `TimeStamp' parameter and returns the time as a string (in
the form of a packed array of `Char').  TIME_LENGTH is an
implementation defined invisible constant.

Conforming to
-------------

`Time' is an ISO 10206 Extended Pascal extension.

Example
-------

Set *Note TimeStamp::.

See also
--------

*Note TimeStamp::, *Note GetTimeStamp::, *Note Date::, *Note Date And
Time Routines::.


File: gpc.info,  Node: TimeStamp,  Next: to,  Prev: Time,  Up: Reference

TimeStamp
=========

Synopsis
--------

     type
       TimeStamp = packed record
         DateValid,
         TimeValid  : Boolean;
         Year       : Integer;
         Month      : 1 .. 12;
         Day        : 1 .. 31;
         DayOfWeek  : 0 .. 6;   { 0 means Sunday }
         Hour       : 0 .. 23;
         Minute     : 0 .. 59;
         Second     : 0 .. 61;  { to allow for leap seconds }
         MicroSecond: 0 .. 999999;
         TimeZone   : Integer;  { in seconds east of UTC }
         DST        : Boolean;
         TZName1,
         TZName2    : String (32);
       end;

Description
-----------

The `TimeStamp' record holds all the information about a particular
time. You can get the current time with `GetTimeStamp' and you can get
the date or time in a printable form using the `Date' and `Time'
functions.

Conforming to
-------------

`TimeStamp' is an ISO 10206 Extended Pascal extension. The fields
`DateValid', `TimeValid', `Year', `Month', `Day', `Hour', `Minute',
`Second' are required by Extended Pascal, the other ones are GNU Pascal
extensions.

Example
-------

     program TimeStampDemo;

     var
       t: TimeStamp;

     begin
       GetTimeStamp (t);
       WriteLn ('DateValid: ', t.DateValid);
       WriteLn ('TimeValid: ', t.TimeValid);
       WriteLn ('Year: ', t.Year);
       WriteLn ('Month: ', t.Month);
       WriteLn ('Day: ', t.Day);
       WriteLn ('DayOfWeek (0 .. 6, 0=Sunday): ', t.DayOfWeek);
       WriteLn ('Hour (0 .. 23): ', t.Hour);
       WriteLn ('Minute (0 .. 59): ', t.Minute);
       WriteLn ('Second (0 .. 61): ', t.Second);
       WriteLn ('MicroSecond (0 .. 999999): ', t.MicroSecond);
       WriteLn ('TimeZone (in seconds east of UTC): ', t.TimeZone);
       WriteLn ('DST: ', t.DST);
       WriteLn ('TZName1: ', t.TZName1);
       WriteLn ('TZName2: ', t.TZName2);
       WriteLn;
       WriteLn ('Date is: ', Date (t));
       WriteLn ('Time is: ', Time (t));
     end.

See also
--------

*Note GetTimeStamp::, *Note Date::, *Note Time::, *Note Date And Time
Routines::.


File: gpc.info,  Node: to,  Next: to begin do,  Prev: TimeStamp,  Up: Reference

to
==

(Under construction.)

Synopsis
--------

Description
-----------

Part of a `for' loop counting upwards or a `to begin do' or `to end do'
module constructor or destructor.

Conforming to
-------------

`to' is defined in ISO 7185 Pascal and supported by all known Pascal
variants.

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: to begin do,  Next: to end do,  Prev: to,  Up: Reference

to begin do
===========

(Under construction.)

Synopsis
--------

Description
-----------

Conforming to
-------------

`to begin do' is an ISO 10206 Extended Pascal extension.

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: to end do,  Next: Trim,  Prev: to begin do,  Up: Reference

to end do
=========

(Under construction.)

Synopsis
--------

Description
-----------

Conforming to
-------------

`to begin end' is an ISO 10206 Extended Pascal extension.

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: Trim,  Next: True,  Prev: to end do,  Up: Reference

Trim
====

(Under construction.)

Synopsis
--------

     function Trim (S: String): String;

Description
-----------

Conforming to
-------------

`Trim' is an ISO 10206 Extended Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: True,  Next: Trunc,  Prev: Trim,  Up: Reference

True
====

Synopsis
--------

     type
       Boolean = (False, True);  { built-in type }

Description
-----------

`True' is one of the two Boolean values and is used to represent a
condition which is always fullfilled. For example, the expression `1 =
1' always yields the value `True'. It is the opposite of `False'.
`True' has the ordinal value 1.

Conforming to
-------------

`True' is defined in ISO 7185 Pascal and supported by all known Pascal
variants.

Example
-------

     program TrueDemo;

     var
       a: Boolean;

     begin
       a := 1 = 1;  { yields True }
       WriteLn (Ord (True));  { 1 }
       WriteLn (a);  { True }
       if True then WriteLn ('This is executed.')
     end.

See also
--------

*Note Boolean (Intrinsic)::, *Note False::, *Note Boolean::.


File: gpc.info,  Node: Trunc,  Next: Truncate,  Prev: True,  Up: Reference

Trunc
=====

Synopsis
--------

     function Trunc (x: Real): Integer;

Description
-----------

`Trunc' returns the integer part of a floating point number as an
integer. Use `Int' to get the integer part as a floating point number.

Conforming to
-------------

`Trunc' is defined in ISO 7185 Pascal and supported by all known Pascal
variants.

Example
-------

     program TruncDemo;

     begin
       WriteLn (Frac (12.345) : 1 : 5);  { 0.34500 }
       WriteLn (Int (12.345) : 1 : 5);  { 12.00000 }
       WriteLn (Round (12.345) : 1);  { 12 }
       WriteLn (Trunc (12.345) : 1);  { 12 }

       WriteLn (Frac (-12.345) : 1 : 5);  { -0.34500 }
       WriteLn (Int (-12.345) : 1 : 5);  { -12.00000 }
       WriteLn (Round (-12.345) : 1);  { -12 }
       WriteLn (Trunc (-12.345) : 1);  { -12 }

       WriteLn (Frac (12.543) : 1 : 5);  { 0.54300 }
       WriteLn (Int (12.543) : 1 : 5);  { 12.00000 }
       WriteLn (Round (12.543) : 1);  { 13 }
       WriteLn (Trunc (12.543) : 1);  { 12 }

       WriteLn (Frac (-12.543) : 1 : 5);  { -0.54300 }
       WriteLn (Int (-12.543) : 1 : 5);  { -12.00000 }
       WriteLn (Round (-12.543) : 1);  { -13 }
       WriteLn (Trunc (-12.543) : 1);  { -12 }
     end.

See also
--------

*Note Real Types::, *Note Real::, *Note Int::, *Note Frac::, *Note
Round::.


File: gpc.info,  Node: Truncate,  Next: try,  Prev: Trunc,  Up: Reference

Truncate
========

(Under construction.)

Synopsis
--------

     procedure Truncate (var F: ANY_FILE);

Description
-----------

Conforming to
-------------

`Truncate' is a Borland Pascal extension.

Example
-------

See also
--------


File: gpc.info,  Node: try,  Next: type,  Prev: Truncate,  Up: Reference

try
===

Not yet implemented.

Synopsis
--------

Conforming to
-------------

`try' is a Borland Delphi extension.

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: type,  Next: type of,  Prev: try,  Up: Reference

type
====

Synopsis
--------

As a type declaration:
     type
       TYPE_INDENTIFIER = TYPE_DEFINITION;
   or with initialization:
     type
       TYPE_INDENTIFIER = TYPE_DEFINITION value CONSTANT_EXPRESSION;

Description
-----------

The reserved word `type' starts the declaration of a TYPE IDENTIFIER
which is defined by TYPE_DEFINITION. For further description see *Note
Type Declaration::, *Note Type Declaration::, *Note Type Definition::,
*Note Data Types::.

Conforming to
-------------

`type' is defined in ISO 7185 Pascal and supported by all known Pascal
variants. Initializers are an ISO 10206 Extended Pascal extension.

Example
-------

     program TypeDemo;
     type
       { This side is the }    { That side is the }
       { type declaration }    { type definition  }

       { array type }
       ArrayType                  = array [0 .. 9] of Integer;

       { record type }
       RecordType                 = record
                                      Bar: Integer
                                    end;

       { subrange type }
       SubrangeType               = -123 .. 456;

       { enumeration type }
       EnumeratedType             = (Mon, Tue, Wed, Thu, Fri, Sat, Sun);

       { set type }
       CharSetType                = set of Char;

       { object type }
       ObjectType                 = object
                                      constructor Init;
                                      procedure Method;
                                      destructor Done
                                    end;

       { pointer type to another type identifier }
       PArrayType                 = ^ArrayType;

       { an alias name for another type identifier }
       IntegerType                = Integer;

       { an integer which is initialized by 123 }
       InitializedInt             = Integer value 123;

       { a schema with discriminants x and y of type Integer }
       SchemaType (x, y: Integer) = array [x .. y] of Integer;

     { Dummy methods of the object type }
     constructor ObjectType.Init;
     begin
     end;

     procedure ObjectType.Method;
     begin
     end;

     destructor ObjectType.Done;
     begin
     end;

     begin
     end.

See also
--------

*Note Keywords::, *Note Type Declaration::, *Note Type Definition::,
*Note Data Types::, *Note Variable Declaration::, *Note array::, *Note
record::, *Note object::, *Note set::, *Note Pointer::, *Note value::.


File: gpc.info,  Node: type of,  Next: TypeOf,  Prev: type,  Up: Reference

type of
=======

(Under construction.)

Synopsis
--------

Description
-----------

Conforming to
-------------

Example
-------

See also
--------

*Note Keywords::.


File: gpc.info,  Node: TypeOf,  Next: Unbind,  Prev: type of,  Up: Reference

TypeOf
======

Synopsis
--------

     function TypeOf (var x): PObjectType;

Description
-----------

Returns a pointer to the VMT of an _object_ type or variable.  This
pointer can be used to identify the type of an object.

   `TypeOf' can be applied to expressions of object type and to object
type names. In the former case, the actual type of polymorphic objects
is returned.

Conforming to
-------------

`TypeOf' is a Borland Pascal extension.

Example
-------

     program TypeOfDemo;
     type
       FooPtr = ^Foo;
       BarPtr = ^Bar;

       Foo = object         { Has a VMT, though it doesn't }
         x: Integer;        { contain virtual methods.     }
         constructor Init;
       end;

       Bar = object (Foo)
         y: Integer;
       end;

     constructor Foo.Init;
     begin
     end;

     var
       MyFoo: FooPtr;

     begin
       MyFoo := New (BarPtr, Init);
       if TypeOf (MyFoo^) = TypeOf (Bar) then  { True }
         WriteLn ('OK')
     end.

See also
--------

*Note BitSizeOf::, *Note AlignOf::, *Note PObjectType::, *Note
SetType::, *Note SizeOf::, *Note OOP::.

