/*
PDCurses/X11 specific include file for crtc.c

Catching the interrupt signal as well as refreshing the window and
GetShiftState are implemented; Sound and NoSound are not. Changing
the size of the screen after receiving a WINCH signal is implemented,
but TextMode cannot generate this signal.

Copyright (C) 1998-99 Free Software Foundation, Inc.

Author: Frank Heckenbach <frank@pascal.gnu.de>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation, version 2.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; see the file COPYING.LIB.
If not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

As a special exception, if you link this library with files compiled
with a GNU compiler to produce an executable, this does not cause
the resulting executable to be covered by the GNU Library General
Public License. This exception does not however invalidate any other
reasons why the executable file might be covered by the GNU Library
General Public License.
*/

#include "crtunix1.h"

static void crt_settextmode (Boolean Columns40, Boolean Lines50)
{
  (void) Columns40;
  (void) Lines50;
}

int crt_getshiftstate ()
{
  int state = crt_VirtualShiftState;
  unsigned long modifiers = PDC_get_key_modifiers ();
  if (modifiers & PDC_KEY_MODIFIER_SHIFT  ) state |= shShift;
  if (modifiers & PDC_KEY_MODIFIER_CONTROL) state |= shCtrl;
  if (modifiers & PDC_KEY_MODIFIER_ALT    ) state |= shAlt;
  if (modifiers & PDC_KEY_MODIFIER_MOD4   ) state |= shExtra;
  if (modifiers & PDC_KEY_MODIFIER_MOD3   ) state = shAltGr;
  return state;
}

#ifdef CRT_DUMMY_SOUND
void crt_sound (unsigned Hz)
{
}

void crt_nosound ()
{
}
#endif

static void crt_special_init ()
{
  crt_special_init1 ();
}

static void crt_special_done ()
{
}
