/*
Linux/x86 specific include file for crtc.c

Notes:

- TextMode, Sound, NoSound and GetShiftState only work on local consoles.

- Changing the number of screen columns is not implemented.

- Changing the number of rows requires the programs resizecons, setfont
  and loadunimap to be present in the PATH, and requires root permissions,
  either to the program compiled with CRT or to resizecons. (To achieve
  the latter, once do a "chmod u+s `which resizecons`" as root, but only
  if you really want each user to be allowed to change the console size.)
  The command lines called for the different modi are stored as CStrings
  in the variables crt_setfont_command_80_25, crt_setfont_command_80_50,
  crt_setfont_command_40_25 and crt_setfont_command_40_50, so you can
  change them when necessary. (These variables are not present on other
  platforms!)

Copyright (C) 1998-99 Free Software Foundation, Inc.

Author: Frank Heckenbach <frank@pascal.gnu.de>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation, version 2.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; see the file COPYING.LIB.
If not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

As a special exception, if you link this library with files compiled
with a GNU compiler to produce an executable, this does not cause
the resulting executable to be covered by the GNU Library General
Public License. This exception does not however invalidate any other
reasons why the executable file might be covered by the GNU Library
General Public License.
*/

#include <stdlib.h>
#include <unistd.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <asm/ioctls.h>
#include <linux/kd.h>
#include "crtunix1.h"

char *crt_setfont_command_80_25 = "setfont cp850-8x16 -u cp437",
     *crt_setfont_command_80_50 = "setfont cp850-8x8 -u cp437",
     *crt_setfont_command_40_25 = "setfont cp850-8x16 -u cp437", /* not supported, as far... */
     *crt_setfont_command_40_50 = "setfont cp850-8x8 -u cp437";  /* ...as I could find out */

static void crt_settextmode (Boolean Columns40, Boolean Lines50)
{
  /* This is similar to system(), but system() gets interrupted by SIGWINCH */
  pid_t pid = fork ();
  if (pid > 0)
    {
      int wpid, wstatus;
      crt_Signaled = FALSE;
      do
        wpid = waitpid (pid, &wstatus, 0);
      while (wpid < 0 && errno == EINTR && !crt_Signaled);
    }
  else if (pid == 0)
    {
      char *argv [4] = { "sh", "-c", NULL, NULL };
      argv [2] = Columns40
                 ? (Lines50 ? crt_setfont_command_40_50 : crt_setfont_command_40_25)
                 : (Lines50 ? crt_setfont_command_80_50 : crt_setfont_command_80_25);
      execve ("/bin/sh", argv, crt_get_c_environment ());
      _exit (127);
    }
}

int crt_getshiftstate ()
{
  int state = crt_VirtualShiftState, arg = 6; /* TIOCLINUX function #6 */
  if (ioctl (0, TIOCLINUX, &arg) == 0)
    {
      if (arg & (1 | 16)) state |= shLeftShift;
      if (arg & (1 | 32)) state |= shRightShift;
      if (arg & 4)        state |= shCtrl;
      if (arg & 8)        state |= shLeftAlt;
      if (arg & 2)        state |= shRightAlt;
      if (arg & 64)       state |= shExtra;
    }
  return state;
}

void crt_sound (unsigned Hz)
{
  ioctl (1, KIOCSOUND, 1193181 / Hz);
}

void crt_nosound ()
{
  ioctl (1, KIOCSOUND, 0);
}

static void crt_special_init ()
{
  crt_special_init1 ();
}

static void crt_special_done ()
{
}
