/*
Dummy include file for crtc.c

The include files like crtdummy.h, crtunix.h, crtlinux386.h and crtdospc.h
contain those parts of CRT that cannot be done in a portable way.
These are 5 things:

- changing the screen size with TextMode,

- catching INT (Ctrl-C) and/or TERM and HUP signals to let them be
  treated by CRT, dependent on CheckBreak,

- playing sounds with Sound and NoSound,

- getting the keyboard shift state,

- refreshing the window promptly and fast.

All of these things are not crucial to CRT's operation, CRT will work
reasonably well without them. This file (crtdummy.h) provides dummy
functions that do nothing. It will be used on any system where no
special version exists.

To port this to a new system, do the following:

- copy the functions below to a new file,

- add a statement to #include that file, together with suitable #ifdefs,
  in crtc.c,

- fill in the functions as far as possible on the system.

The functions that can be implemented are the following. All functions
except crt_getshiftstate(), crt_sound() and crt_nosound() should be static.

special_crt_init():
any initialization the code here needs

special_crt_done():
any finalization the code here needs

crt_schedule_refresh():
a function that can call crt_refresh(), either immediately, or delayed
(e.g. using a timer signal).
- calling crt_refresh() immediately (e.g. crtdospc.h) is useful if curses'
  wrefresh() does not take a long time, like PDCurses under DJGPP which
  uses direct hardware access. The CRT window will then always be up to
  date. However, if wrefresh() takes a long time, this will slow down the
  program substantially.
- calling crt_refresh() delayed (e.g. crtlinux386.h): By using a timer,
  the number of calls to wrefresh() can be reduced so the program will
  not be slowed down too much. On the other hand, the timer guarantees
  that the window will not lag behind more than a specified amount of
  time. crt_refresh() is re-entrant, so the timer signal handler can call
  it without worries. Also, crt_schedule_refresh() will not be called when
  there is a pending refresh (i.e. crt_schedule_refresh() was called, but
  crt_refresh() was not called since then), so it can set the timer without
  worrying about disturbing a previously scheduled refresh.

crt_stop_refresh():
a function that is called before a Delay is started, a (blocking) read
is done, a child process is executed, or the update level is changed,
i.e. when a scheduled refresh should not be done any more because it or
its timer event might disturb another operation. If crt_schedule_refresh()
has set a timer, this function must clear it, otherwise it might interfere
with the Delay or the read, so e.g. Delay might get too short or the
read will not read in all characters. crt_refresh() will be called after
this function, so the timer can safely be cleared without losing the
refresh.

crt_settextmode():
a function that takes two boolean arguments, and sets the screen
to 40/80 columns and 25/50 (or 43) lines, depending on the arguments.
When successful, it must set crt_screen_size_changed.

crt_getshiftstate():
a procedure that returns the keyboard shift state as a combination
of the shFoo constants, ORed with the value of the variable
crt_VirtualShiftState.

crt_sound():
a procedure that starts playing a sound of the given frequency, until
the next crt_sound() or crt_nosound() call

crt_nosound():
a procedure that stops playing the sound

crt_sound() and crt_nosound() are optional. If they are not provided, a
program that uses sound will fail with linking errors. That may be intended.
This file normally does not provide these functions. Only when
CRT_DUMMY_SOUND is defined, it will provide empty crt_sound/crt_nosound
functions, so programs using sound will compile, but simply not play any
sound. System-specific include files that do not provide sound capabilites
(e.g. crtunix.h) should do the same.

To provide the CheckBreak capability, the code must arrange for
crt_signal_handler() as declared in crtc.c, to be called whenever an
INT, TERM or similar signal is received, giving it as an argument a
pseudo key code for the signal, and it must make sure that the program
is not aborted by the signal. Reading a character from the curses
window should be interrupted by the signal (which ought to happen by
default), in order for the program to receive the pseudo key immediately.

Copyright (C) 1998-99 Free Software Foundation, Inc.

Author: Frank Heckenbach <frank@pascal.gnu.de>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation, version 2.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; see the file COPYING.LIB.
If not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

As a special exception, if you link this library with files compiled
with a GNU compiler to produce an executable, this does not cause
the resulting executable to be covered by the GNU Library General
Public License. This exception does not however invalidate any other
reasons why the executable file might be covered by the GNU Library
General Public License.
*/

static inline void crt_schedule_refresh ()
{
  crt_refresh ();
}

static void crt_stop_refresh ()
{
}

static void crt_settextmode (Boolean Columns40, Boolean Lines50)
{
}

int crt_getshiftstate ()
{
  return crt_VirtualShiftState;
}

#ifdef CRT_DUMMY_SOUND
void crt_sound (unsigned Hz)
{
}

void crt_nosound ()
{
}
#endif

static inline void crt_special_init ()
{
}

static inline void crt_special_done ()
{
}
