This is Info file gpc.info, produced by Makeinfo version 1.68 from the
input file /djgpp/gnu/gcc-2.81/p/doc/gpc.texi.

   This file documents the use and the internals of the GNU Pascal
compiler.

   Copyright (C) 1988, 1996 Free Software Foundation, Inc.

   Permission is granted to make and distribute verbatim copies of this
manual provided the copyright notice and this permission notice are
preserved on all copies.

   Permission is granted to copy and distribute modified versions of
this manual under the conditions for verbatim copying, provided also
that the sections entitled "GNU General Public License," "Funding for
Free Software," and "Protect Your Freedom--Fight `Look And Feel'" are
included exactly as in the original, and provided that the entire
resulting derived work is distributed under the terms of a permission
notice identical to this one.

   Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that the sections entitled "GNU General Public
License," "Funding for Free Software," and "Protect Your Freedom--Fight
`Look And Feel'", and this permission notice, may be included in
translations approved by the Free Software Foundation instead of in the
original English.


File: gpc.info,  Node: Link Options,  Next: Directory Options,  Prev: Assembler Options,  Up: Invoking GPC

Options for Linking
===================

   These options come into play when the compiler links object files
into an executable output file.  They are meaningless if the compiler is
not doing a link step.

`OBJECT-FILE-NAME'
     A file name that does not end in a special recognized suffix is
     considered to name an object file or library.  (Object files are
     distinguished from libraries by the linker according to the file
     contents.)  If linking is done, these object files are used as
     input to the linker.

`-c'
`-S'
`-E'
     If any of these options is used, then the linker is not run, and
     object file names should not be used as arguments.  *Note Overall
     Options::.

`-lLIBRARY'
     Search the library named LIBRARY when linking.

     It makes a difference where in the command you write this option;
     the linker searches processes libraries and object files in the
     order they are specified.  Thus, `foo.o -lz bar.o' searches
     library `z' after file `foo.o' but before `bar.o'.  If `bar.o'
     refers to functions in `z', those functions may not be loaded.

     The linker searches a standard list of directories for the library,
     which is actually a file named `libLIBRARY.a'.  The linker then
     uses this file as if it had been specified precisely by name.

     The directories searched include several standard system
     directories plus any that you specify with `-L'.

     Normally the files found this way are library files--archive files
     whose members are object files.  The linker handles an archive
     file by scanning through it for members which define symbols that
     have so far been referenced but not defined.  But if the file that
     is found is an ordinary object file, it is linked in the usual
     fashion.  The only difference between using an `-l' option and
     specifying a file name is that `-l' surrounds LIBRARY with `lib'
     and `.a' and searches several directories.

`-lobjc'
     You need this special case of the `-l' option in order to link an
     Objective C program.

`-nostartfiles'
     Do not use the standard system startup files when linking.  The
     standard system libraries are used normally, unless `-nostdlib' or
     `-nodefaultlibs' is used.

`-nodefaultlibs'
     Do not use the standard system libraries when linking.  Only the
     libraries you specify will be passed to the linker.  The standard
     startup files are used normally, unless `-nostartfiles' is used.

`-nostdlib'
     Do not use the standard system startup files or libraries when
     linking.  No startup files and only the libraries you specify will
     be passed to the linker.

     One of the standard libraries bypassed by `-nostdlib' and
     `-nodefaultlibs' is `libgcc.a', a library of internal subroutines
     that GNU Pascal uses to overcome shortcomings of particular
     machines, or special needs for some languages.  In most cases, you
     need `libgcc.a' even when you want to avoid other standard
     libraries.  In other words, when you specify `-nostdlib' or
     `-nodefaultlibs' you should usually specify `-lgcc' as well.  This
     ensures that you have no unresolved references to internal GNU
     Pascal library subroutines.  (For example, `__main', used to
     ensure C++ constructors will be called;

`-s'
     Remove all symbol table and relocation information from the
     executable.

`-static'
     On systems that support dynamic linking, this prevents linking
     with the shared libraries.  On other systems, this option has no
     effect.

`-shared'
     Produce a shared object which can then be linked with other
     objects to form an executable.  Only a few systems support this
     option.

`-symbolic'
     Bind references to global symbols when building a shared object.
     Warn about any unresolved references (unless overridden by the
     link editor option `-Xlinker -z -Xlinker defs').  Only a few
     systems support this option.

`-Xlinker OPTION'
     Pass OPTION as an option to the linker.  You can use this to
     supply system-specific linker options which GNU Pascal does not
     know how to recognize.

     If you want to pass an option that takes an argument, you must use
     `-Xlinker' twice, once for the option and once for the argument.
     For example, to pass `-assert definitions', you must write
     `-Xlinker -assert -Xlinker definitions'.  It does not work to write
     `-Xlinker "-assert definitions"', because this passes the entire
     string as a single argument, which is not what the linker expects.

`-Wl,OPTION'
     Pass OPTION as an option to the linker.  If OPTION contains
     commas, it is split into multiple options at the commas.

`-u SYMBOL'
     Pretend the symbol SYMBOL is undefined, to force linking of
     library modules to define it.  You can use `-u' multiple times with
     different symbols to force loading of additional library modules.


File: gpc.info,  Node: Directory Options,  Next: Target Options,  Prev: Link Options,  Up: Invoking GPC

Options for Directory Search
============================

   These options specify directories to search for header files, for
libraries and for parts of the compiler:

`-IDIR'
     Add the directory DIRECTORY to the head of the list of directories
     to be searched for header files.  This can be used to override a
     system header file, substituting your own version, since these
     directories are searched before the system header file
     directories.  If you use more than one `-I' option, the
     directories are scanned in left-to-right order; the standard
     system directories come after.

`-I-'
     Any directories you specify with `-I' options before the `-I-'
     option are searched only for the case of `#include "FILE"'; they
     are not searched for `#include <FILE>'.

     If additional directories are specified with `-I' options after
     the `-I-', these directories are searched for all `#include'
     directives.  (Ordinarily *all* `-I' directories are used this way.)

     In addition, the `-I-' option inhibits the use of the current
     directory (where the current input file came from) as the first
     search directory for `#include "FILE"'.  There is no way to
     override this effect of `-I-'.  With `-I.' you can specify
     searching the directory which was current when the compiler was
     invoked.  That is not exactly the same as what the preprocessor
     does by default, but it is often satisfactory.

     `-I-' does not inhibit the use of the standard system directories
     for header files.  Thus, `-I-' and `-nostdinc' are independent.

`-LDIR'
     Add directory DIR to the list of directories to be searched for
     `-l'.

`-BPREFIX'
     This option specifies where to find the executables, libraries,
     include files, and data files of the compiler itself.

     The compiler driver program runs one or more of the subprograms
     `cpp', `cc1', `as' and `ld'.  It tries PREFIX as a prefix for each
     program it tries to run, both with and without `MACHINE/VERSION/'
     (*note Target Options::.).

     For each subprogram to be run, the compiler driver first tries the
     `-B' prefix, if any.  If that name is not found, or if `-B' was
     not specified, the driver tries two standard prefixes, which are
     `/usr/lib/gcc/' and `/usr/local/lib/gcc-lib/'.  If neither of
     those results in a file name that is found, the unmodified program
     name is searched for using the directories specified in your
     `PATH' environment variable.

     `-B' prefixes that effectively specify directory names also apply
     to libraries in the linker, because the compiler translates these
     options into `-L' options for the linker.  They also apply to
     includes files in the preprocessor, because the compiler
     translates these options into `-isystem' options for the
     preprocessor.  In this case, the compiler appends `include' to the
     prefix.

     The run-time support file `libgcc.a' can also be searched for using
     the `-B' prefix, if needed.  If it is not found there, the two
     standard prefixes above are tried, and that is all.  The file is
     left out of the link if it is not found by those means.

     Another way to specify a prefix much like the `-B' prefix is to use
     the environment variable `GPC_EXEC_PREFIX'.  *Note Environment
     Variables::.


File: gpc.info,  Node: Target Options,  Next: Submodel Options,  Prev: Directory Options,  Up: Invoking GPC

Specifying Target Machine and Compiler Version
==============================================

   By default, GNU Pascal compiles code for the same type of machine
that you are using.  However, it can also be installed as a
cross-compiler, to compile for some other type of machine.  In fact,
several different configurations of GNU Pascal, for different target
machines, can be installed side by side.  Then you specify which one to
use with the `-b' option.

   In addition, older and newer versions of GNU Pascal can be installed
side by side.  One of them (probably the newest) will be the default,
but you may sometimes wish to use another.

`-b MACHINE'
     The argument MACHINE specifies the target machine for compilation.
     This is useful when you have installed GNU Pascal as a
     cross-compiler.

     The value to use for MACHINE is the same as was specified as the
     machine type when configuring GNU Pascal as a cross-compiler.  For
     example, if a cross-compiler was configured with `configure
     i386v', meaning to compile for an 80386 running System V, then you
     would specify `-b i386v' to run that cross compiler.

     When you do not specify `-b', it normally means to compile for the
     same type of machine that you are using.

`-V VERSION'
     The argument VERSION specifies which version of GNU Pascal to run.
     This is useful when multiple versions are installed.  For example,
     VERSION might be `2.0', meaning to run GNU Pascal version 2.0.

     The default version, when you do not specify `-V', is the last
     version of GNU Pascal that you installed.

   The `-b' and `-V' options actually work by controlling part of the
file name used for the executable files and libraries used for
compilation.  A given version of GNU Pascal, for a given target
machine, is normally kept in the directory
`/usr/local/lib/gcc-lib/MACHINE/VERSION'.

   Thus, sites can customize the effect of `-b' or `-V' either by
changing the names of these directories or adding alternate names (or
symbolic links).  If in directory `/usr/local/lib/gcc-lib/' the file
`80386' is a link to the file `i386v', then `-b 80386' becomes an alias
for `-b i386v'.

   In one respect, the `-b' or `-V' do not completely change to a
different compiler: the top-level driver program `gpc' that you
originally invoked continues to run and invoke the other executables
(preprocessor, compiler per se, assembler and linker) that do the real
work.  However, since no real work is done in the driver program, it
usually does not matter that the driver program in use is not the one
for the specified target and version.

   The only way that the driver program depends on the target machine is
in the parsing and handling of special machine-specific options.
However, this is controlled by a file which is found, along with the
other executables, in the directory for the specified version and
target machine.  As a result, a single installed driver program adapts
to any specified target machine and compiler version.

   The driver program executable does control one significant thing,
however: the default version and target machine.  Therefore, you can
install different instances of the driver program, compiled for
different targets or versions, under different names.

   For example, if the driver for version 2.0 is installed as `ogcc'
and that for version 2.1 is installed as `gpc', then the command `gpc'
will use version 2.1 by default, while `ogcc' will use 2.0 by default.
However, you can choose either version with either command with the
`-V' option.


File: gpc.info,  Node: Submodel Options,  Next: Environment Variables,  Prev: Target Options,  Up: Invoking GPC

Hardware Models and Configurations
==================================

   Earlier we discussed the standard option `-b' which chooses among
different installed compilers for completely different target machines,
such as Vax vs. 68000 vs. 80386.

   In addition, each of these target machine types can have its own
special options, starting with `-m', to choose among various hardware
models or configurations--for example, 68010 vs 68020, floating
coprocessor or none.  A single installed version of the compiler can
compile for any model or configuration, according to the options
specified.

   Some configurations of the compiler also support additional special
options, usually for compatibility with other compilers on the same
platform.

   These options are defined by the macro `TARGET_SWITCHES' in the
machine description.  The default for the options is also defined by
that macro, which enables you to change the defaults.

* Menu:

* M680x0 Options::
* VAX Options::
* SPARC Options::
* Convex Options::
* AMD29K Options::
* ARM Options::
* M88K Options::
* RS/6000 and PowerPC Options::
* RT Options::
* MIPS Options::
* i386 Options::
* HPPA Options::
* Intel 960 Options::
* DEC Alpha Options::
* Clipper Options::
* H8/300 Options::
* System V Options::


File: gpc.info,  Node: M680x0 Options,  Next: VAX Options,  Up: Submodel Options

M680x0 Options
--------------

   These are the `-m' options defined for the 68000 series.  The default
values for these options depends on which style of 68000 was selected
when the compiler was configured; the defaults for the most common
choices are given below.

`-m68000'
`-mc68000'
     Generate output for a 68000.  This is the default when the
     compiler is configured for 68000-based systems.

`-m68020'
`-mc68020'
     Generate output for a 68020.  This is the default when the
     compiler is configured for 68020-based systems.

`-m68881'
     Generate output containing 68881 instructions for floating point.
     This is the default for most 68020 systems unless `-nfp' was
     specified when the compiler was configured.

`-m68030'
     Generate output for a 68030.  This is the default when the
     compiler is configured for 68030-based systems.

`-m68040'
     Generate output for a 68040.  This is the default when the
     compiler is configured for 68040-based systems.

     This option inhibits the use of 68881/68882 instructions that have
     to be emulated by software on the 68040.  If your 68040 does not
     have code to emulate those instructions, use `-m68040'.

`-m68020-40'
     Generate output for a 68040, without using any of the new
     instructions.  This results in code which can run relatively
     efficiently on either a 68020/68881 or a 68030 or a 68040.  The
     generated code does use the 68881 instructions that are emulated
     on the 68040.

`-mfpa'
     Generate output containing Sun FPA instructions for floating point.

`-msoft-float'
     Generate output containing library calls for floating point.
     *Warning:* the requisite libraries are not available for all m68k
     targets.  Normally the facilities of the machine's usual C
     compiler are used, but this can't be done directly in
     cross-compilation.  You must make your own arrangements to provide
     suitable library functions for cross-compilation.  The embedded
     targets `m68k-*-aout' and `m68k-*-coff' do provide software
     floating point support.

`-mshort'
     Consider type `int' to be 16 bits wide, like `short int'.

`-mnobitfield'
     Do not use the bit-field instructions.  The `-m68000' option
     implies `-mnobitfield'.

`-mbitfield'
     Do use the bit-field instructions.  The `-m68020' option implies
     `-mbitfield'.  This is the default if you use a configuration
     designed for a 68020.

`-mrtd'
     Use a different function-calling convention, in which functions
     that take a fixed number of arguments return with the `rtd'
     instruction, which pops their arguments while returning.  This
     saves one instruction in the caller since there is no need to pop
     the arguments there.

     This calling convention is incompatible with the one normally used
     on Unix, so you cannot use it if you need to call libraries
     compiled with the Unix compiler.

     Also, you must provide function prototypes for all functions that
     take variable numbers of arguments (including `printf'); otherwise
     incorrect code will be generated for calls to those functions.

     In addition, seriously incorrect code will result if you call a
     function with too many arguments.  (Normally, extra arguments are
     harmlessly ignored.)

     The `rtd' instruction is supported by the 68010 and 68020
     processors, but not by the 68000.


File: gpc.info,  Node: VAX Options,  Next: SPARC Options,  Prev: M680x0 Options,  Up: Submodel Options

VAX Options
-----------

   These `-m' options are defined for the Vax:

`-munix'
     Do not output certain jump instructions (`aobleq' and so on) that
     the Unix assembler for the Vax cannot handle across long ranges.

`-mgnu'
     Do output those jump instructions, on the assumption that you will
     assemble with the GNU assembler.

`-mg'
     Output code for g-format floating point numbers instead of
     d-format.


File: gpc.info,  Node: SPARC Options,  Next: Convex Options,  Prev: VAX Options,  Up: Submodel Options

SPARC Options
-------------

   These `-m' switches are supported on the SPARC:

`-mno-app-regs'
`-mapp-regs'
     Specify `-mapp-regs' to generate output using the global registers
     2 through 4, which the SPARC SVR4 ABI reserves for applications.
     This is the default.

     To be fully SVR4 ABI compliant at the cost of some performance
     loss, specify `-mno-app-regs'.  You should compile libraries and
     system software with this option.

`-mfpu'
`-mhard-float'
     Generate output containing floating point instructions.  This is
     the default.

`-mno-fpu'
`-msoft-float'
     Generate output containing library calls for floating point.
     *Warning:* the requisite libraries are not available for all SPARC
     targets.  Normally the facilities of the machine's usual C
     compiler are used, but this cannot be done directly in
     cross-compilation.  You must make your own arrangements to provide
     suitable library functions for cross-compilation.  The embedded
     targets `sparc-*-aout' and `sparclite-*-*' do provide software
     floating point support.

     `-msoft-float' changes the calling convention in the output file;
     therefore, it is only useful if you compile *all* of a program with
     this option.  In particular, you need to compile `libgcc.a', the
     library that comes with GNU Pascal, with `-msoft-float' in order
     for this to work.

`-mhard-quad-float'
     Generate output containing quad-word (long double) floating point
     instructions.

`-msoft-quad-float'
     Generate output containing library calls for quad-word (long
     double) floating point instructions.  The functions called are
     those specified in the SPARC ABI.  This is the default.

     As of this writing, there are no sparc implementations that have
     hardware support for the quad-word floating point instructions.
     They all invoke a trap handler for one of these instructions, and
     then the trap handler emulates the effect of the instruction.
     Because of the trap handler overhead, this is much slower than
     calling the ABI library routines.  Thus the `-msoft-quad-float'
     option is the default.

`-mno-epilogue'
`-mepilogue'
     With `-mepilogue' (the default), the compiler always emits code for
     function exit at the end of each function.  Any function exit in
     the middle of the function (such as a return statement in C) will
     generate a jump to the exit code at the end of the function.

     With `-mno-epilogue', the compiler tries to emit exit code inline
     at every function exit.

`-mno-flat'
`-mflat'
     With `-mflat', the compiler does not generate save/restore
     instructions and will use a "flat" or single register window
     calling convention.  This model uses %i7 as the frame pointer and
     is compatible with the normal register window model.  Code from
     either may be intermixed although debugger support is still
     incomplete.  The local registers and the input registers (0-5) are
     still treated as "call saved" registers and will be saved on the
     stack as necessary.

     With `-mno-flat' (the default), the compiler emits save/restore
     instructions (except for leaf functions) and is the normal mode of
     operation.

`-mno-unaligned-doubles'
`-munaligned-doubles'
     Assume that doubles have 8 byte alignment.  This is the default.

     With `-munaligned-doubles', GNU Pascal assumes that doubles have 8
     byte alignment only if they are contained in another type, or if
     they have an absolute address.  Otherwise, it assumes they have 4
     byte alignment.  Specifying this option avoids some rare
     compatibility problems with code generated by other compilers.  It
     is not the default because it results in a performance loss,
     especially for floating point code.

`-mv8'
`-msparclite'
     These two options select variations on the SPARC architecture.

     By default (unless specifically configured for the Fujitsu
     SPARClite), GPC generates code for the v7 variant of the SPARC
     architecture.

     `-mv8' will give you SPARC v8 code.  The only difference from v7
     code is that the compiler emits the integer multiply and integer
     divide instructions which exist in SPARC v8 but not in SPARC v7.

     `-msparclite' will give you SPARClite code.  This adds the integer
     multiply, integer divide step and scan (`ffs') instructions which
     exist in SPARClite but not in SPARC v7.

`-mcypress'
`-msupersparc'
     These two options select the processor for which the code is
     optimised.

     With `-mcypress' (the default), the compiler optimizes code for the
     Cypress CY7C602 chip, as used in the SparcStation/SparcServer 3xx
     series.  This is also appropriate for the older SparcStation 1, 2,
     IPX etc.

     With `-msupersparc' the compiler optimizes code for the SuperSparc
     cpu, as used in the SparcStation 10, 1000 and 2000 series. This
     flag also enables use of the full SPARC v8 instruction set.

   In a future version of GPC, these options will very likely be
renamed to `-mcpu=cypress' and `-mcpu=supersparc'.

   These `-m' switches are supported in addition to the above on SPARC
V9 processors:

`-mmedlow'
     Generate code for the Medium/Low code model: assume a 32 bit
     address space.  Programs are statically linked, PIC is not
     supported.  Pointers are still 64 bits.

     It is very likely that a future version of GPC will rename this
     option.

`-mmedany'
     Generate code for the Medium/Anywhere code model: assume a 32 bit
     text segment starting at offset 0, and a 32 bit data segment
     starting anywhere (determined at link time).  Programs are
     statically linked, PIC is not supported.  Pointers are still 64
     bits.

     It is very likely that a future version of GPC will rename this
     option.

`-mint64'
     Types long and int are 64 bits.

`-mlong32'
     Types long and int are 32 bits.

`-mlong64'
`-mint32'
     Type long is 64 bits, and type int is 32 bits.

`-mstack-bias'
`-mno-stack-bias'
     With `-mstack-bias', GNU Pascal assumes that the stack pointer, and
     frame pointer if present, are offset by -2047 which must be added
     back when making stack frame references.  Otherwise, assume no
     such offset is present.


File: gpc.info,  Node: Convex Options,  Next: AMD29K Options,  Prev: SPARC Options,  Up: Submodel Options

Convex Options
--------------

   These `-m' options are defined for Convex:

`-mc1'
     Generate output for C1.  The code will run on any Convex machine.
     The preprocessor symbol `__convex__c1__' is defined.

`-mc2'
     Generate output for C2.  Uses instructions not available on C1.
     Scheduling and other optimizations are chosen for max performance
     on C2.  The preprocessor symbol `__convex_c2__' is defined.

`-mc32'
     Generate output for C32xx.  Uses instructions not available on C1.
     Scheduling and other optimizations are chosen for max performance
     on C32.  The preprocessor symbol `__convex_c32__' is defined.

`-mc34'
     Generate output for C34xx.  Uses instructions not available on C1.
     Scheduling and other optimizations are chosen for max performance
     on C34.  The preprocessor symbol `__convex_c34__' is defined.

`-mc38'
     Generate output for C38xx.  Uses instructions not available on C1.
     Scheduling and other optimizations are chosen for max performance
     on C38.  The preprocessor symbol `__convex_c38__' is defined.

`-margcount'
     Generate code which puts an argument count in the word preceding
     each argument list.  This is compatible with regular CC, and a few
     programs may need the argument count word.  GDB and other
     source-level debuggers do not need it; this info is in the symbol
     table.

`-mnoargcount'
     Omit the argument count word.  This is the default.

`-mvolatile-cache'
     Allow volatile references to be cached.  This is the default.

`-mvolatile-nocache'
     Volatile references bypass the data cache, going all the way to
     memory.  This is only needed for multi-processor code that does
     not use standard synchronization instructions.  Making
     non-volatile references to volatile locations will not necessarily
     work.

`-mlong32'
     Type long is 32 bits, the same as type int.  This is the default.

`-mlong64'
     Type long is 64 bits, the same as type long long.  This option is
     useless, because no library support exists for it.


File: gpc.info,  Node: AMD29K Options,  Next: ARM Options,  Prev: Convex Options,  Up: Submodel Options

AMD29K Options
--------------

   These `-m' options are defined for the AMD Am29000:

`-mdw'
     Generate code that assumes the `DW' bit is set, i.e., that byte and
     halfword operations are directly supported by the hardware.  This
     is the default.

`-mndw'
     Generate code that assumes the `DW' bit is not set.

`-mbw'
     Generate code that assumes the system supports byte and halfword
     write operations.  This is the default.

`-mnbw'
     Generate code that assumes the systems does not support byte and
     halfword write operations.  `-mnbw' implies `-mndw'.

`-msmall'
     Use a small memory model that assumes that all function addresses
     are either within a single 256 KB segment or at an absolute
     address of less than 256k.  This allows the `call' instruction to
     be used instead of a `const', `consth', `calli' sequence.

`-mnormal'
     Use the normal memory model: Generate `call' instructions only when
     calling functions in the same file and `calli' instructions
     otherwise.  This works if each file occupies less than 256 KB but
     allows the entire executable to be larger than 256 KB.  This is
     the default.

`-mlarge'
     Always use `calli' instructions.  Specify this option if you expect
     a single file to compile into more than 256 KB of code.

`-m29050'
     Generate code for the Am29050.

`-m29000'
     Generate code for the Am29000.  This is the default.

`-mkernel-registers'
     Generate references to registers `gr64-gr95' instead of to
     registers `gr96-gr127'.  This option can be used when compiling
     kernel code that wants a set of global registers disjoint from
     that used by user-mode code.

     Note that when this option is used, register names in `-f' flags
     must use the normal, user-mode, names.

`-muser-registers'
     Use the normal set of global registers, `gr96-gr127'.  This is the
     default.

`-mstack-check'
`-mno-stack-check'
     Insert (or do not insert) a call to `__msp_check' after each stack
     adjustment.  This is often used for kernel code.

`-mstorem-bug'
`-mno-storem-bug'
     `-mstorem-bug' handles 29k processors which cannot handle the
     separation of a mtsrim insn and a storem instruction (most 29000
     chips to date, but not the 29050).

`-mno-reuse-arg-regs'
`-mreuse-arg-regs'
     `-mno-reuse-arg-regs' tells the compiler to only use incoming
     argument registers for copying out arguments.  This helps detect
     calling a function with fewer arguments than it was declared with.

`-msoft-float'
     Generate output containing library calls for floating point.
     *Warning:* the requisite libraries are not part of GNU Pascal.
     Normally the facilities of the machine's usual C compiler are
     used, but this can't be done directly in cross-compilation.  You
     must make your own arrangements to provide suitable library
     functions for cross-compilation.


File: gpc.info,  Node: ARM Options,  Next: M88K Options,  Prev: AMD29K Options,  Up: Submodel Options

ARM Options
-----------

   These `-m' options are defined for Advanced RISC Machines (ARM)
architectures:

`-m2'
`-m3'
     These options are identical.  Generate code for the ARM2 and ARM3
     processors.  This option is the default.  You should also use this
     option to generate code for ARM6 processors that are running with a
     26-bit program counter.

`-m6'
     Generate code for the ARM6 processor when running with a 32-bit
     program counter.

`-mapcs'
     Generate a stack frame that is compliant with the ARM Procedure
     Call Standard for all functions, even if this is not strictly
     necessary for correct execution of the code.

`-mbsd'
     This option only applies to RISC iX.  Emulate the native BSD-mode
     compiler.  This is the default if `-ansi' is not specified.

`-mxopen'
     This option only applies to RISC iX.  Emulate the native
     X/Open-mode compiler.

`-mno-symrename'
     This option only applies to RISC iX.  Do not run the assembler
     post-processor, `symrename', after code has been assembled.
     Normally it is necessary to modify some of the standard symbols in
     preparation for linking with the RISC iX C library; this option
     suppresses this pass.  The post-processor is never run when the
     compiler is built for cross-compilation.


File: gpc.info,  Node: M88K Options,  Next: RS/6000 and PowerPC Options,  Prev: ARM Options,  Up: Submodel Options

M88K Options
------------

   These `-m' options are defined for Motorola 88k architectures:

`-m88000'
     Generate code that works well on both the m88100 and the m88110.

`-m88100'
     Generate code that works best for the m88100, but that also runs
     on the m88110.

`-m88110'
     Generate code that works best for the m88110, and may not run on
     the m88100.

`-mbig-pic'
     Obsolete option to be removed from the next revision.  Use `-fPIC'.

`-midentify-revision'
     Include an `ident' directive in the assembler output recording the
     source file name, compiler name and version, timestamp, and
     compilation flags used.

`-mno-underscores'
     In assembler output, emit symbol names without adding an underscore
     character at the beginning of each name.  The default is to use an
     underscore as prefix on each name.

`-mocs-debug-info'
`-mno-ocs-debug-info'
     Include (or omit) additional debugging information (about
     registers used in each stack frame) as specified in the 88open
     Object Compatibility Standard, "OCS".  This extra information
     allows debugging of code that has had the frame pointer
     eliminated.  The default for DG/UX, SVr4, and Delta 88 SVr3.2 is
     to include this information; other 88k configurations omit this
     information by default.

`-mocs-frame-position'
     When emitting COFF debugging information for automatic variables
     and parameters stored on the stack, use the offset from the
     canonical frame address, which is the stack pointer (register 31)
     on entry to the function.  The DG/UX, SVr4, Delta88 SVr3.2, and
     BCS configurations use `-mocs-frame-position'; other 88k
     configurations have the default `-mno-ocs-frame-position'.

`-mno-ocs-frame-position'
     When emitting COFF debugging information for automatic variables
     and parameters stored on the stack, use the offset from the frame
     pointer register (register 30).  When this option is in effect,
     the frame pointer is not eliminated when debugging information is
     selected by the -g switch.

`-moptimize-arg-area'
`-mno-optimize-arg-area'
     Control how function arguments are stored in stack frames.
     `-moptimize-arg-area' saves space by optimizing them, but this
     conflicts with the 88open specifications.  The opposite
     alternative, `-mno-optimize-arg-area', agrees with 88open
     standards.  By default GNU Pascal does not optimize the argument
     area.

`-mshort-data-NUM'
     Generate smaller data references by making them relative to `r0',
     which allows loading a value using a single instruction (rather
     than the usual two).  You control which data references are
     affected by specifying NUM with this option.  For example, if you
     specify `-mshort-data-512', then the data references affected are
     those involving displacements of less than 512 bytes.
     `-mshort-data-NUM' is not effective for NUM greater than 64k.

`-mserialize-volatile'
`-mno-serialize-volatile'
     Do, or don't, generate code to guarantee sequential consistency of
     volatile memory references.  By default, consistency is guaranteed.

     The order of memory references made by the MC88110 processor does
     not always match the order of the instructions requesting those
     references.  In particular, a load instruction may execute before
     a preceding store instruction.  Such reordering violates
     sequential consistency of volatile memory references, when there
     are multiple processors.   When consistency must be guaranteed,
     GNU Pascal generates special instructions, as needed, to force
     execution in the proper order.

     The MC88100 processor does not reorder memory references and so
     always provides sequential consistency.  However, by default, GNU
     C generates the special instructions to guarantee consistency even
     when you use `-m88100', so that the code may be run on an MC88110
     processor.  If you intend to run your code only on the MC88100
     processor, you may use `-mno-serialize-volatile'.

     The extra code generated to guarantee consistency may affect the
     performance of your application.  If you know that you can safely
     forgo this guarantee, you may use `-mno-serialize-volatile'.

`-msvr4'
`-msvr3'
     Turn on (`-msvr4') or off (`-msvr3') compiler extensions related
     to System V release 4 (SVr4).  This controls the following:

       1. Which variant of the assembler syntax to emit.

       2. `-msvr4' makes the Pascal preprocessor recognize `#pragma
          weak' that is used on System V release 4.

       3. `-msvr4' makes GNU Pascal issue additional declaration
          directives used in SVr4.

     `-msvr4' is the default for the m88k-motorola-sysv4 and
     m88k-dg-dgux m88k configurations. `-msvr3' is the default for all
     other m88k configurations.

`-mversion-03.00'
     This option is obsolete, and is ignored.

`-mno-check-zero-division'
`-mcheck-zero-division'
     Do, or don't, generate code to guarantee that integer division by
     zero will be detected.  By default, detection is guaranteed.

     Some models of the MC88100 processor fail to trap upon integer
     division by zero under certain conditions.  By default, when
     compiling code that might be run on such a processor, GNU C
     generates code that explicitly checks for zero-valued divisors and
     traps with exception number 503 when one is detected.  Use of
     mno-check-zero-division suppresses such checking for code
     generated to run on an MC88100 processor.

     GNU Pascal assumes that the MC88110 processor correctly detects all
     instances of integer division by zero.  When `-m88110' is
     specified, both `-mcheck-zero-division' and
     `-mno-check-zero-division' are ignored, and no explicit checks for
     zero-valued divisors are generated.

`-muse-div-instruction'
     Use the div instruction for signed integer division on the MC88100
     processor.  By default, the div instruction is not used.

     On the MC88100 processor the signed integer division instruction
     div) traps to the operating system on a negative operand.  The
     operating system transparently completes the operation, but at a
     large cost in execution time.  By default, when compiling code
     that might be run on an MC88100 processor, GNU Pascal emulates
     signed integer division using the unsigned integer division
     instruction divu), thereby avoiding the large penalty of a trap to
     the operating system.  Such emulation has its own, smaller,
     execution cost in both time and space.  To the extent that your
     code's important signed integer division operations are performed
     on two nonnegative operands, it may be desirable to use the div
     instruction directly.

     On the MC88110 processor the div instruction (also known as the
     divs instruction) processes negative operands without trapping to
     the operating system.  When `-m88110' is specified,
     `-muse-div-instruction' is ignored, and the div instruction is used
     for signed integer division.

     Note that the result of dividing INT_MIN by -1 is undefined.  In
     particular, the behavior of such a division with and without
     `-muse-div-instruction'  may differ.

`-mtrap-large-shift'
`-mhandle-large-shift'
     Include code to detect bit-shifts of more than 31 bits;
     respectively, trap such shifts or emit code to handle them
     properly.  By default GNU Pascal makes no special provision for
     large bit shifts.

`-mwarn-passed-structs'
     Warn when a function passes a struct as an argument or result.
     Structure-passing conventions have changed during the evolution of
     the C language, and are often the source of portability problems.
     By default, GNU Pascal issues no such warning.


File: gpc.info,  Node: RS/6000 and PowerPC Options,  Next: RT Options,  Prev: M88K Options,  Up: Submodel Options

IBM RS/6000 and PowerPC Options
-------------------------------

   These `-m' options are defined for the IBM RS/6000 and PowerPC:
`-mpower'
`-mno-power'
`-mpower2'
`-mno-power2'
`-mpowerpc'
`-mno-powerpc'
`-mpowerpc-gpopt'
`-mno-powerpc-gpopt'
`-mpowerpc-gfxopt'
`-mno-powerpc-gfxopt'
     GNU Pascal supports two related instruction set architectures for
     the RS/6000 and PowerPC.  The "POWER" instruction set are those
     instructions supported by the `rios' chip set used in the original
     RS/6000 systems and the "PowerPC" instruction set is the
     architecture of the Motorola MPC6xx microprocessors.  The PowerPC
     architecture defines 64-bit instructions, but they are not
     supported by any current processors.

     Neither architecture is a subset of the other.  However there is a
     large common subset of instructions supported by both.  An MQ
     register is included in processors supporting the POWER
     architecture.

     You use these options to specify which instructions are available
     on the processor you are using.  The default value of these
     options is determined when configuring GNU Pascal.  Specifying the
     `-mcpu=CPU_TYPE' overrides the specification of these options.  We
     recommend you use that option rather than these.

     The `-mpower' option allows GNU Pascal to generate instructions
     that are found only in the POWER architecture and to use the MQ
     register.  Specifying `-mpower2' implies `-power' and also allows
     GNU Pascal to generate instructions that are present in the POWER2
     architecture but not the original POWER architecture.

     The `-mpowerpc' option allows GNU Pascal to generate instructions
     that are found only in the 32-bit subset of the PowerPC
     architecture.  Specifying `-mpowerpc-gpopt' implies `-mpowerpc'
     and also allows GNU Pascal to use the optional PowerPC
     architecture instructions in the General Purpose group, including
     floating-point square root.  Specifying `-mpowerpc-gfxopt' implies
     `-mpowerpc' and also allows GNU Pascal to use the optional PowerPC
     architecture instructions in the Graphics group, including
     floating-point select.

     If you specify both `-mno-power' and `-mno-powerpc', GNU Pascal
     will use only the instructions in the common subset of both
     architectures plus some special AIX common-mode calls, and will
     not use the MQ register.  Specifying both `-mpower' and `-mpowerpc'
     permits GNU Pascal to use any instruction from either architecture
     and to allow use of the MQ register; specify this for the Motorola
     MPC601.

`-mnew-mnemonics'
`-mold-mnemonics'
     Select which mnemonics to use in the generated assembler code.
     `-mnew-mnemonics' requests output that uses the assembler mnemonics
     defined for the PowerPC architecture, while `-mold-mnemonics'
     requests the assembler mnemonics defined for the POWER
     architecture.  Instructions defined in only one architecture have
     only one mnemonic; GNU Pascal uses that mnemonic irrespective of
     which of these options is specified.

     PowerPC assemblers support both the old and new mnemonics, as will
     later POWER assemblers.  Current POWER assemblers only support the
     old mnemonics.  Specify `-mnew-mnemonics' if you have an assembler
     that supports them, otherwise specify `-mold-mnemonics'.

     The default value of these options depends on how GNU Pascal was
     configured.  Specifying `-mcpu=CPU_TYPE' sometimes overrides the
     value of these option.  Unless you are building a cross-compiler,
     you should normally not specify either `-mnew-mnemonics' or
     `-mold-mnemonics', but should instead accept the default.

`-mcpu=CPU_TYPE'
     Set architecture type, register usage, choice of mnemonics, and
     instruction scheduling parameters for machine type CPU_TYPE.  By
     default, CPU_TYPE is the target system defined when GNU Pascal was
     configured.  Supported values for CPU_TYPE are `rios1', `rios2',
     `rsc', `601', `603', `604', `power', `powerpc', `403', and
     `common'.  `-mcpu=power' and `-mcpu=powerpc' specify generic POWER
     and pure PowerPC (i.e., not MPC601) architecture machine types,
     with an appropriate, generic processor model assumed for
     scheduling purposes.

     Specifying `-mcpu=rios1', `-mcpu=rios2', `-mcpu=rsc', or
     `-mcpu=power' enables the `-mpower' option and disables the
     `-mpowerpc' option; `-mcpu=601' enables both the `-mpower' and
     `-mpowerpc' options; `-mcpu=603', `-mcpu=604', `-mcpu=403', and
     `-mcpu=powerpc' enable the `-mpowerpc' option and disable the
     `-mpower' option; `-mcpu=common' disables both the `-mpower' and
     `-mpowerpc' options.

     To generate code that will operate on all members of the RS/6000
     and PowerPC families, specify `-mcpu=common'.  In that case, GNU
     Pascal will use only the instructions in the common subset of both
     architectures plus some special AIX common-mode calls, and will
     not use the MQ register.  GNU Pascal assumes a generic processor
     model for scheduling purposes.

     Specifying `-mcpu=rios1', `-mcpu=rios2', `-mcpu=rsc', or
     `-mcpu=power' also disables the `new-mnemonics' option.
     Specifying `-mcpu=601', `-mcpu=603', `-mcpu=604', `403', or
     `-mcpu=powerpc' also enables the `new-mnemonics' option.

`-mfull-toc'
`-mno-fp-in-toc'
`-mno-sum-in-toc'
`-mminimal-toc'
     Modify generation of the TOC (Table Of Contents), which is created
     for every executable file.  The `-mfull-toc' option is selected by
     default.  In that case, GNU Pascal will allocate at least one TOC
     entry for each unique non-automatic variable reference in your
     program.  GNU Pascal will also place floating-point constants in
     the TOC.  However, only 16,384 entries are available in the TOC.

     If you receive a linker error message that saying you have
     overflowed the available TOC space, you can reduce the amount of
     TOC space used with the `-mno-fp-in-toc' and `-mno-sum-in-toc'
     options.  `-mno-fp-in-toc' prevents GNU Pascal from putting
     floating-point constants in the TOC and `-mno-sum-in-toc' forces
     GNU Pascal to generate code to calculate the sum of an address and
     a constant at run-time instead of putting that sum into the TOC.
     You may specify one or both of these options.  Each causes GNU
     Pascal to produce very slightly slower and larger code at the
     expense of conserving TOC space.

     If you still run out of space in the TOC even when you specify
     both of these options, specify `-mminimal-toc' instead.  This
     option causes GNU Pascal to make only one TOC entry for every
     file.  When you specify this option, GNU Pascal will produce code
     that is slower and larger but which uses extremely little TOC
     space.  You may wish to use this option only on files that contain
     less frequently executed code.

`-msoft-float'
`-mhard-float'
     Generate code that does not use (uses) the floating-point register
     set.  Software floating point emulation is provided if you use the
     `-msoft-float' option, and pass the option to GNU Pascal when
     linking.

`-mmultiple'
`-mno-multiple'
     Generate code that uses (does not use) the load multiple word
     instructions and the store multiple word instructions.  These
     instructions are generated by default on POWER systems, and not
     generated on PowerPC systems.  Do not use `-mmultiple' on little
     endian PowerPC systems, since those instructions do not work when
     the processor is in little endian mode.

`-mstring'
`-mno-string'
     Generate code that uses (does not use) the load string
     instructions and the store string word instructions to save
     multiple registers and do small block moves.  These instructions
     are generated by default on POWER systems, anod not generated on
     PowerPC systems.  Do not use `-mstring' on little endian PowerPC
     systems, since those instructions do not work when the processor
     is in little endian mode.

`-mno-bit-align'
`-mbit-align'
     On System V.4 and embedded PowerPC systems do not (do) force packed
     records to be aligned to the base type of the packed fields.

     For example, by default a record containing nothing but 8 Boolean
     fields would be aligned to a 4 byte boundary and have a size of 4
     bytes.  By using `-mno-bit-align', the record would be aligned to
     a 1 byte boundary and be one byte in size ... well--if `packed'
     would already work!

`-mno-strict-align'
`-mstrict-align'
     On System V.4 and embedded PowerPC systems do not (do) assume that
     unaligned memory references will be handled by the system.

`-mrelocatable'
`-mno-relocatable'
     On embedded PowerPC systems generate code that allows (does not
     allow) the program to be relocated to a different address at
     runtime.

`-mno-toc'
`-mtoc'
     On System V.4 and embedded PowerPC systems do not (do) assume that
     register 2 contains a pointer to a global area pointing to the
     addresses used in the program.

`-mno-traceback'
`-mtraceback'
     On embedded PowerPC systems do not (do) generate a traceback tag
     before the start of the function.  This tag can be used by the
     debugger to identify where the start of a function is.

`-mlittle'
`-mlittle-endian'
     On System V.4 and embedded PowerPC systems compile code for the
     processor in little endian mode.  The `-mlittle-endian' option is
     the same as `-mlittle'.

`-mbig'
`-mbig-endian'
     On System V.4 and embedded PowerPC systems compile code for the
     processor in big endian mode.  The `-mbig-endian' option is the
     same as `-mbig'.

`-mcall-sysv'
     On System V.4 and embedded PowerPC systems compile code using
     calling conventions that adheres to the March 1995 draft of the
     System V Application Binary Interface, PowerPC processor
     supplement.  This is the default unless you configured GPC using
     `powerpc-*-eabiaix'.

`-mcall-aix'
     On System V.4 and embedded PowerPC systems compile code using
     calling conventions that are similar to those used on AIX.  This
     is the default if you configured GPC using `powerpc-*-eabiaix'.

`-mprototype'

`-mno-prototype'
     On System V.4 and embedded PowerPC systems assume that all calls to
     variable argument functions are properly prototyped.  Otherwise,
     the compiler must insert an instruction before every non
     prototyped call to set or clear bit 6 of the condition code
     register (CR) to indicate whether floating point values were
     passed in the floating point registers in case the function takes
     a variable arguments.  With `-mprototype', only calls to
     prototyped variable argument functions will set or clear the bit.

