{
GPC demo program to show how to use external C routines with wrapper
code written in C, using flock() and signal() as examples. flock()
and signal() might not be completely portable, so this demo might
not work on some systems (especially non-Unix ones), but it can be
taken as a demo of a concept.

Copyright (C) 1999 Free Software Foundation, Inc.

Author: Frank Heckenbach <frank@pascal.gnu.de>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING. If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.

As a special exception, if you incorporate even large parts of the
code of this demo program into another program with substantially
different functionality, this does not cause the other program to
be covered by the GNU General Public License. This exception does
not however invalidate any other reasons why it might be covered
by the GNU General Public License.
}

program FileLockDemo;

uses GPC;

{$L filelock.c}
function FileLock   (FHandle : Integer; Exclusive, DontBlock : Boolean) : Integer; C;
function FileUnlock (FHandle : Integer) : Integer; C;
function SetTimerAction (Seconds : Integer; procedure Proc (Signal : Integer)) : Integer; C;

var
  a, b : Text;
  i : Integer;
  TempFileName : TString;

procedure TimerHandler (Signal : Integer);
begin
  Writeln ('Received signal `', StrSignal (Signal), '''.');
  Writeln ('Remove first exclusive lock, should succeed:         ', FileUnLock (FileHandle (a)))
end;

begin
  TempFileName := GetTempFileName;
  Rewrite (a, TempFileName);
  Reset   (b, TempFileName);
  Writeln ('0 means success, -1 means failure.');
  Writeln ('Non-exclusive lock, should succeed:                  ', FileLock (FileHandle (a), False, True));
  Writeln ('Another non-exclusive lock, should succeed:          ', FileLock (FileHandle (b), False, True));
  Writeln ('Exclusive lock, should fail:                         ', FileLock (FileHandle (a), True, True));
  Writeln ('Remove first lock, should succeed:                   ', FileUnLock (FileHandle (a)));
  Writeln ('Remove second lock, should succeed:                  ', FileUnLock (FileHandle (b)));
  Writeln ('Exclusive lock, should succeed now:                  ', FileLock (FileHandle (a), True, True));
  Writeln ('Another exclusive lock, should fail:                 ', FileLock (FileHandle (b), True, True));
  Writeln ('Install timer handler, should succeed:               ', SetTimerAction (5, TimerHandler));
  Writeln ('An exclusive lock with blocking, should block the program.');
  Writeln ('However, in 5 seconds, the program should get an `Alarm clock'' signal...');
  i := FileLock (FileHandle (b), True, False);
  Writeln ('The other exclusive lock should have failed,');
  Writeln ('because it was interrupted:                          ', i);
  Writeln ('Trying again to create this lock should succeed now: ', FileLock (FileHandle (b), True, False));
  Writeln ('Remove the lock, should succeed:                     ', FileUnLock (FileHandle (b)));
  Close (a);
  Erase (a)
end.
