# Specs file to building RPM of Linux to DJGPP cross-compiler
# Tested on Fedora Core 4. One may need to modify this file
# for other RPM based Linux distribution
Name: djcross-gcc
Summary:  GCC cross-compiler for target i586-pc-msdosdjgpp
Version: 4.1.2
Release: 1
License: GPL
Group: Development/Tools
URL: http://www.iki.fi/andris.pavenis/djgpp/gcc/cross-compiler
Source0: gcc-%{version}.tar.bz2
Source1: gcc411s2.zip
Buildroot: %{_tmppath}/%{name}-%{version}-%{release}-root
BuildArch: i686
Requires: djcrx djcross-binutils
BuildPrereq: gcc gcc-gnat gmp gmp-devel djcrx djcross-binutils autoconf >= 2.59 autoconf213 automake >= 1.9.4 automake14

%description 
Support of the following programing languages is included:
    C
    C++
    Fortran
    Objective C
    Objective C++
    Ada
%prep 
export SHORTVER=`echo %{version} | sed -e 's:\.::2g'`
export SHORTVER2=`echo %{version} | sed -e 's:\.::g'`
rm -rf $RPM_BUILD_DIR/%{name}-%{version} || exit 1
mkdir $RPM_BUILD_DIR/%{name}-%{version} || exit 1
ln -s $RPM_SOURCE_DIR/gcc-%{version}.tar.bz2 $RPM_BUILD_DIR/%{name}-%{version}/ || exit 1
cd $RPM_BUILD_DIR/%{name}-%{version} || exit 1
unzip -aq $RPM_SOURCE_DIR/gcc${SHORTVER2}s2.zip || exit 1
sed -e 's:^\(AUTOCONF_OLD=\).*$:\1/usr/bin/autoconf-2.13:' \
    -e 's:^\(AUTOHEADER_OLD=\).*$:\1/usr/bin/autoheader-2.13:' \
    -e 's:^\(exec .*\)$:#\1:' unpack-gcc.sh >unpack-gcc.sh.new
mv -f unpack-gcc.sh.new unpack-gcc.sh
sh unpack-gcc.sh || exit 1

%build 
cd $RPM_BUILD_DIR/%{name}-%{version}
export SHORTVER=`echo %{version} | sed -e 's:\.::2g'`
export SHORTVER2=`echo %{version} | sed -e 's:\.::g'`
export BUILD_NAME=`gnu/gcc-${SHORTVER}/config.guess`
#
mkdir -p /usr/lib/gcc/i586-pc-msdosdjgpp/%{version} || exit 1
mkdir tmpbuild || exit 1
cd tmpbuild || exit 1
../gnu/gcc-${SHORTVER}/configure --prefix=$RPM_BUILD_DIR/%{name}-%{version}/tmpinst \
			  --enable-languages=c,ada \
			  --enable-__cxa_atexit || exit 1
make bootstrap || exit 1
make install || exit 1
export PATH="$RPM_BUILD_DIR/%{name}-%{version}/tmpinst/bin:$PATH"
export LD_LIBRARY_PATH="$RPM_BUILD_DIR/%{name}-%{version}/tmpinst"
cd ..
#
mkdir djcross
cd djcross
mkdir -p /usr/lib/gcc/i586-pc-msdosdjgpp/%{version}
gcc -v >$RPM_BUILD_DIR/%{name}-%{version}/gccver.stmp 2>&1
../gnu/gcc-${SHORTVER}/configure --build=$BUILD_NAME \
			  --host=$BUILD_NAME \
			  --target=i586-pc-msdosdjgpp \
			  --prefix=/usr \
			  --disable-nls \
			  --enable-version-specific-runtime-libs \
			  --enable-languages=c,c++,f95,objc,obj-c++,ada || exit 1 
make || exit 1

%install 
rm -fr %{buildroot}

export STRIP=/bin/true
cd $RPM_BUILD_DIR/%{name}-%{version}/djcross
%makeinstall
( cd %{buildroot}/usr/bin && strip -v * )
rm -f %{buildroot}/usr/lib/libiberty.a
rm -fr %{buildroot}/usr/share/man/man7/*
rm -fr %{buildroot}/usr/share/info/*

( cd %{buildroot}/usr/libexec/gcc/i586-pc-msdosdjgpp/%{version} &&\
    strip -v cc1* collect2 f951 gnat1 install-tools/fixincl )
( cd %{buildroot}/usr/bin && mv gfortran i586-pc-msdosdjgpp-gfortran )
( cd %{buildroot}/usr/bin && mv gprmake i586-pc-msdosdjgpp-gprmake )

%clean 
rm -fr %{buildroot}

%files 
%defattr(-,root,root) 
/usr/bin/*
/usr/lib/gcc/*
/usr/libexec/gcc/*
/usr/i586-pc-msdosdjgpp/*
/usr/share/man/man1/*

%changelog
* Thu Mar  8 2007 Andris Pavenis <andris.pavenis@iki.fi>
- Update to GCC-4.1.2 (4.1.2-1)
 
* Tue May 30 2006 Andris Pavenis <andris.pavenis@iki.fi>
- Fixed libstdc++ name for cross-compiler (4.1.1-2)

* Sun May 28 2006 Andris Pavenis <andris.pavenis@iki.fi>
- Updated to GCC-4.1.1 (4.1.1-1)

* Fri Apr  7 2006 Andris Pavenis <andris.pavenis@iki.fi>
- Patched libssp directory to fix problem with generated
  gcc410s.zip. Cross-compiler itself does not change.

* Sat Mar  5 2006 Andris Pavenis <andris.pavenis@iki.fi>
- Bootstrap at first native compiler to be used for building 
  cross-compiler as one need to build cross-compiler with the
  same version of GCC (use of GCC-4.0.2 causes failure in 
  building Ada tools). Updates to DJGPP related patchset.

* Wed Mar  1 2006 Andris Pavenis <andris.pavenis@iki.fi>
- Updated for GCC-4.1.0

* Sun Feb 19 2006 Andris Pavenis <andris.pavenis@iki.fi>
- Added modification of readme.DJGPP according the version of GCC and DJGPP, as
  otherwise it is rather easy to forget to edit it manually when needed

* Mon Nov 15 2005 Andris Pavenis <pavenis@latnet.lv>
— Initial version of rpm spec file for DJGPP cross-compiler
