#! /bin/sh

ConfigureGCC () {
	./djconfig.sh;
}

BootstrapGCC () {
	./djmake.sh PFLAGS=-gstabs bootstrap
}

InstallTMP () {
	./djinsttmp.sh
}


MakePackages () {
	cd $TOP/../install.gcc 
	perl ./makepkg.pl
	cd $TOP
}

TestGpc () {
	cd $TOP/gcc
	stubedit gpc1.exe minstack=4096K
	make pascal.check EXTRA_TEST_PFLAGS=-gstabs
	cd $TOP
}

TOP=`pwd`

cd $TOP
echo "Configuring GCC ..."
ConfigureGCC >djconfig.log 2>&1 || exit 1;

cd $TOP
echo "Bootstrapping GCC ..."
BootstrapGCC >bootstrap.log 2>&1 || exit 1

cd $TOP
echo "Installing GCC in temporary directory ..."
InstallTMP >insttmp.log 2>&1 || exit 1

cd $TOP
echo "Creating binary packages ..."
MakePackages >makepkg.log 2>&1 || exit 1

cd $TOP
echo "Testing GPC ..."
TestGpc >test.log 2>&1 || exit 1
